/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.utils.notifications.EntityNotificationProcessingHandler;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransferNotificationProcessingHandlerImpl
extends BaseGlobalHandlerImpl
implements EntityNotificationProcessingHandler<Transfer> {
    @Autowired
    private TransferServiceLocal transferService;

    public NotificationProcessingEntityType<Transfer> getType() {
        return NotificationProcessingEntityType.TRANSFER;
    }

    public List<Transfer> loadToNotify(List<Long> list) {
        QTransfer qTransfer = QTransfer.transfer;
        return ((DBQuery)this.selectFrom(qTransfer).where((Predicate)qTransfer.id.in(list))).fetch();
    }

    public void process(Transfer transfer) {
        this.transferService.notifyTransferReceived(transfer);
    }
}

