/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransfer;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QTransferFee;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferFeeTransfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransferFeeRecipe;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransferFeePreviewVO;
import org.cyclos.model.banking.transactions.TransferFeesPreviewVO;
import org.cyclos.model.banking.transferfees.TransferFeeChargeMode;
import org.cyclos.model.banking.transferfees.TransferFeeConfigurationMode;
import org.cyclos.model.banking.transferfees.TransferFeeDTO;
import org.cyclos.model.banking.transferfees.TransferFeeData;
import org.cyclos.model.banking.transferfees.TransferFeeSubject;
import org.cyclos.model.banking.transferfees.TransferFeeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferFeeServiceImpl
extends CRUDServiceImpl<TransferFee, QTransferFee, TransferFeeDTO, TransferFeeData, TransferTypeVO>
implements TransferFeeServiceLocal {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public TransferFeeServiceImpl() {
        super(TransferFee.class, QTransferFee.transferFee, TransferFeeDTO.class);
    }

    public TransferFeeTransfer buildTransfer(PerformTransactionDTO performTransactionDTO, TransferFee transferFee, Transfer transfer) {
        Object object;
        ExternalAccountOwner externalAccountOwner;
        BigDecimal bigDecimal = transfer.getAmount();
        InternalAccountOwner internalAccountOwner = transfer.getFrom().getOwner();
        Object object2 = externalAccountOwner = transfer.getTo() == null ? ExternalAccountOwner.instance() : transfer.getTo().getOwner();
        if (!this.isApplicable(transferFee, bigDecimal, internalAccountOwner, (AccountOwner)externalAccountOwner)) {
            return null;
        }
        boolean bl = transferFee.getConfigurationMode() == TransferFeeConfigurationMode.SCRIPT;
        TransferFeeRecipe transferFeeRecipe = null;
        if (bl) {
            object = this.customScriptService.newAccessor(transferFee.getCustomScript(), transferFee.getCustomScriptParameters()).bind("previewParameters", (Object)performTransactionDTO).bind("fee", (Object)transferFee).bind("transfer", (Object)transfer).run();
            if (object instanceof CharSequence || object instanceof Number) {
                throw new CustomScriptException("The script " + transferFee.getCustomScript().getName() + " for transfer fee " + transferFee.getName() + " should return an object compatible with " + TransferFeeRecipe.class.getName());
            }
            transferFeeRecipe = (TransferFeeRecipe)this.conversionHandler.convert(TransferFeeRecipe.class, object);
        } else {
            object = transferFee.getGeneratedTransferType().getDirection();
            if (object == TransferTypeDirection.USER_TO_SELF && !this.mustBeUserToSelfGeneratedTransferType(transferFee.getPayer(), transferFee.getReceiver(), (IUser)transferFee.getPayerUser(), (IUser)transferFee.getReceiverUser(), transferFee.getOriginalTransferType())) {
                throw new IllegalActionException(String.format("Invalid generated transfer type direction: %s, for transfer fee: %s", object, transferFee.getName()));
            }
            transferFeeRecipe = new TransferFeeRecipe();
            transferFeeRecipe.setAmount(this.calculateAmount(performTransactionDTO, transferFee, transfer));
            transferFeeRecipe.setFromAccount(this.resolveAccount(transferFee, true, internalAccountOwner, (AccountOwner)externalAccountOwner));
            transferFeeRecipe.setToAccount(this.resolveAccount(transferFee, false, internalAccountOwner, (AccountOwner)externalAccountOwner));
            transferFeeRecipe.setType(transferFee.getGeneratedTransferType());
        }
        GeneratedTransferType generatedTransferType = object = transferFeeRecipe == null ? null : transferFeeRecipe.getType();
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)transferFeeRecipe.getAmount(), (int)object.getCurrency().getPrecision());
        if (!BigDecimalHelper.isPositive((BigDecimal)bigDecimal2)) {
            return null;
        }
        Account account = transferFeeRecipe.getFromAccount();
        if (account == null && transferFeeRecipe.getFrom() != null) {
            account = this.accountService.load(transferFeeRecipe.getFrom(), object.getFrom());
        }
        if (account == null) {
            return null;
        }
        Account account2 = transferFeeRecipe.getToAccount();
        if (account2 == null && transferFeeRecipe.getTo() != null) {
            account2 = this.accountService.load(transferFeeRecipe.getTo(), object.getTo());
        }
        if (account2 == null || account.equals((Object)account2)) {
            return null;
        }
        TransferFeeTransfer transferFeeTransfer = new TransferFeeTransfer();
        transferFeeTransfer.setTransaction(transfer.getTransaction());
        transferFeeTransfer.setType((TransferType)object);
        transferFeeTransfer.setTransferFee(transferFee);
        transferFeeTransfer.setParent(transfer);
        transferFeeTransfer.setAmount(bigDecimal2);
        transferFeeTransfer.setFrom(account);
        transferFeeTransfer.setTo(account2);
        transferFeeTransfer.setDate(transfer.getDate());
        return transferFeeTransfer;
    }

    public List<TransferFeeVO> list(TransferTypeVO transferTypeVO) {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        return this.conversionHandler.convertList(TransferFeeVO.class, this.listAll(transferType));
    }

    public List<TransferFee> listAll(TransferType transferType) {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QTransferFee)this.$).originalTransferType().eq((Object)transferType))).orderBy(((QTransferFee)this.$).name.asc())).list((Expression)this.$);
    }

    public List<TransferTypeWithCurrencyVO> listPossibleGeneratedTransferTypes(TransferFeeDTO transferFeeDTO) throws FrameworkException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferFeeDTO.getOriginalTransferType());
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.GENERATED));
        transferTypeQuery.setUnlimited();
        if (!transferFeeDTO.isOtherCurrency()) {
            transferTypeQuery.setCurrency(new CurrencyVO(transferType.getCurrency().getId()));
        }
        switch (transferFeeDTO.getPayer()) {
            case DESTINATION: {
                transferTypeQuery.setFromNature(transferType.getTo().getNature());
                break;
            }
            case FIXED_MEMBER: {
                transferTypeQuery.setFromOwner((InternalAccountOwner)this.conversionHandler.convert(User.class, (Object)transferFeeDTO.getPayerUser()));
                if (transferTypeQuery.getFromOwner() != null) break;
                transferTypeQuery.setFromNature(AccountTypeNature.USER);
                break;
            }
            case SOURCE: {
                transferTypeQuery.setFromNature(transferType.getFrom().getNature());
                break;
            }
            case SYSTEM: {
                transferTypeQuery.setFromNature(AccountTypeNature.SYSTEM);
                break;
            }
            case SOURCE_BROKER: 
            case DESTINATION_BROKER: {
                transferTypeQuery.setFromNature(AccountTypeNature.USER);
            }
        }
        switch (transferFeeDTO.getReceiver()) {
            case DESTINATION: {
                transferTypeQuery.setToNature(transferType.getTo().getNature());
                break;
            }
            case FIXED_MEMBER: {
                transferTypeQuery.setToOwner((AccountOwner)this.conversionHandler.convert(User.class, (Object)transferFeeDTO.getReceiverUser()));
                if (transferTypeQuery.getToOwner() != null) break;
                transferTypeQuery.setToNature(AccountTypeNature.USER);
                break;
            }
            case SOURCE: {
                transferTypeQuery.setToNature(transferType.getFrom().getNature());
                break;
            }
            case SYSTEM: {
                transferTypeQuery.setToNature(AccountTypeNature.SYSTEM);
                break;
            }
            case SOURCE_BROKER: 
            case DESTINATION_BROKER: {
                transferTypeQuery.setToNature(AccountTypeNature.USER);
            }
        }
        transferTypeQuery.setExcludingTransferTypes(CollectionHelper.asSet((Object[])new TransferTypeVO[]{new TransferTypeVO(transferType.getId())}));
        if (this.mustBeUserToSelfGeneratedTransferType(transferFeeDTO.getPayer(), transferFeeDTO.getReceiver(), (IUser)transferFeeDTO.getPayerUser(), (IUser)transferFeeDTO.getReceiverUser(), transferType)) {
            transferTypeQuery.setDirection(TransferTypeDirection.USER_TO_SELF);
        }
        if (transferTypeQuery.getDirection() == TransferTypeDirection.USER_TO_SELF) {
            return this.transferTypeService.search(TransferTypeWithCurrencyVO.class, transferTypeQuery).getPageItems();
        }
        List list = this.transferTypeService.search(GeneratedTransferType.class, transferTypeQuery).getPageItems().stream().filter(generatedTransferType -> generatedTransferType.getDirection() != TransferTypeDirection.USER_TO_SELF).collect(Collectors.toList());
        return this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list);
    }

    @Override
    public TransferFee newEntity(TransferTypeVO transferTypeVO) {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        TransferFee transferFee = new TransferFee();
        transferFee.setOriginalTransferType(transferType);
        transferFee.setConfigurationMode(TransferFeeConfigurationMode.FORM);
        transferFee.setPayer(TransferFeeSubject.SOURCE);
        transferFee.setReceiver(TransferFeeSubject.SYSTEM);
        transferFee.setChargeMode(TransferFeeChargeMode.PERCENTAGE);
        transferFee.setOtherCurrency(Boolean.valueOf(false));
        return transferFee;
    }

    public TransferFeesPreviewVO preview(PerformTransactionDTO performTransactionDTO, PaymentTransferType paymentTransferType, InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        Account account = this.getAndValidateAccount((AccountOwner)internalAccountOwner, paymentTransferType.getFrom());
        Account account2 = this.getAndValidateAccount((AccountOwner)internalAccountOwner2, paymentTransferType.getTo());
        PaymentTransfer paymentTransfer = new PaymentTransfer();
        paymentTransfer.setTransaction((Transaction)performTransactionDTO.getAttribute(TransactionData.TRANSACTION.getName()));
        paymentTransfer.setType((TransferType)paymentTransferType);
        paymentTransfer.setAmount(bigDecimal);
        paymentTransfer.setFrom(account);
        paymentTransfer.setTo(account2);
        TransferFeesPreviewVO transferFeesPreviewVO = new TransferFeesPreviewVO();
        ArrayList<TransferFeePreviewVO> arrayList = new ArrayList<TransferFeePreviewVO>();
        for (TransferFee transferFee : CollectionHelper.sort((Collection)paymentTransferType.getTransferFees())) {
            TransferFeeTransfer transferFeeTransfer = this.buildTransfer(performTransactionDTO, transferFee, (Transfer)paymentTransfer);
            if (transferFeeTransfer == null) continue;
            BigDecimal bigDecimal4 = transferFeeTransfer.getAmount();
            if (this.accountServiceSecurity.hasAccess(transferFeeTransfer.getFrom()) || this.accountServiceSecurity.hasAccess(transferFeeTransfer.getTo())) {
                TransferFeePreviewVO transferFeePreviewVO = (TransferFeePreviewVO)this.conversionHandler.convert(TransferFeePreviewVO.class, (Object)transferFee);
                transferFeePreviewVO.setAmount(ModelHelper.currencyAmount((CurrencyVO)((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)transferFeeTransfer.getCurrency())), (BigDecimal)bigDecimal4));
                transferFeePreviewVO.setFrom((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)transferFeeTransfer.getFrom()));
                transferFeePreviewVO.setTo((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)transferFeeTransfer.getTo()));
                transferFeePreviewVO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)transferFeeTransfer.getType()));
                arrayList.add(transferFeePreviewVO);
            }
            if (transferFee.isDeductAmount()) {
                bigDecimal2 = bigDecimal2.subtract(bigDecimal4);
            }
            if (!transferFeeTransfer.getFrom().equals((Object)paymentTransfer.getFrom())) continue;
            bigDecimal3 = bigDecimal3.add(bigDecimal4);
        }
        bigDecimal3 = bigDecimal3.add(bigDecimal2);
        transferFeesPreviewVO.setFees(arrayList);
        transferFeesPreviewVO.setMainAmount(ModelHelper.currencyAmount((CurrencyVO)((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency())), (BigDecimal)bigDecimal2));
        transferFeesPreviewVO.setTotalAmount(ModelHelper.currencyAmount((CurrencyVO)transferFeesPreviewVO.getMainAmount().getCurrency(), (BigDecimal)bigDecimal3));
        return transferFeesPreviewVO;
    }

    @Override
    protected TransferFeeData getData(TransferFee transferFee) {
        TransferFeeData transferFeeData = new TransferFeeData();
        transferFeeData.setDto((EntityDTO)((TransferFeeDTO)this.toDTO(transferFee)));
        transferFeeData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)transferFee.getOriginalTransferType().getFrom().getCurrency()));
        if (transferFee.getConfigurationMode() == TransferFeeConfigurationMode.FORM) {
            transferFeeData.setPossibleGeneratedTransferTypes(this.listPossibleGeneratedTransferTypes((TransferFeeDTO)transferFeeData.getDto()));
        }
        transferFeeData.setPossibleGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        transferFeeData.setCustomScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.TRANSFER_FEE_CALCULATION)));
        return transferFeeData;
    }

    @Override
    protected Object onBeforeSave(TransferFee transferFee, TransferFee transferFee2) {
        TransferType transferType = transferFee.getOriginalTransferType();
        if (AccountTypeNature.SYSTEM == transferType.getFrom().getNature()) {
            transferFee.setFromGroups(null);
        }
        if (AccountTypeNature.SYSTEM == transferType.getTo().getNature()) {
            transferFee.setToGroups(null);
        }
        if (transferFee.getConfigurationMode() == TransferFeeConfigurationMode.FORM) {
            boolean bl;
            boolean bl2 = bl = transferType.getFrom().getNature() == AccountTypeNature.SYSTEM;
            if (!(transferFee.getPayer() == TransferFeeSubject.SOURCE || transferFee.getPayer() == TransferFeeSubject.SYSTEM && bl)) {
                transferFee.setDeductAmount(false);
            }
            if (transferFee.getChargeMode() != TransferFeeChargeMode.CUSTOM) {
                transferFee.setCustomScript(null);
                transferFee.setCustomScriptParameters(null);
            }
        } else {
            transferFee.setAmount(null);
            transferFee.setChargeMode(null);
            transferFee.setGeneratedTransferType(null);
            transferFee.setOtherCurrency(null);
            transferFee.setPayer(null);
            transferFee.setPayerUser(null);
            transferFee.setReceiver(null);
            transferFee.setReceiverUser(null);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(TransferFeeDTO transferFeeDTO, TransferFee transferFee) {
        transferFee.getToGroups().size();
        transferFee.getFromGroups().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransferFee)this.$).originalTransferType().from().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(TransferFeeDTO transferFeeDTO) {
        boolean bl;
        TransferType transferType;
        Validator validator = new Validator();
        if (transferFeeDTO.isPersistent()) {
            transferType = ((TransferFee)this.find(transferFeeDTO.getId())).getOriginalTransferType();
        } else {
            validator.property((Property)TransferFeeDTO.ORIGINAL_TRANSFER_TYPE, BankingKeys.TransferFees.ORIGINAL_TRANSFER_TYPE).required();
            transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferFeeDTO.getOriginalTransferType());
        }
        validator.property((Property)TransferFeeDTO.CONFIGURATION_MODE, BankingKeys.TransferFees.CONFIGURATION_MODE).required();
        validator.property(TransferFeeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        boolean bl2 = bl = transferFeeDTO.getConfigurationMode() == TransferFeeConfigurationMode.SCRIPT || transferFeeDTO.getChargeMode() == TransferFeeChargeMode.CUSTOM;
        if (transferFeeDTO.getConfigurationMode() == TransferFeeConfigurationMode.FORM) {
            org.cyclos.impl.utils.validation.Property property;
            validator.property((Property)TransferFeeDTO.CHARGE_MODE, BankingKeys.TransferFees.CHARGE_MODE).required();
            if (transferFeeDTO.getPayer() == TransferFeeSubject.FIXED_MEMBER) {
                validator.property((Property)TransferFeeDTO.PAYER_USER, BankingKeys.TransferFees.PAYER_USER).required();
            }
            if (transferFeeDTO.getReceiver() == TransferFeeSubject.FIXED_MEMBER) {
                validator.property((Property)TransferFeeDTO.RECEIVER_USER, BankingKeys.TransferFees.RECEIVER_USER).required();
            }
            EnumSet<TransferFeeSubject> enumSet = EnumSet.allOf(TransferFeeSubject.class);
            if (transferType.isFromSystem()) {
                enumSet.removeAll(EnumSet.of(TransferFeeSubject.SOURCE, TransferFeeSubject.SOURCE_BROKER));
            }
            if (transferType.isToSystem()) {
                enumSet.removeAll(EnumSet.of(TransferFeeSubject.DESTINATION, TransferFeeSubject.DESTINATION_BROKER));
            }
            validator.property((Property)TransferFeeDTO.PAYER, BankingKeys.TransferFees.PAYER).anyOf(enumSet);
            validator.property((Property)TransferFeeDTO.RECEIVER, BankingKeys.TransferFees.RECEIVER).anyOf(enumSet);
            DecimalRangeDTO decimalRangeDTO = transferFeeDTO.getAmountRange();
            if (decimalRangeDTO != null && ObjectHelper.coalesce((Object[])new BigDecimal[]{decimalRangeDTO.getMin(), decimalRangeDTO.getMax()}) != null) {
                if (decimalRangeDTO.getMin() != null) {
                    validator.property((Property)NestedProperty.nested((Property)TransferFeeDTO.AMOUNT_RANGE, (Property)DecimalRangeDTO.MIN), BankingKeys.TransferFees.HIGHER_THAN_AMOUNT_VALUE).positiveNonZero((HasCurrency)transferType);
                }
                if (decimalRangeDTO.getMax() != null) {
                    property = validator.property((Property)NestedProperty.nested((Property)TransferFeeDTO.AMOUNT_RANGE, (Property)DecimalRangeDTO.MAX), BankingKeys.TransferFees.LOWER_THAN_AMOUNT_VALUE).positiveNonZero((HasCurrency)transferType);
                    if (decimalRangeDTO.getMin() != null) {
                        property.greaterEquals((Comparable)decimalRangeDTO.getMin());
                    }
                }
            }
            validator.property((Property)TransferFeeDTO.GENERATED_TRANSFER_TYPE, BankingKeys.TransferFees.GENERATED_TRANSFER_TYPE).required().anyOf(this.listPossibleGeneratedTransferTypes(transferFeeDTO)).entity(GeneratedTransferType.class, (object, object2, generatedTransferType) -> {
                Set set = CollectionHelper.asSet((Object[])new TransferType[]{generatedTransferType});
                List<TransferFee> list = this.getCycle((TransferType)generatedTransferType, set);
                if (CollectionHelper.isNotEmpty(list)) {
                    list = new ArrayList<TransferFee>(list);
                    TransferFee transferFee = new TransferFee();
                    transferFee.setName(transferFeeDTO.getName());
                    transferFee.setOriginalTransferType(transferType);
                    transferFee.setGeneratedTransferType(generatedTransferType);
                    list.add(transferFee);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (TransferFee transferFee2 : list) {
                        stringBuilder.append(this.message(MessageFormat.HTML, BankingKeys.TransferFees.ERROR_CYCLE_ENTRY, transferFee2, transferFee2.getOriginalTransferType(), transferFee2.getOriginalTransferType().getFrom(), transferFee2.getGeneratedTransferType()));
                    }
                    ValidationError validationError = new ValidationError(BankingKeys.TransferFees.ERROR_CYCLE, new Object[]{stringBuilder});
                    validationError.setFormat(MessageFormat.HTML);
                    return validationError;
                }
                return null;
            });
            if (!bl) {
                property = validator.property((Property)TransferFeeDTO.AMOUNT, BankingKeys.TransferFees.AMOUNT);
                property.required();
                if (transferFeeDTO.getChargeMode() == TransferFeeChargeMode.FIXED) {
                    TransferType transferType2 = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferFeeDTO.getGeneratedTransferType());
                    property.positiveNonZero((HasCurrency)transferType2);
                } else {
                    property.positiveNonZero(BigDecimalHelper.MAX_SCALE);
                }
            }
        } else if (bl) {
            validator.property((Property)TransferFeeDTO.CUSTOM_SCRIPT, BankingKeys.TransferFees.CUSTOM_SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.TRANSFER_FEE_CALCULATION;
                }
            });
        }
        return validator;
    }

    private BigDecimal calculateAmount(PerformTransactionDTO performTransactionDTO, TransferFee transferFee, Transfer transfer) {
        switch (transferFee.getChargeMode()) {
            case FIXED: {
                return transferFee.getAmount();
            }
            case PERCENTAGE: {
                return transferFee.getAmount().multiply(transfer.getAmount());
            }
            case CUSTOM: {
                return (BigDecimal)this.customScriptService.newAccessor(transferFee.getCustomScript(), transferFee.getCustomScriptParameters()).bind("previewParameters", (Object)performTransactionDTO).bind("fee", (Object)transferFee).bind("transfer", (Object)transfer).run(BigDecimal.class);
            }
        }
        throw new IllegalStateException("Invalid charge type: " + String.valueOf(transferFee.getChargeMode()));
    }

    private Account getAndValidateAccount(AccountOwner accountOwner, AccountType accountType) {
        if (accountOwner == null) {
            return null;
        }
        try {
            return this.accountService.load((InternalAccountOwner)accountOwner, accountType);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            String string = this.getFormatter().format(accountOwner);
            String string2 = this.getTranslatedName((NamedEntity)accountType);
            String string3 = this.message(BankingKeys.Transfers.ERROR_ACCOUNT_NOT_FOUND, string, string2);
            throw new ValidationException(new ValidationResult(string3));
        }
    }

    private List<TransferFee> getCycle(TransferType transferType, Set<TransferType> set) {
        List<TransferFee> list = this.listAll(transferType);
        for (TransferFee transferFee : list) {
            GeneratedTransferType generatedTransferType = transferFee.getGeneratedTransferType();
            if (set.contains(generatedTransferType)) {
                return Collections.singletonList(transferFee);
            }
            set.add((TransferType)generatedTransferType);
            List<TransferFee> list2 = this.getCycle((TransferType)generatedTransferType, set);
            if (!list2.isEmpty()) {
                ArrayList<TransferFee> arrayList = new ArrayList<TransferFee>(list2.size() + 1);
                arrayList.addAll(list2);
                arrayList.add(transferFee);
                return arrayList;
            }
            set.remove(generatedTransferType);
        }
        return Collections.emptyList();
    }

    private boolean isApplicable(TransferFee transferFee, BigDecimal bigDecimal, InternalAccountOwner internalAccountOwner, AccountOwner accountOwner) {
        Object object;
        BigDecimal bigDecimal2;
        if (transferFee == null || !transferFee.isEnabled()) {
            return false;
        }
        DecimalRange decimalRange = transferFee.getAmountRange();
        if (decimalRange != null) {
            int n;
            bigDecimal2 = decimalRange.getMax();
            object = decimalRange.getMin();
            if (object != null && bigDecimal2 != null ? ((n = BigDecimalHelper.compareTo((BigDecimal)bigDecimal2, (BigDecimal)object)) > 0 ? BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0 || BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)object) < 0 : (n < 0 ? BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0 && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)object) < 0 : BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) != 0)) : object != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)object) < 0 || bigDecimal2 != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0) {
                return false;
            }
        }
        if (internalAccountOwner instanceof User && CollectionHelper.isNotEmpty((Iterable)transferFee.getFromGroups())) {
            bigDecimal2 = ((User)internalAccountOwner).getGroup();
            object = this.groupsHandler.flatten((Collection)transferFee.getFromGroups());
            if (!object.contains(bigDecimal2)) {
                return false;
            }
        }
        if (accountOwner instanceof User && CollectionHelper.isNotEmpty((Iterable)transferFee.getToGroups())) {
            bigDecimal2 = ((User)accountOwner).getGroup();
            object = this.groupsHandler.flatten((Collection)transferFee.getToGroups());
            if (!object.contains(bigDecimal2)) {
                return false;
            }
        }
        if (transferFee.getConfigurationMode() == TransferFeeConfigurationMode.FORM) {
            User user;
            User user2;
            bigDecimal2 = transferFee.getPayer();
            object = transferFee.getReceiver();
            if (!(bigDecimal2 != TransferFeeSubject.SOURCE_BROKER && object != TransferFeeSubject.SOURCE_BROKER || (user2 = (User)ObjectHelper.ifType((Object)internalAccountOwner, User.class)) != null && user2.getMainBroker() != null)) {
                return false;
            }
            if (!(bigDecimal2 != TransferFeeSubject.DESTINATION_BROKER && object != TransferFeeSubject.DESTINATION_BROKER || (user = (User)ObjectHelper.ifType((Object)accountOwner, User.class)) != null && user.getMainBroker() != null)) {
                return false;
            }
        }
        return true;
    }

    private boolean mustBeUserToSelfGeneratedTransferType(TransferFeeSubject transferFeeSubject, TransferFeeSubject transferFeeSubject2, IUser iUser, IUser iUser2, TransferType transferType) {
        return transferFeeSubject != TransferFeeSubject.SYSTEM && transferFeeSubject.equals((Object)transferFeeSubject2) && (transferFeeSubject != TransferFeeSubject.FIXED_MEMBER || iUser != null && iUser.equals((Object)iUser2)) || transferType.getDirection() == TransferTypeDirection.USER_TO_SELF && (transferFeeSubject == TransferFeeSubject.SOURCE && transferFeeSubject2 == TransferFeeSubject.DESTINATION || transferFeeSubject == TransferFeeSubject.SOURCE_BROKER && transferFeeSubject2 == TransferFeeSubject.DESTINATION_BROKER);
    }

    private Account resolveAccount(TransferFee transferFee, boolean bl, InternalAccountOwner internalAccountOwner, AccountOwner accountOwner) {
        InternalAccountOwner internalAccountOwner2;
        TransferFeeSubject transferFeeSubject = bl ? transferFee.getPayer() : transferFee.getReceiver();
        switch (transferFeeSubject) {
            case DESTINATION: {
                internalAccountOwner2 = accountOwner instanceof InternalAccountOwner ? (InternalAccountOwner)accountOwner : null;
                break;
            }
            case FIXED_MEMBER: {
                internalAccountOwner2 = bl ? transferFee.getPayerUser() : transferFee.getReceiverUser();
                break;
            }
            case SOURCE: {
                internalAccountOwner2 = internalAccountOwner;
                break;
            }
            case SYSTEM: {
                internalAccountOwner2 = SystemAccountOwner.instance();
                break;
            }
            case DESTINATION_BROKER: {
                internalAccountOwner2 = accountOwner instanceof User ? ((User)accountOwner).getMainBroker() : null;
                break;
            }
            case SOURCE_BROKER: {
                internalAccountOwner2 = ((User)internalAccountOwner).getMainBroker();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid account owner: " + String.valueOf(transferFee.getPayer()));
            }
        }
        GeneratedTransferType generatedTransferType = transferFee.getGeneratedTransferType();
        AccountType accountType = bl ? generatedTransferType.getFrom() : generatedTransferType.getTo();
        try {
            return this.accountService.load(internalAccountOwner2, accountType);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }
}

