/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.banking.transactions.RecurringPaymentDTO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionConverter
extends BaseEntityConverter<Transaction> {
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TicketServiceLocal ticketService;

    public TransactionConverter() {
        super(Transaction.class);
    }

    @Override
    protected Transaction instantiate(Class<Transaction> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        TransactionVO transactionVO;
        Object object2;
        if (object instanceof TicketVO && clazz.equals(Ticket.class)) {
            object2 = (TicketVO)object;
            if (StringHelper.isNotBlank((Object)object2.getTicketNumber())) {
                return this.ticketService.findByTicketNumber(object2.getTicketNumber());
            }
            if (this.getSessionData().isGuest()) {
                throw new EntityNotFoundException(Ticket.class);
            }
        }
        object2 = null;
        if (object instanceof CharSequence) {
            object2 = object.toString();
        } else if (object instanceof TransactionVO) {
            transactionVO = (TransactionVO)object;
            object2 = transactionVO.getTransactionNumber();
        } else if (object instanceof RecurringPaymentDTO) {
            object2 = ((RecurringPaymentDTO)object).getTransactionNumber();
        }
        if (StringHelper.isNotBlank((Object)object2)) {
            transactionVO = this.transactionService.findByTransactionNumber((String)object2);
            if (!clazz.isAssignableFrom(transactionVO.getClass())) {
                throw new EntityNotFoundException(clazz);
            }
            return transactionVO;
        }
        return super.instantiate(clazz, object, conversionContext);
    }
}

