/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import ext.java.math.QBigDecimal;
import ext.java.util.QDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.QAccountType;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QBrokering;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.RestrictedOperatorAccessibleAccounts;
import org.cyclos.impl.banking.TransQueryHandler;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.TransOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TransQueryHandlerImpl<Q extends AbstractTransQuery, P extends BuildTransQueryParams<Q>>
extends BaseNetworkedHandlerImpl
implements TransQueryHandler<Q, P> {
    protected final QTransferType tt = QTransferType.transferType;
    protected final QAccount fa = new QAccount("fa");
    protected final QAccountType fat = new QAccountType("fat");
    protected final QUser fu = new QUser("fu");
    protected final QGroup fg = new QGroup("fg");
    protected final QAccount ta = new QAccount("ta");
    protected final QAccountType tat = new QAccountType("tat");
    protected final QUser tu = new QUser("tu");
    protected final QGroup tg = new QGroup("tg");
    protected final QCurrency c = QCurrency.currency;
    protected QTransaction tx;
    protected NumberPath<Long> id;
    protected StringPath transactionNumber;
    protected QDate date;
    protected QBigDecimal amount;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected GroupsHandler groupsHandler;
    @Autowired
    protected AccountServiceLocal accountService;
    @Autowired
    protected TransactionCustomFieldServiceLocal transactionCustomFieldService;

    public DBQuery<?> build(P p) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Set set;
        Set set2;
        BooleanExpression booleanExpression;
        BasicUser basicUser;
        DecimalRange decimalRange;
        AbstractTransQuery abstractTransQuery = p.getParams();
        SessionData sessionData = this.getSessionData();
        DBQuery<?> dBQuery = this.initQuery(p);
        Network network = sessionData.getNetwork();
        if (network == null) {
            dBQuery.where((Predicate)this.c.network().isNull());
        } else {
            dBQuery.where((Predicate)this.c.network().eq((Object)network).or((Predicate)this.c.network().isNull()));
        }
        if (QueryHelper.useParameter((Object)abstractTransQuery.getTransactionNumber())) {
            dBQuery.where((Predicate)this.transactionNumber.equalsIgnoreCase(abstractTransQuery.getTransactionNumber()));
        }
        if (QueryHelper.useParameter((Object)abstractTransQuery.getPeriod())) {
            dBQuery.where(this.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)abstractTransQuery.getPeriod())));
        }
        if (QueryHelper.useParameter((Object)(decimalRange = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, (Object)abstractTransQuery.getAmount())))) {
            dBQuery.where(this.amount.range(decimalRange));
        }
        if (QueryHelper.useParameter((Object)abstractTransQuery.getDescription())) {
            dBQuery.where((Predicate)this.tx.description.containsIgnoreCase(abstractTransQuery.getDescription()));
        }
        if (QueryHelper.useParameter((Object)abstractTransQuery.getExcludedIds())) {
            dBQuery.where((Predicate)this.id.notIn((Collection)abstractTransQuery.getExcludedIds()));
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)abstractTransQuery.getBy())) != null) {
            booleanExpression = this.tx.by().eq((Object)basicUser);
            if (basicUser.isOperator()) {
                booleanExpression = booleanExpression.or((Predicate)this.tx.receivedBy()._super.eq((Object)basicUser));
            }
            dBQuery.where((Predicate)booleanExpression);
        }
        if ((booleanExpression = (User)this.conversionHandler.convert(User.class, (Object)abstractTransQuery.getUser())) != null) {
            dBQuery.where((Predicate)this.fu.eq((Object)booleanExpression).or((Predicate)this.tu.eq((Object)booleanExpression)));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set2 = this.groupsHandler.flattenVOs((Collection)abstractTransQuery.getGroups())))) {
            dBQuery.where((Predicate)this.fg.in((Collection)set2).or((Predicate)this.tg.in((Collection)set2)));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.conversionHandler.convertSet(User.class, (Iterable)abstractTransQuery.getBrokers())))) {
            object4 = QBrokering.brokering;
            object3 = this.rawEntityManagerHandler.subQuery(new EntityPath[]{object4});
            object3.where(new Predicate[]{object4.user().eq((Expression)this.fu).or((Predicate)object4.user().eq((Expression)this.tu)), object4.broker().in((Collection)set), ((QBrokering)object4).endDate.isNull().or((Predicate)((QBrokering)object4).endDate.after((Expression)DateTimeExpression.currentTimestamp()))});
            dBQuery.where((Predicate)object3.exists());
        }
        if (QueryHelper.useParameter((Object)abstractTransQuery.getChannels())) {
            object4 = this.conversionHandler.convertSet(Channel.class, (Iterable)abstractTransQuery.getChannels());
            object3 = this.tx.channel().in((Collection)object4);
            if (object4.stream().anyMatch(Channel::isMain)) {
                object3 = object3.or((Predicate)this.tx.channel().isNull());
            }
            dBQuery.where((Predicate)object3);
        }
        if (abstractTransQuery.isFromCurrentAccessClient()) {
            object4 = sessionData.getAccessClient();
            if (object4 == null) {
                dBQuery.where((Predicate)this.tt.isNull());
            } else {
                abstractTransQuery.setAccessClients(Collections.singleton(new AccessClientVO(object4.getId())));
            }
        }
        if (!(object4 = this.conversionHandler.convertSet(AccessClient.class, (Iterable)abstractTransQuery.getAccessClients())).isEmpty()) {
            object3 = this.tx.accessClient().in((Collection)object4);
            if (abstractTransQuery.isIncludeGeneratedByAccessClient()) {
                object2 = new QTransaction("transaction2");
                object3 = object3.or((Predicate)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{object2}).where(new Predicate[]{object2.transaction().id.eq((Expression)this.tx.id), object2.accessClient().in((Collection)object4)})).exists());
            }
            dBQuery.where((Predicate)object3);
        }
        if (QueryHelper.useParameter((Object)(object3 = this.conversionHandler.convertSet(TransferType.class, (Iterable)abstractTransQuery.getTransferTypes())))) {
            dBQuery.where((Predicate)this.tt._super.in((Collection)object3));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object2 = this.conversionHandler.convertSet(TransferFilter.class, (Iterable)abstractTransQuery.getTransferFilters())))) {
            object = object2.stream().flatMap(transferFilter -> transferFilter.getTransferTypes().stream()).collect(Collectors.toSet());
            if (CollectionHelper.isEmpty((Iterable)object)) {
                dBQuery.where((Predicate)this.tt.id.isNull());
            } else {
                dBQuery.where((Predicate)this.tt._super.in((Collection)object));
            }
        }
        object = (TransactionOrderBy)ObjectHelper.defaultValue((Object)abstractTransQuery.getOrderBy(), (Object)this.getDefaultOrder());
        switch (object) {
            case DATE_DESC: {
                dBQuery.orderBy(this.date.desc());
                break;
            }
            case DATE_ASC: {
                dBQuery.orderBy(this.date.asc());
                break;
            }
            case AMOUNT_DESC: {
                dBQuery.orderBy(this.amount.desc());
                break;
            }
            case AMOUNT_ASC: {
                dBQuery.orderBy(this.amount.asc());
            }
        }
        dBQuery.orderBy(this.id.asc());
        this.applyVisibility(sessionData, dBQuery, p);
        List list = this.transactionCustomFieldService.listVisibleForSearch(abstractTransQuery);
        Set set3 = abstractTransQuery.getCustomValues();
        if (CollectionHelper.isNotEmpty((Iterable)list) && CollectionHelper.isNotEmpty((Iterable)set3)) {
            for (TransactionCustomField transactionCustomField : list) {
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO;
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO2 = null;
                QTransactionCustomFieldValue qTransactionCustomFieldValue = set3.iterator();
                while (qTransactionCustomFieldValue.hasNext()) {
                    customFieldValueForSearchDTO = (CustomFieldValueForSearchDTO)qTransactionCustomFieldValue.next();
                    TransactionCustomField transactionCustomField2 = (TransactionCustomField)this.conversionHandler.convert(TransactionCustomField.class, (Object)customFieldValueForSearchDTO.getField());
                    if (!transactionCustomField.equals((Object)transactionCustomField2)) continue;
                    customFieldValueForSearchDTO2 = customFieldValueForSearchDTO;
                    break;
                }
                if (customFieldValueForSearchDTO2 == null || (customFieldValueForSearchDTO = this.customFieldValueHandler.queryFilter((EntityPath)(qTransactionCustomFieldValue = new QTransactionCustomFieldValue("fv_" + transactionCustomField.getId())), (CustomField)transactionCustomField, customFieldValueForSearchDTO2)) == null) continue;
                ((DBQuery)dBQuery.from((EntityPath)qTransactionCustomFieldValue)).where(new Predicate[]{qTransactionCustomFieldValue.field().eq((Object)transactionCustomField), qTransactionCustomFieldValue.owner().eq((Expression)this.tx), customFieldValueForSearchDTO});
            }
        }
        if (abstractTransQuery instanceof TransOverviewQuery) {
            this.applyOverview(dBQuery, p);
        } else {
            this.applyOwned(dBQuery, p);
        }
        return dBQuery;
    }

    public QBigDecimal getAmountPath() {
        return this.amount;
    }

    public QCurrency getCurrencyPath() {
        return this.c;
    }

    public QDate getDatePath() {
        return this.date;
    }

    public QAccount getFromAccountPath() {
        return this.fa;
    }

    public QAccountType getFromAccountTypePath() {
        return this.fat;
    }

    public QGroup getFromGroupPath() {
        return this.fg;
    }

    public QUser getFromUserPath() {
        return this.fu;
    }

    public NumberPath<Long> getIdPath() {
        return this.id;
    }

    public QTransferType geTransferTypePath() {
        return this.tt;
    }

    public QAccount getToAccountPath() {
        return this.ta;
    }

    public QAccountType getToAccountTypePath() {
        return this.tat;
    }

    public QGroup getToGroupPath() {
        return this.tg;
    }

    public QUser getToUserPath() {
        return this.tu;
    }

    public StringPath getTransactionNumberPath() {
        return this.transactionNumber;
    }

    public QTransaction getTransactionPath() {
        return this.tx;
    }

    public QTransferType getTransferTypePath() {
        return this.tt;
    }

    protected Predicate additionalAdminFilter(SessionData sessionData) {
        return null;
    }

    protected Predicate additionalBrokerFilter(SessionData sessionData) {
        return null;
    }

    protected Predicate additionalRestrictedOperatorFilter(SessionData sessionData) {
        return null;
    }

    protected void applyOverview(DBQuery<?> dBQuery, P p) {
        Set set;
        Set set2;
        TransOverviewQuery transOverviewQuery = (TransOverviewQuery)p.getParams();
        Set set3 = this.conversionHandler.convertSet(Currency.class, (Iterable)transOverviewQuery.getCurrencies());
        if (CollectionHelper.isNotEmpty((Iterable)set3)) {
            dBQuery.where((Predicate)this.c.in((Collection)set3));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)transOverviewQuery.getFromAccounts())))) {
            dBQuery.where((Predicate)this.fat.in((Collection)set2));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.conversionHandler.convertSet(AccountType.class, (Iterable)transOverviewQuery.getToAccounts())))) {
            dBQuery.where((Predicate)this.tat.in((Collection)set));
        }
    }

    protected abstract void applyOwned(DBQuery<?> var1, P var2);

    protected void applyVisibility(SessionData sessionData, DBQuery<?> dBQuery, P p) {
        if (!sessionData.isSystem()) {
            this.doApplyVisibility(sessionData, dBQuery, p);
        }
    }

    protected void doApplyVisibility(SessionData sessionData, DBQuery<?> dBQuery, P p) {
        Object object = sessionData.isAdmin() ? this.getAdminFilters(sessionData, p) : (sessionData.isRestrictedOperator() ? this.getRestrictedOperatorFilters(sessionData) : (sessionData.isBroker() ? this.getBrokerFilters(sessionData) : (sessionData.isMember() ? this.getMemberFilters(sessionData) : null)));
        if (object == null) {
            dBQuery.where((Predicate)this.tt.isNull());
        } else {
            dBQuery.where(object);
        }
    }

    protected Predicate getAdminFilters(SessionData sessionData, P p) {
        Predicate predicate;
        AbstractTransQuery abstractTransQuery = p.getParams();
        boolean bl = abstractTransQuery instanceof TransactionOverviewQuery && ((TransactionOverviewQuery)abstractTransQuery).isPendingMyAuthorization();
        List list = sessionData.getProducts().admin().getSystemAccounts();
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            booleanBuilder.or((Predicate)this.fat.in((Collection)list));
            if (!bl) {
                booleanBuilder.or((Predicate)this.tat.in((Collection)list));
            }
        }
        List list2 = sessionData.getProducts().admin().getUserAccountsAccess();
        Set set = this.groupsHandler.accessibles().users().items();
        if (CollectionHelper.isNotEmpty((Iterable)list2) && CollectionHelper.isNotEmpty((Iterable)set)) {
            booleanBuilder.or((Predicate)this.fg.in((Collection)set).and((Predicate)this.fat.in((Collection)list2)));
            if (!bl) {
                booleanBuilder.or((Predicate)this.tg.in((Collection)set).and((Predicate)this.tat.in((Collection)list2)));
            }
        }
        if ((predicate = this.additionalAdminFilter(sessionData)) != null) {
            booleanBuilder = new BooleanBuilder(predicate).and((Predicate)booleanBuilder);
        }
        return booleanBuilder;
    }

    protected Predicate getBrokerFilters(SessionData sessionData) {
        Predicate predicate = this.getMemberFilters(sessionData);
        Predicate predicate2 = this.getBrokeringFilters(sessionData);
        if (predicate == null || predicate2 == null) {
            return (Predicate)ObjectHelper.defaultValue((Object)predicate, (Object)predicate2);
        }
        return new BooleanBuilder(predicate).or(predicate2);
    }

    protected Predicate getBrokeringFilters(SessionData sessionData) {
        User user = sessionData.getLoggedUser();
        List list = sessionData.getProducts().broker().getUserAccountsAccess();
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            QBrokering qBrokering = QBrokering.brokering;
            QAccount qAccount = QAccount.account;
            booleanBuilder = new BooleanBuilder(this.additionalBrokerFilter(sessionData));
            booleanBuilder.and((Predicate)this.fa.id.in((SubQueryExpression)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qBrokering, qAccount}).where(new Predicate[]{qBrokering.user().eq((Expression)qAccount.user()), qBrokering.broker().eq((Object)user), qBrokering.endDate.isNull().or((Predicate)qBrokering.endDate.after((Expression)Expressions.currentTimestamp()))})).select((Expression)qAccount.id)).or((Predicate)this.ta.id.in((SubQueryExpression)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qBrokering, qAccount}).where(new Predicate[]{qBrokering.user().eq((Expression)qAccount.user()), qBrokering.broker().eq((Object)user), qBrokering.endDate.isNull().or((Predicate)qBrokering.endDate.after((Expression)Expressions.currentTimestamp()))})).select((Expression)qAccount.id))));
        }
        return booleanBuilder;
    }

    protected TransactionOrderBy getDefaultOrder() {
        return TransactionOrderBy.DATE_DESC;
    }

    protected Predicate getMemberFilters(SessionData sessionData) {
        User user = sessionData.getLoggedUser();
        return this.fu.eq((Object)user).or((Predicate)this.tu.eq((Object)user));
    }

    protected Predicate getRestrictedOperatorFilters(SessionData sessionData) {
        User user;
        Operator operator = sessionData.getLoggedOperator();
        RestrictedOperatorAccessibleAccounts restrictedOperatorAccessibleAccounts = this.accountService.getRetrictedOperatorAccessibleAccounts();
        BooleanBuilder booleanBuilder = null;
        if (restrictedOperatorAccessibleAccounts.isAnyVisible()) {
            Set set;
            Set set2;
            user = operator.getUser();
            BooleanBuilder booleanBuilder2 = new BooleanBuilder();
            Set set3 = restrictedOperatorAccessibleAccounts.getOwnPayments();
            if (!set3.isEmpty()) {
                booleanBuilder2.or((Predicate)this.fat.in((Collection)set3).and((Predicate)this.fu.eq((Object)user)).or((Predicate)this.tat.in((Collection)set3).and((Predicate)this.tu.eq((Object)user))).and((Predicate)this.tx.by().eq((Object)operator).or((Predicate)this.tx.receivedBy().eq((Object)operator))));
            }
            if (!(set2 = restrictedOperatorAccessibleAccounts.getIncoming()).isEmpty()) {
                booleanBuilder2.or((Predicate)this.tat.in((Collection)set2).and((Predicate)this.tu.eq((Object)user)));
            }
            if (!(set = restrictedOperatorAccessibleAccounts.getOutgoing()).isEmpty()) {
                booleanBuilder2.or((Predicate)this.fat.in((Collection)set).and((Predicate)this.fu.eq((Object)user)));
            }
            booleanBuilder = booleanBuilder2.and(this.additionalRestrictedOperatorFilter(sessionData));
        }
        user = null;
        if (sessionData.isBroker()) {
            user = this.getBrokeringFilters(sessionData);
        }
        if (booleanBuilder != null && user != null) {
            return new BooleanBuilder(booleanBuilder).or((Predicate)user);
        }
        return (Predicate)ObjectHelper.defaultValue(booleanBuilder, (Object)user);
    }

    protected abstract DBQuery<?> initQuery(P var1);
}

