/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QScheduledPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.InstallmentProcessingRecurringTask;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionNotificationProcessingRecurringTask;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.search.InstallmentSearchHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseGeneralValidation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentDTO;
import org.cyclos.model.banking.transactions.InstallmentLocatorVO;
import org.cyclos.model.banking.transactions.InstallmentPreviewVO;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentInstallmentConfirmationField;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentActionDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentInstallmentAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledPaymentServiceImpl
extends BaseServiceImpl
implements ScheduledPaymentServiceLocal {
    private static final QScheduledPayment $ = QScheduledPayment.scheduledPayment;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private InstallmentSearchHandler installmentSearchHandler;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private LockHandler lockHandler;

    public ScheduledPayment acceptPaymentRequest(PaymentRequest paymentRequest) {
        PerformScheduledPaymentDTO performScheduledPaymentDTO = this.toPerformDTO(paymentRequest, false);
        ScheduledPayment scheduledPayment = new ScheduledPayment();
        scheduledPayment.setShowToReceiver(true);
        if (paymentRequest.getBy() instanceof Operator) {
            scheduledPayment.setReceivedBy((Operator)paymentRequest.getBy());
        }
        return this.doPerform(performScheduledPaymentDTO, null, null, scheduledPayment, PaymentCreationType.REQUEST);
    }

    public void block(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkPasswordAndGet(ScheduledPaymentAction.BLOCK, scheduledPaymentActionDTO);
        if (scheduledPayment.getStatus() != ScheduledPaymentStatus.OPEN) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)scheduledPayment, (TransactionStatus)ScheduledPaymentStatus.BLOCKED);
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            if (scheduledPaymentInstallment.getStatus() != InstallmentStatus.SCHEDULED) continue;
            this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.BLOCKED).fireSaved();
        }
        extensionPointAccessor.fireSaved();
    }

    public BigDecimal calculateDueAmount(ScheduledPayment scheduledPayment) {
        Currency currency = scheduledPayment.getType().getCurrency();
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)BigDecimal.ZERO, (int)currency.getPrecision());
        List list = scheduledPayment.getInstallments();
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : list) {
            InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
            if (installmentStatus == null || installmentStatus.isTerminal()) continue;
            bigDecimal = bigDecimal.add(scheduledPaymentInstallment.getAmount());
        }
        return bigDecimal;
    }

    public List<InstallmentDTO> calculateInstallments(CalculateInstallmentsDTO calculateInstallmentsDTO) throws ValidationException {
        Date date;
        Date date2;
        BigDecimal bigDecimal;
        LocateAccountOwnerResult locateAccountOwnerResult;
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)calculateInstallmentsDTO.getType());
        if (paymentTransferType == null) {
            locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)calculateInstallmentsDTO.getOwner());
            LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(calculateInstallmentsDTO.getSubject());
            Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)calculateInstallmentsDTO.getCurrency());
            bigDecimal = this.getSessionData();
            paymentTransferType = this.transactionService.resolvePaymentType(locateAccountOwnerResult.getInternalAccountOwner(), locateAccountOwnerResult2.getAccountOwner(), currency, bigDecimal.getChannel(), bigDecimal.getPrincipalType(), PaymentCreationType.DIRECT);
            if (paymentTransferType != null) {
                calculateInstallmentsDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
            }
        }
        this.validate(calculateInstallmentsDTO);
        if (paymentTransferType == null) {
            throw new EntityNotFoundException(TransferType.class);
        }
        locateAccountOwnerResult = paymentTransferType.getCurrency();
        int n = calculateInstallmentsDTO.getInstallmentsCount();
        int n2 = locateAccountOwnerResult.getPrecision();
        bigDecimal = BigDecimalHelper.round((BigDecimal)BigDecimal.ZERO, (int)n2);
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)calculateInstallmentsDTO.getAmount(), (int)n2);
        double d = bigDecimal2.doubleValue() / (double)n;
        BigDecimal bigDecimal3 = BigDecimalHelper.round((BigDecimal)new BigDecimal(d), (int)n2);
        ArrayList<InstallmentDTO> arrayList = new ArrayList<InstallmentDTO>(n);
        if (calculateInstallmentsDTO.isFirstInstallmentIsNow()) {
            Date date3;
            date2 = date3 = DateHelper.now();
            date = DateHelper.shiftToBegin((Date)date3, (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true);
        } else {
            date2 = date = DateHelper.shiftToBegin((Date)this.toDate(calculateInstallmentsDTO.getFirstInstallmentDate()), (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true);
        }
        for (int i = 0; i < n; ++i) {
            InstallmentDTO installmentDTO = new InstallmentDTO();
            if (i == 0) {
                installmentDTO.setDueDate(this.toDateTime(date2));
            } else {
                installmentDTO.setDueDate(this.toDateTime(DateHelper.add((Date)date, (TimeField)TimeField.MONTHS, (int)i)));
            }
            if (i == n - 1) {
                installmentDTO.setAmount(bigDecimal2.subtract(bigDecimal));
            } else {
                installmentDTO.setAmount(bigDecimal3);
            }
            arrayList.add(installmentDTO);
            bigDecimal = bigDecimal.add(bigDecimal3);
        }
        return arrayList;
    }

    public List<InstallmentDTO> calculateInstallmentsReceive(CalculateInstallmentsDTO calculateInstallmentsDTO) throws FrameworkException {
        return (List)this.transactionService.receive(calculateInstallmentsDTO.getOwner(), () -> this.calculateInstallments(calculateInstallmentsDTO));
    }

    public void cancel(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkPasswordAndGet(ScheduledPaymentAction.CANCEL, scheduledPaymentActionDTO);
        this.cancel(scheduledPayment);
    }

    public int cancelAll(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return 0;
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.from().eq((Object)userAccount).or((Predicate)$.to().eq((Object)userAccount)), ScheduledPaymentServiceImpl.$.status.in((Object[])new String[]{ScheduledPaymentStatus.OPEN.name(), ScheduledPaymentStatus.BLOCKED.name()})})).iterate((Expression)$);
        return (int)this.processBatch(closeableIterator, this::cancel);
    }

    public ScheduledPaymentData getData(Long l) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.find(ScheduledPayment.class, l);
        return this.getData(scheduledPayment);
    }

    public ScheduledPaymentData getData(ScheduledPayment scheduledPayment) {
        ScheduledPaymentData scheduledPaymentData = (ScheduledPaymentData)this.transactionService.newData((Transaction)scheduledPayment, true);
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(scheduledPayment.getInstallments().size());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = scheduledPayment.getStatus() == ScheduledPaymentStatus.CANCELED;
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
            arrayList.add(!bl3 && installmentStatus != null && !installmentStatus.isTerminal());
            bl = installmentStatus == InstallmentStatus.SCHEDULED;
            bl2 = installmentStatus != null && !installmentStatus.isTerminal();
        }
        scheduledPaymentData.setCanProcessInstallment(arrayList);
        scheduledPaymentData.setCanSettleInstallment(new ArrayList(arrayList));
        ScheduledPaymentStatus scheduledPaymentStatus = scheduledPayment.getStatus();
        boolean bl4 = scheduledPaymentStatus == ScheduledPaymentStatus.OPEN;
        boolean bl5 = scheduledPaymentStatus == ScheduledPaymentStatus.BLOCKED;
        scheduledPaymentData.setCanBlock(bl && bl4);
        scheduledPaymentData.setCanCancel(bl2 && (bl4 || bl5));
        scheduledPaymentData.setCanUnblock(bl5);
        return scheduledPaymentData;
    }

    @PostConstruct
    public void initialize() {
        this.transactionAuthorizationService.registerHandler(AuthorizationAction.AUTHORIZED, ScheduledPayment.class, this::onScheduledPaymentAuthorized);
    }

    public void markAsFailed(ScheduledPaymentInstallment scheduledPaymentInstallment) {
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.FAILED);
        if (scheduledPayment.getAmountReservation() != null) {
            this.accountService.dereserveAmount(scheduledPaymentInstallment);
        }
        if (scheduledPayment.isFromUser()) {
            BasicUser basicUser = scheduledPayment.getPerformer();
            this.alertService.create(basicUser.getUser(), UserAlertType.SCHEDULED_PAYMENT_FAILED, new Object[]{scheduledPaymentInstallment.getCurrencyAmount(), scheduledPayment.getType(), scheduledPayment.getToOwner()});
            this.notificationHandler.user(basicUser).account().scheduledPaymentFailed(scheduledPaymentInstallment, scheduledPaymentInstallment.getCurrencyAmount(), scheduledPayment.getType(), (AccountOwner)scheduledPayment.getToOwner());
        }
        if (scheduledPayment.isToUser() && scheduledPayment.isShowToReceiver()) {
            this.notificationHandler.user(scheduledPayment.getReceiver()).account().incomingScheduledPaymentFailed(scheduledPaymentInstallment, scheduledPaymentInstallment.getCurrencyAmount(), scheduledPayment.getType(), (AccountOwner)scheduledPayment.getFromOwner());
        }
        extensionPointAccessor.fireSaved();
    }

    public void notifyPaymentPerformed(ScheduledPayment scheduledPayment) {
        if (scheduledPayment.isPendingAuthorization()) {
            this.transactionAuthorizationService.notifyPendingAuthorization((BasePayment)scheduledPayment);
        } else {
            this.transactionFeedbackService.notifyTransactionFeedback((PaymentTransferType)scheduledPayment.getType());
            this.notifyReceiver(scheduledPayment);
        }
    }

    public ScheduledPaymentVO perform(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.doPerform(performScheduledPaymentDTO, null);
        return (ScheduledPaymentVO)this.conversionHandler.convert(ScheduledPaymentVO.class, (Object)scheduledPayment);
    }

    public ScheduledPaymentPreviewVO preview(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException {
        return this.doPreview(performScheduledPaymentDTO, true, null);
    }

    public ScheduledPaymentPreviewVO previewAcceptPaymentRequest(PaymentRequest paymentRequest) {
        PerformScheduledPaymentDTO performScheduledPaymentDTO = this.toPerformDTO(paymentRequest, true);
        return this.doPreview(performScheduledPaymentDTO, false, null);
    }

    public ScheduledPaymentPreviewVO previewReceive(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performScheduledPaymentDTO.getOwner();
        return (ScheduledPaymentPreviewVO)this.transactionService.receive(internalAccountOwner, () -> this.doPreview(performScheduledPaymentDTO, true, sessionData));
    }

    public TransferVO processInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        ScheduledPaymentInstallment scheduledPaymentInstallment = (ScheduledPaymentInstallment)this.conversionHandler.convert(ScheduledPaymentInstallment.class, (Object)installmentActionDTO.getInstallment());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(installmentActionDTO.getConfirmationPassword(), ManageScheduledPaymentInstallmentConfirmationField.confirmation((InstallmentLocatorVO)installmentActionDTO.getInstallment(), (ScheduledPaymentInstallmentAction)ScheduledPaymentInstallmentAction.PROCESS));
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        Date date = DateHelper.now();
        if (!DateHelper.sameDay(null, (Date)scheduledPaymentInstallment.getDueDate(), (Date)date)) {
            this.transactionService.validatePaymentAmount(this.accountHandler.locate((AccountOwner)scheduledPayment.getFromOwner()), this.accountHandler.locate((AccountOwner)scheduledPayment.getToOwner()), scheduledPayment.getPaymentType(), scheduledPaymentInstallment.getAmount(), date);
        }
        return (TransferVO)this.conversionHandler.convert(TransferVO.class, (Object)this.processInstallment(scheduledPaymentInstallment));
    }

    public InstallmentTransfer processInstallment(ScheduledPaymentInstallment scheduledPaymentInstallment) throws FrameworkException, TransferException {
        this.lockHandler.lock(LockType.INSTALLMENT.key(scheduledPaymentInstallment.getId()));
        this.entityManagerHandler.refresh((IEntity)scheduledPaymentInstallment);
        InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
        if (installmentStatus.isTerminal()) {
            throw new IllegalActionException("Can't process this installment because its status is " + String.valueOf(installmentStatus));
        }
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        User user = scheduledPayment.getToUser();
        if (user != null && user.isRemoved()) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.PROCESSED);
        if (scheduledPayment.getAmountReservation() != null && scheduledPaymentInstallment.getAmountDereservation() == null) {
            this.accountService.dereserveAmount(scheduledPaymentInstallment);
        }
        InstallmentTransfer installmentTransfer = this.transferService.insertInstallmentTransfer((Installment)scheduledPaymentInstallment);
        extensionPointAccessor.fireSaved();
        this.maybeClose(scheduledPayment);
        PaymentTransferType paymentTransferType = (PaymentTransferType)scheduledPayment.getType();
        if (scheduledPayment.isFromUser() && paymentTransferType.isNotifyPaymentPerformed()) {
            this.notificationHandler.user(scheduledPayment.getPerformer()).account().scheduledPaymentInstallmentProcessed(scheduledPaymentInstallment, Integer.valueOf(scheduledPaymentInstallment.getNumber()), scheduledPaymentInstallment.getCurrencyAmount(), (TransferType)paymentTransferType, (AccountOwner)scheduledPayment.getToOwner());
        }
        return installmentTransfer;
    }

    public ScheduledPaymentVO receive(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performScheduledPaymentDTO.getOwner();
        return (ScheduledPaymentVO)this.transactionService.receive(internalAccountOwner, () -> {
            ScheduledPayment scheduledPayment = this.doPerform(performScheduledPaymentDTO, sessionData);
            return (ScheduledPaymentVO)this.conversionHandler.convert(ScheduledPaymentVO.class, (Object)scheduledPayment);
        });
    }

    public void settleInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        ScheduledPaymentInstallment scheduledPaymentInstallment = (ScheduledPaymentInstallment)this.conversionHandler.convert(ScheduledPaymentInstallment.class, (Object)installmentActionDTO.getInstallment());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(installmentActionDTO.getConfirmationPassword(), ManageScheduledPaymentInstallmentConfirmationField.confirmation((InstallmentLocatorVO)installmentActionDTO.getInstallment(), (ScheduledPaymentInstallmentAction)ScheduledPaymentInstallmentAction.SETTLE));
        this.settleInstallment(scheduledPaymentInstallment);
    }

    public void settleInstallment(ScheduledPaymentInstallment scheduledPaymentInstallment) throws FrameworkException {
        InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
        if (installmentStatus.isTerminal()) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.SETTLED);
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        if (scheduledPayment.getAmountReservation() != null) {
            this.accountService.dereserveAmount(scheduledPaymentInstallment);
        }
        extensionPointAccessor.fireSaved();
        this.maybeClose(scheduledPayment);
    }

    public void settleRemaining(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException, TransferException {
        ScheduledPayment scheduledPayment = this.checkPasswordAndGet(ScheduledPaymentAction.SETTLE, scheduledPaymentActionDTO);
        if (scheduledPayment.getStatus() != ScheduledPaymentStatus.OPEN && scheduledPayment.getStatus() != ScheduledPaymentStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            if (scheduledPaymentInstallment.getStatus().isTerminal()) continue;
            this.settleInstallment(scheduledPaymentInstallment);
        }
    }

    public void unblock(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkPasswordAndGet(ScheduledPaymentAction.UNBLOCK, scheduledPaymentActionDTO);
        if (scheduledPayment.getStatus() != ScheduledPaymentStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)scheduledPayment, (TransactionStatus)ScheduledPaymentStatus.OPEN);
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            if (scheduledPaymentInstallment.getStatus() != InstallmentStatus.BLOCKED) continue;
            this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.SCHEDULED).fireSaved();
        }
        extensionPointAccessor.fireSaved();
    }

    protected void maybeClose(ScheduledPayment scheduledPayment) {
        boolean bl = true;
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
            if (installmentStatus == InstallmentStatus.PROCESSED || installmentStatus == InstallmentStatus.SETTLED) continue;
            bl = false;
            break;
        }
        if (bl) {
            ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)scheduledPayment, (TransactionStatus)ScheduledPaymentStatus.CLOSED);
            extensionPointAccessor.fireSaved();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void cancel(ScheduledPayment scheduledPayment) {
        if (scheduledPayment.getStatus() != ScheduledPaymentStatus.OPEN && scheduledPayment.getStatus() != ScheduledPaymentStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)scheduledPayment, (TransactionStatus)ScheduledPaymentStatus.CANCELED);
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : scheduledPayment.getInstallments()) {
            if (scheduledPaymentInstallment.getStatus() != InstallmentStatus.BLOCKED && scheduledPaymentInstallment.getStatus() != InstallmentStatus.SCHEDULED) continue;
            if (scheduledPayment.getAmountReservation() != null) {
                this.accountService.dereserveAmount(scheduledPaymentInstallment);
            }
            this.transactionService.setStatusAndGetExtensionPoint((Installment)scheduledPaymentInstallment, InstallmentStatus.CANCELED).fireSaved();
        }
        if (scheduledPayment.isToUser() && scheduledPayment.isShowToReceiver()) {
            BasicUser basicUser = scheduledPayment.getReceiver();
            this.notificationHandler.user(basicUser).account().incomingScheduledPaymentCanceled(scheduledPayment, scheduledPayment.getCurrencyAmount(), scheduledPayment.getType(), (AccountOwner)scheduledPayment.getFromOwner());
        }
        extensionPointAccessor.fireSaved();
    }

    private ScheduledPayment checkPasswordAndGet(ScheduledPaymentAction scheduledPaymentAction, ScheduledPaymentActionDTO scheduledPaymentActionDTO) {
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(scheduledPaymentActionDTO.getConfirmationPassword(), ManageScheduledPaymentConfirmationField.confirmation((ScheduledPaymentVO)scheduledPaymentActionDTO.getScheduledPayment(), (ScheduledPaymentAction)scheduledPaymentAction));
        return (ScheduledPayment)this.conversionHandler.convert(ScheduledPayment.class, (Object)scheduledPaymentActionDTO.getScheduledPayment());
    }

    private ScheduledPayment doPerform(PerformScheduledPaymentDTO performScheduledPaymentDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, ScheduledPayment scheduledPayment, PaymentCreationType paymentCreationType) {
        if (locateAccountOwnerResult == null) {
            locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performScheduledPaymentDTO.getOwner());
        }
        if (locateAccountOwnerResult2 == null) {
            locateAccountOwnerResult2 = this.transactionService.locateForPayment(performScheduledPaymentDTO.getSubject());
        }
        String string = performScheduledPaymentDTO.getFromName();
        String string2 = performScheduledPaymentDTO.getToName();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performScheduledPaymentDTO.getType());
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)performScheduledPaymentDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        this.transactionService.validateMinTimeBetweenPayments(locateAccountOwnerResult, paymentTransferType);
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getFrom());
        Account account2 = this.accountService.load(locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CONFIRM, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performScheduledPaymentDTO).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)locateAccountOwnerResult2.getAccountOwner()).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        this.transactionService.fill((Transaction)scheduledPayment, (TransferType)paymentTransferType, paymentCreationType, account, account2, (BasicUser)locateAccountOwnerResult2.getOperator(), string, string2, bigDecimal, performScheduledPaymentDTO.getDescription(), (Collection)performScheduledPaymentDTO.getCustomValues());
        if (!scheduledPayment.isPendingAuthorization()) {
            scheduledPayment.setStatus(ScheduledPaymentStatus.OPEN);
        }
        scheduledPayment.setPendingNotification(scheduledPayment.isPendingAuthorization() || this.shouldNotifyReceiver(scheduledPayment));
        this.transactionService.persist((Transaction)scheduledPayment);
        InstallmentStatus installmentStatus = scheduledPayment.isPendingAuthorization() ? null : InstallmentStatus.SCHEDULED;
        List<InstallmentDTO> list = performScheduledPaymentDTO.getInstallments();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            CalculateInstallmentsDTO calculateInstallmentsDTO = (CalculateInstallmentsDTO)this.conversionHandler.convert(CalculateInstallmentsDTO.class, (Object)performScheduledPaymentDTO);
            list = this.calculateInstallments(calculateInstallmentsDTO);
        }
        for (int i = 0; i < list.size(); ++i) {
            InstallmentDTO installmentDTO = (InstallmentDTO)list.get(i);
            BigDecimal bigDecimal2 = installmentDTO.getAmount();
            Date date = this.toDate(installmentDTO.getDueDate());
            this.transactionService.validatePaymentAmount(locateAccountOwnerResult, locateAccountOwnerResult2, paymentTransferType, bigDecimal2, date);
            ScheduledPaymentInstallment scheduledPaymentInstallment = new ScheduledPaymentInstallment();
            scheduledPaymentInstallment.setScheduledPayment(scheduledPayment);
            scheduledPaymentInstallment.setNumber(i + 1);
            scheduledPaymentInstallment.setDueDate(date);
            scheduledPaymentInstallment.setAmount(bigDecimal2);
            scheduledPaymentInstallment.setStatus(installmentStatus);
            this.persist((IEntity)scheduledPaymentInstallment);
            scheduledPayment.getInstallments().add(scheduledPaymentInstallment);
            this.installmentSearchHandler.index((NetworkedEntity)scheduledPaymentInstallment);
        }
        if (paymentTransferType.isReserveTotalAmountOnScheduledPayments()) {
            if (scheduledPayment.isPendingAuthorization()) {
                this.accountService.reserveAmountForAuthorization((PerformTransactionDTO)performScheduledPaymentDTO, (BasePayment)scheduledPayment);
            } else {
                this.accountService.reserveAmount(scheduledPayment);
            }
        }
        this.transactionAuthorizationService.authorizeFirstLevelIfNeeded((BasePayment)scheduledPayment);
        if (performScheduledPaymentDTO.isFirstInstallmentIsNow() && !scheduledPayment.isPendingAuthorization()) {
            this.recurringTaskHandler.scheduleAwake(InstallmentProcessingRecurringTask.class);
        }
        if (scheduledPayment.isPendingNotification()) {
            this.recurringTaskHandler.scheduleAwake(TransactionNotificationProcessingRecurringTask.class);
        }
        extensionPointAccessor.attribute("transaction", (Object)scheduledPayment).fireSaved();
        return scheduledPayment;
    }

    private ScheduledPayment doPerform(PerformScheduledPaymentDTO performScheduledPaymentDTO, SessionData sessionData) {
        ScheduledPayment scheduledPayment;
        boolean bl;
        Token token;
        this.validate(performScheduledPaymentDTO, sessionData, true, false, false, true);
        InternalAccountOwner internalAccountOwner = performScheduledPaymentDTO.getOwner();
        InternalAccountOwner internalAccountOwner2 = performScheduledPaymentDTO.getSubject();
        boolean bl2 = sessionData != null;
        PaymentCreationType paymentCreationType = bl2 ? PaymentCreationType.POS : PaymentCreationType.DIRECT;
        LocateAccountOwnerResult locateAccountOwnerResult = sessionData == null ? this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner) : (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner));
        LocateAccountOwnerResult locateAccountOwnerResult2 = bl2 ? this.accountHandler.locate((AccountOwner)internalAccountOwner2) : this.transactionService.locateForPayment(internalAccountOwner2);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performScheduledPaymentDTO.getType());
        List<InstallmentDTO> list = this.resolveInstallments(performScheduledPaymentDTO);
        if (this.isCheckConfirmationPassword(paymentTransferType, locateAccountOwnerResult.getInternalAccountOwner(), list, performScheduledPaymentDTO.isFirstInstallmentIsNow())) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(performScheduledPaymentDTO.getConfirmationPassword(), PerformPaymentConfirmationField.confirmation((PerformInternalTransactionDTO)performScheduledPaymentDTO));
        }
        if ((token = this.getSessionData().getToken()) instanceof NFCToken) {
            ((NFCToken)token).resetChallenge();
        }
        this.transactionServiceSecurity.checkPaymentParameters(locateAccountOwnerResult, locateAccountOwnerResult2, paymentCreationType, paymentTransferType);
        boolean bl3 = bl = bl2 || paymentTransferType.isShowScheduledPaymentsToReceiver();
        if (!bl && paymentTransferType.isRequiresAuthorization()) {
            scheduledPayment = (AuthorizationLevel)CollectionHelper.first((Iterable)paymentTransferType.getAuthorizationLevels());
            bl = scheduledPayment != null && scheduledPayment.isReceiver();
        }
        scheduledPayment = new ScheduledPayment();
        scheduledPayment.setShowToReceiver(bl);
        scheduledPayment.setCreationType(paymentCreationType);
        if (sessionData != null) {
            scheduledPayment.setReceivedBy(sessionData.getLoggedOperator());
            scheduledPayment.setAccessClient(sessionData.getAccessClient());
        }
        this.doPerform(performScheduledPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, scheduledPayment, paymentCreationType);
        return scheduledPayment;
    }

    private ScheduledPaymentPreviewVO doPreview(PerformScheduledPaymentDTO performScheduledPaymentDTO, boolean bl, SessionData sessionData) {
        LocateAccountOwnerResult locateAccountOwnerResult;
        PaymentCreationType paymentCreationType;
        this.validate(performScheduledPaymentDTO, sessionData, bl, false, true, false);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performScheduledPaymentDTO.getType());
        InternalAccountOwner internalAccountOwner = performScheduledPaymentDTO.getSubject();
        LocateAccountOwnerResult locateAccountOwnerResult2 = sessionData == null ? this.transactionService.locateForPayment(internalAccountOwner) : this.accountHandler.locate((AccountOwner)internalAccountOwner);
        InternalAccountOwner internalAccountOwner2 = performScheduledPaymentDTO.getOwner();
        if (sessionData == null) {
            paymentCreationType = PaymentCreationType.DIRECT;
            locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner2);
        } else {
            paymentCreationType = PaymentCreationType.POS;
            locateAccountOwnerResult = (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner2));
        }
        InternalAccountOwner internalAccountOwner3 = locateAccountOwnerResult.getInternalAccountOwner();
        InternalAccountOwner internalAccountOwner4 = locateAccountOwnerResult2.getInternalAccountOwner();
        BigDecimal bigDecimal = performScheduledPaymentDTO.getAmount();
        if (bigDecimal == null && paymentTransferType.isUseFixedAmount()) {
            bigDecimal = paymentTransferType.getFixedAmount();
            performScheduledPaymentDTO.setAmount(bigDecimal);
        }
        this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performScheduledPaymentDTO.getCustomValues());
        ScheduledPaymentPreviewVO scheduledPaymentPreviewVO = new ScheduledPaymentPreviewVO();
        Account account = this.accountService.load(internalAccountOwner3, paymentTransferType.getFrom());
        Account account2 = this.accountService.load(internalAccountOwner4, paymentTransferType.getTo());
        scheduledPaymentPreviewVO.setFromAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        scheduledPaymentPreviewVO.setToAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account2));
        scheduledPaymentPreviewVO.setTotalAmount(ModelHelper.currencyAmount((CurrencyVO)((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency())), (BigDecimal)bigDecimal));
        Pair pair = this.transactionAuthorizationService.initialAuthorization(paymentTransferType, bigDecimal);
        scheduledPaymentPreviewVO.setPendingAuthorization(pair != null);
        scheduledPaymentPreviewVO.setConfirmationMessage(this.getTranslatedValue((BaseEntity)paymentTransferType, QPaymentTransferType.paymentTransferType.confirmationMessage));
        List<InstallmentDTO> list = this.resolveInstallments(performScheduledPaymentDTO);
        CredentialInputDTO credentialInputDTO = null;
        ArrayList<InstallmentPreviewVO> arrayList = new ArrayList<InstallmentPreviewVO>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            InstallmentDTO installmentDTO = list.get(i);
            PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
            performPaymentDTO.setOwner(internalAccountOwner2);
            performPaymentDTO.setSubject(internalAccountOwner);
            performPaymentDTO.setType(performScheduledPaymentDTO.getType());
            performPaymentDTO.setCustomValues(performScheduledPaymentDTO.getCustomValues());
            performPaymentDTO.setAmount(installmentDTO.getAmount());
            performPaymentDTO.setDescription(performScheduledPaymentDTO.getDescription());
            PaymentPreviewVO paymentPreviewVO = this.paymentService.doPreview(performPaymentDTO, bl, false, sessionData, paymentCreationType);
            InstallmentPreviewVO installmentPreviewVO = new InstallmentPreviewVO();
            installmentPreviewVO.setNumber(Integer.valueOf(i + 1));
            installmentPreviewVO.setDueDate(installmentDTO.getDueDate());
            installmentPreviewVO.setMainAmount(paymentPreviewVO.getMainAmount());
            installmentPreviewVO.setTotalAmount(paymentPreviewVO.getTotalAmount());
            installmentPreviewVO.setFees(paymentPreviewVO.getFees());
            arrayList.add(installmentPreviewVO);
            if (credentialInputDTO != null || paymentPreviewVO.getConfirmationPasswordInput() == null) continue;
            credentialInputDTO = paymentPreviewVO.getConfirmationPasswordInput();
        }
        scheduledPaymentPreviewVO.setInstallments(arrayList);
        scheduledPaymentPreviewVO.setConfirmationPasswordInput(credentialInputDTO);
        scheduledPaymentPreviewVO.setSkipConfirmation(credentialInputDTO == null && paymentTransferType.isSkipConfirmation());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.PREVIEW, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performScheduledPaymentDTO).attribute("paymentType", (Object)paymentTransferType).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)internalAccountOwner3).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)internalAccountOwner4).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("preview", (Object)scheduledPaymentPreviewVO).attribute("authorizationType", pair == null ? null : pair.getFirst()).attribute("authorizationLevel", pair == null ? null : pair.getSecond());
        extensionPointAccessor.fireValidated();
        this.transactionService.updatePreviewAndPayment((BasePaymentPreviewVO)scheduledPaymentPreviewVO, (PerformTransactionDTO)performScheduledPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, (TransferType)paymentTransferType, sessionData);
        extensionPointAccessor.fireSaved();
        return scheduledPaymentPreviewVO;
    }

    private boolean isCheckConfirmationPassword(PaymentTransferType paymentTransferType, InternalAccountOwner internalAccountOwner, List<InstallmentDTO> list, boolean bl) {
        boolean bl2 = false;
        if (CollectionHelper.isEmpty(list)) {
            throw new IllegalActionException("Cannot check for password confirmation for a scheduled payment without installments");
        }
        int n = list.size();
        for (int i = 0; i < n && !bl2; ++i) {
            InstallmentDTO installmentDTO = list.get(i);
            Date date = this.conversionHandler.toDate((IDate)installmentDTO.getDueDate());
            bl2 = this.transactionService.isCheckConfirmation(paymentTransferType, internalAccountOwner, installmentDTO.getAmount(), date);
        }
        return bl2;
    }

    private void notifyReceiver(ScheduledPayment scheduledPayment) {
        if (this.shouldNotifyReceiver(scheduledPayment)) {
            this.notificationHandler.user(scheduledPayment.getReceiver()).account().incomingScheduledPaymentReceived(scheduledPayment, scheduledPayment.getCurrencyAmount(), scheduledPayment.getType(), (AccountOwner)scheduledPayment.getFromOwner());
        }
    }

    private void onScheduledPaymentAuthorized(ScheduledPayment scheduledPayment) {
        ScheduledPaymentInstallment scheduledPaymentInstallment2;
        scheduledPayment.setStatus(ScheduledPaymentStatus.OPEN);
        for (ScheduledPaymentInstallment scheduledPaymentInstallment2 : scheduledPayment.getInstallments()) {
            scheduledPaymentInstallment2.setStatus(InstallmentStatus.SCHEDULED);
        }
        PaymentTransferType paymentTransferType = (PaymentTransferType)scheduledPayment.getType();
        if (paymentTransferType.isReserveTotalAmountOnScheduledPayments()) {
            this.accountService.reserveAmount(scheduledPayment);
        }
        if ((scheduledPaymentInstallment2 = scheduledPayment.getFirstScheduledInstallment()) != null && scheduledPaymentInstallment2.getDueDate().before(new Date())) {
            this.recurringTaskHandler.scheduleAwake(InstallmentProcessingRecurringTask.class);
        }
        this.notifyReceiver(scheduledPayment);
    }

    private List<InstallmentDTO> resolveInstallments(PerformScheduledPaymentDTO performScheduledPaymentDTO) {
        List<InstallmentDTO> list = performScheduledPaymentDTO.getInstallments();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            CalculateInstallmentsDTO calculateInstallmentsDTO = (CalculateInstallmentsDTO)this.conversionHandler.convert(CalculateInstallmentsDTO.class, (Object)performScheduledPaymentDTO);
            list = this.calculateInstallments(calculateInstallmentsDTO);
        }
        if (list.isEmpty()) {
            throw new IllegalActionException("Cannot perform a scheduled payment without installments");
        }
        return list;
    }

    private boolean shouldNotifyReceiver(ScheduledPayment scheduledPayment) {
        return scheduledPayment.isToUser() && scheduledPayment.isShowToReceiver() && scheduledPayment.getPaymentRequest() == null;
    }

    private PerformScheduledPaymentDTO toPerformDTO(PaymentRequest paymentRequest, boolean bl) {
        Object object;
        PaymentRequestStatus paymentRequestStatus = paymentRequest.getStatus();
        if (paymentRequest.getScheduling() == null || !paymentRequest.getScheduling().useInstallments() || paymentRequestStatus != PaymentRequestStatus.OPEN && paymentRequestStatus != PaymentRequestStatus.SCHEDULED) {
            throw new IllegalActionException();
        }
        PerformScheduledPaymentDTO performScheduledPaymentDTO = new PerformScheduledPaymentDTO();
        performScheduledPaymentDTO.setOwner(paymentRequest.getFromOwner());
        performScheduledPaymentDTO.setSubject(paymentRequest.getToOwner());
        performScheduledPaymentDTO.setAmount(paymentRequest.getAmount());
        performScheduledPaymentDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentRequest.getType()));
        performScheduledPaymentDTO.setDescription(paymentRequest.getDescription());
        Set set = paymentRequest.getCustomValues();
        Set<TransactionCustomFieldValue> set2 = new HashSet();
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            object = this.transactionCustomFieldService.listVisible((AccountOwner)paymentRequest.getToOwner());
            for (TransactionCustomFieldValue transactionCustomFieldValue : set) {
                if (!object.contains(transactionCustomFieldValue.getField())) continue;
                set2.add(transactionCustomFieldValue);
            }
        } else if (!bl) {
            set2 = set;
        }
        if (bl) {
            performScheduledPaymentDTO.setCustomValues(this.conversionHandler.convertList(CustomFieldValueDTO.class, set2));
        } else {
            this.customFieldValueHandler.cloneCustomValuesData((ModelWithCustomValues)performScheduledPaymentDTO, set2);
        }
        ModelHelper.clearIds((Iterable)performScheduledPaymentDTO.getCustomValues());
        performScheduledPaymentDTO.setFirstInstallmentIsNow(paymentRequest.isFirstSchedulingIsImmediate());
        performScheduledPaymentDTO.setInstallmentsCount(paymentRequest.getSchedulingCount());
        if (!paymentRequest.isFirstSchedulingIsImmediate()) {
            object = DateHelper.add((Date)new Date(), (TimeField)TimeField.MONTHS, (int)1);
            performScheduledPaymentDTO.setFirstInstallmentDate(this.conversionHandler.toDateTime((Date)object));
        }
        object = (CalculateInstallmentsDTO)this.conversionHandler.convert(CalculateInstallmentsDTO.class, (Object)performScheduledPaymentDTO);
        performScheduledPaymentDTO.setInstallments(this.calculateInstallments((CalculateInstallmentsDTO)object));
        return performScheduledPaymentDTO;
    }

    private void validate(CalculateInstallmentsDTO calculateInstallmentsDTO) {
        Validator validator = new Validator();
        PerformPaymentTypeData performPaymentTypeData = this.transactionService.getPaymentTypeData(calculateInstallmentsDTO.getOwner(), calculateInstallmentsDTO.getSubject(), calculateInstallmentsDTO.getType());
        int n = performPaymentTypeData == null ? Integer.MAX_VALUE : performPaymentTypeData.getMaxInstallments();
        validator.property((Property)CalculateInstallmentsDTO.OWNER, BankingKeys.Accounts.FROM).required();
        validator.property((Property)CalculateInstallmentsDTO.SUBJECT, BankingKeys.Accounts.TO).required();
        validator.property((Property)CalculateInstallmentsDTO.TYPE, BankingKeys.Transactions.TYPE).required();
        validator.property((Property)CalculateInstallmentsDTO.INSTALLMENTS_COUNT, BankingKeys.Transactions.INSTALLMENTS_COUNT).required().greaterEquals((Comparable)Integer.valueOf(1)).lessEquals((Comparable)Integer.valueOf(n));
        if (!calculateInstallmentsDTO.isFirstInstallmentIsNow()) {
            validator.property((Property)CalculateInstallmentsDTO.FIRST_INSTALLMENT_DATE, BankingKeys.Transactions.FIRST_INSTALLMENT_DATE).required().futureDate();
        }
        validator.property((Property)CalculateInstallmentsDTO.AMOUNT, BankingKeys.Transactions.AMOUNT).required().positiveNonZero(performPaymentTypeData.getCurrency().getPrecision());
        this.validate(validator, calculateInstallmentsDTO, "calculateInstallmentsDTO");
    }

    private void validate(PerformScheduledPaymentDTO performScheduledPaymentDTO, SessionData sessionData, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performScheduledPaymentDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(performScheduledPaymentDTO.getSubject());
        PaymentCreationType paymentCreationType = sessionData != null ? PaymentCreationType.POS : PaymentCreationType.DIRECT;
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)performScheduledPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, sessionData, paymentCreationType).validateCustomFields(bl).allowSearchingTTWhenNoneIsGiven(true).validateConfirmationPassword(bl2).excludeHideInForm(bl3).validateNFCChallenge(bl4).validateAmount(false).build();
        TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        PaymentTransferType paymentTransferType = transactionValidationData.getPaymentType();
        if (paymentTransferType != null && !paymentTransferType.isAllowsScheduledPayments()) {
            validator.property((Property)PerformScheduledPaymentDTO.TYPE, BankingKeys.Transactions.TYPE).invalid();
        }
        if (CollectionHelper.isEmpty((Iterable)performScheduledPaymentDTO.getInstallments())) {
            PerformPaymentTypeData performPaymentTypeData = this.transactionService.getPaymentTypeData(locateAccountOwnerResult.getInternalAccountOwner(), locateAccountOwnerResult2.getInternalAccountOwner(), performScheduledPaymentDTO.getType());
            int n = performPaymentTypeData.getMaxInstallments();
            validator.property((Property)PerformScheduledPaymentDTO.INSTALLMENTS_COUNT, BankingKeys.Transactions.INSTALLMENTS_COUNT).required().greaterEquals((Comparable)Integer.valueOf(1)).lessEquals((Comparable)Integer.valueOf(n));
            if (!performScheduledPaymentDTO.isFirstInstallmentIsNow()) {
                validator.property((Property)PerformScheduledPaymentDTO.FIRST_INSTALLMENT_DATE, BankingKeys.Transactions.FIRST_INSTALLMENT_DATE).required().futureDate();
            }
        } else {
            Validator validator2 = new Validator();
            validator2.property((Property)InstallmentDTO.DUE_DATE, BankingKeys.Transactions.INSTALLMENT_DATE).required();
            validator2.property((Property)InstallmentDTO.AMOUNT, BankingKeys.Transactions.INSTALLMENT_AMOUNT).required().positiveNonZero((HasCurrency)paymentTransferType);
            validator.nested((Property)PerformScheduledPaymentDTO.INSTALLMENTS, validator2);
            validator.general((GeneralValidation)new PaymentInstallmentsAmountValidator());
            validator.general((GeneralValidation)new PaymentInstallmentsDateValidator());
        }
        this.validate(validator, performScheduledPaymentDTO, "performScheduledPaymentDTO");
    }

    private class PaymentInstallmentsAmountValidator
    extends BaseGeneralValidation {
        private PaymentInstallmentsAmountValidator() {
            super(BankingKeys.Transfers.ERROR_INSTALLMENTS_INVALID_AMOUNT);
        }

        public boolean isValid(Object object) {
            PerformScheduledPaymentDTO performScheduledPaymentDTO = (PerformScheduledPaymentDTO)object;
            BigDecimal bigDecimal = performScheduledPaymentDTO.getAmount();
            if (bigDecimal == null) {
                return true;
            }
            List list = performScheduledPaymentDTO.getInstallments();
            if (CollectionHelper.isEmpty((Iterable)list)) {
                return true;
            }
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            for (InstallmentDTO installmentDTO : list) {
                BigDecimal bigDecimal3 = installmentDTO.getAmount();
                if (bigDecimal3 == null) {
                    return true;
                }
                bigDecimal2 = bigDecimal2.add(bigDecimal3);
            }
            return BigDecimalHelper.areEquals((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2);
        }
    }

    private class PaymentInstallmentsDateValidator
    extends BaseGeneralValidation {
        private PaymentInstallmentsDateValidator() {
            super(BankingKeys.Transfers.ERROR_INSTALLMENTS_UNSORTED_DATES);
        }

        public boolean isValid(Object object) {
            PerformScheduledPaymentDTO performScheduledPaymentDTO = (PerformScheduledPaymentDTO)object;
            BigDecimal bigDecimal = performScheduledPaymentDTO.getAmount();
            if (bigDecimal == null) {
                return true;
            }
            List list = performScheduledPaymentDTO.getInstallments();
            if (CollectionHelper.isEmpty((Iterable)list)) {
                return true;
            }
            TimeZone timeZone = ScheduledPaymentServiceImpl.this.getSessionData().getConfiguration().getTimeZone();
            Date date = DateHelper.shiftToBegin((Date)DateHelper.now(), (TimeZone)timeZone);
            for (int i = 0; i < list.size(); ++i) {
                InstallmentDTO installmentDTO = (InstallmentDTO)list.get(i);
                if (installmentDTO.getDueDate() == null) {
                    return true;
                }
                Date date2 = DateHelper.shiftToBegin((Date)ScheduledPaymentServiceImpl.this.toDate(installmentDTO.getDueDate()), (TimeZone)timeZone);
                if (i > 0 || !performScheduledPaymentDTO.isFirstInstallmentIsNow()) {
                    if (date2 == null) {
                        return true;
                    }
                    if (!date.before(date2)) {
                        return false;
                    }
                }
                date = date2;
            }
            return true;
        }
    }
}

