/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.ARateParameters;
import org.cyclos.entities.banking.DRateParameters;
import org.cyclos.entities.banking.RateParameters;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.ARateTypeHandler;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResetRatesBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private ARateTypeHandler aRateHandler;
    @Autowired
    private DRateTypeHandler dRateHandler;

    public static BackgroundTaskScheduling scheduling(RateParameters rateParameters) {
        return new BackgroundTaskScheduling(ResetRatesBackgroundTask.class, (Object)rateParameters.getId(), "Reset " + String.valueOf(rateParameters.getRateType()) + " rates for currency " + rateParameters.getCurrency().getName());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.RESET_RATES;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        Long l = Long.parseLong(string);
        long l2 = (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            RateParameters rateParameters = (RateParameters)this.rawEntityManagerHandler.find(RateParameters.class, l);
            if (!rateParameters.isMarkedForResetting()) {
                return null;
            }
            if (rateParameters instanceof ARateParameters) {
                return this.aRateHandler.nullAllAccountRates(rateParameters.getCurrency());
            }
            if (rateParameters instanceof DRateParameters) {
                return this.dRateHandler.nullAllAccountRates(rateParameters.getCurrency());
            }
            return 0L;
        });
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            RateParameters rateParameters = (RateParameters)this.rawEntityManagerHandler.find(RateParameters.class, l);
            rateParameters.setMarkedForResetting(false);
            return null;
        });
        return l2;
    }
}

