/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.search.RemoveArchivedEntitiesFromIndexException;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoveArchivedEntitiesFromIndexRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private SearchHandler searchHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NOW;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.REMOVE_ARCHIVED_ENTITIES_FROM_INDEX_RECURRING_TASK;
    }

    @Override
    public String getNotesForLogging() {
        return String.format("at %dh, for %dm, %dms delay", this.cyclosProperties.getArchivingDeleteStartHour(), this.cyclosProperties.getArchivingDeleteDurationMinutes(), this.cyclosProperties.getArchivingWaitTimeBetweenDeletesMillis());
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.NEXT_HOUR;
    }

    @Override
    protected long execute() {
        Instant instant = this.shouldRunNow();
        if (instant == null) {
            return 0L;
        }
        long l = 0L;
        try {
            l = this.searchHandler.removeArchived(instant);
        }
        catch (RemoveArchivedEntitiesFromIndexException removeArchivedEntitiesFromIndexException) {
            l = removeArchivedEntitiesFromIndexException.getAlreadyProcessed();
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                return this.searchHandler.removeArchived(instant);
            }
            catch (RemoveArchivedEntitiesFromIndexException removeArchivedEntitiesFromIndexException2) {
                l += removeArchivedEntitiesFromIndexException2.getAlreadyProcessed();
                this.logTaskError(null, removeArchivedEntitiesFromIndexException2);
            }
        }
        return l;
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    @Override
    protected boolean isVerbose() {
        return false;
    }

    @Override
    protected boolean shouldGenerateErrorLog() {
        return false;
    }

    private Instant shouldRunNow() {
        return (Instant)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            LocalDateTime localDateTime = LocalDateTime.now(ZoneId.of(this.getSessionData().getConfiguration().getTimeZoneId()));
            if (this.cyclosProperties.getArchivingDeleteStartHour() == localDateTime.getHour()) {
                return Instant.now();
            }
            return null;
        });
    }
}

