/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QVoucherPack;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionNotificationProcessingRecurringTask;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransferFeesPreviewVO;
import org.cyclos.model.banking.transfers.TransferData;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
extends BaseServiceImpl
implements PaymentServiceLocal {
    private static final String IMPORT_PAYMENT_SEND_NOTIFICATIONS = "importPaymentSendNotifications";
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public Payment acceptExternalPayment(ExternalPayment externalPayment, User user) {
        this.accountService.dereserveAmount(externalPayment);
        this.flush();
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO(externalPayment, user);
        Payment payment = new Payment();
        if (externalPayment.getBy() instanceof Operator) {
            payment.setReceivedBy((Operator)externalPayment.getBy());
        }
        return this.doPerform(performPaymentDTO, null, null, payment, PaymentCreationType.EXTERNAL);
    }

    public Payment acceptPaymentRequest(PaymentRequest paymentRequest) throws FrameworkException, TransferException, PasswordException {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO((InternalTransaction)paymentRequest, false);
        Payment payment = new Payment();
        if (paymentRequest.getBy() instanceof Operator) {
            payment.setReceivedBy((Operator)paymentRequest.getBy());
        }
        return this.doPerform(performPaymentDTO, null, null, payment, PaymentCreationType.REQUEST);
    }

    public Payment confirmOrder(Order order) throws TransferException, PasswordException {
        if (order.getPayment() != null) {
            throw new ValidationException(this.message(MarketplaceKeys.WebshopOrders.AMOUNT_ALREADY_RESERVED, new Object[0]));
        }
        PaymentTransferType paymentTransferType = order.getPaymentType();
        if (paymentTransferType == null) {
            throw new ValidationException(this.message(MarketplaceKeys.WebshopOrders.ERROR_NO_TRANSFER_TYPE, new Object[0]));
        }
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner((InternalAccountOwner)order.getBuyer());
        performPaymentDTO.setSubject((InternalAccountOwner)order.getSeller());
        performPaymentDTO.setAmount(order.getTotal());
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        performPaymentDTO.setDescription(this.message(MarketplaceKeys.Advertisements.PAYMENT_DESCRIPTION, order.getNumber()));
        Payment payment = new Payment();
        this.doPerform(performPaymentDTO, null, null, payment, PaymentCreationType.ORDER);
        order.setPayment(payment);
        return payment;
    }

    public Payment createForVoucherBuying(VoucherType voucherType, User user, BigDecimal bigDecimal, List<CustomFieldValueDTO> list) throws FrameworkException, TransferException {
        PerformPaymentDTO performPaymentDTO = this.toBuyVoucherParams(voucherType, user, bigDecimal, list);
        return this.doPerform(performPaymentDTO, true, PaymentCreationType.VOUCHER_BUYING, null);
    }

    public Payment createForVoucherRedeeming(Voucher voucher, User user, BigDecimal bigDecimal, List<CustomFieldValueDTO> list) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner((InternalAccountOwner)SystemAccountOwner.instance());
        performPaymentDTO.setSubject((InternalAccountOwner)user);
        performPaymentDTO.setAmount(bigDecimal);
        performPaymentDTO.setType(new TransferTypeVO(voucher.getType().getConfiguration().getRedeemType().getId()));
        performPaymentDTO.setCustomValues(list);
        return this.doPerform(performPaymentDTO, true, PaymentCreationType.VOUCHER_REDEEMING, null);
    }

    public Payment createForVoucherTopUp(Voucher voucher, User user, BigDecimal bigDecimal, List<CustomFieldValueDTO> list) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner((InternalAccountOwner)user);
        performPaymentDTO.setSubject((InternalAccountOwner)SystemAccountOwner.instance());
        performPaymentDTO.setAmount(bigDecimal);
        performPaymentDTO.setType(new TransferTypeVO(voucher.getConfiguration().getTopUpType().getId()));
        performPaymentDTO.setCustomValues(list);
        return this.doPerform(performPaymentDTO, true, PaymentCreationType.VOUCHER_TOP_UP, null);
    }

    public PaymentPreviewVO doPreview(PerformPaymentDTO performPaymentDTO, boolean bl, boolean bl2, SessionData sessionData, PaymentCreationType paymentCreationType) {
        CredentialInputDTO credentialInputDTO;
        this.validate(performPaymentDTO, sessionData, bl, false, true, false, paymentCreationType);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performPaymentDTO.getType());
        InternalAccountOwner internalAccountOwner = performPaymentDTO.getSubject();
        LocateAccountOwnerResult locateAccountOwnerResult = sessionData == null ? this.transactionService.locateForPayment(internalAccountOwner) : this.accountHandler.locate((AccountOwner)internalAccountOwner);
        InternalAccountOwner internalAccountOwner2 = performPaymentDTO.getOwner();
        LocateAccountOwnerResult locateAccountOwnerResult2 = sessionData == null ? this.accountHandler.locate((AccountOwner)internalAccountOwner2) : (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner2));
        InternalAccountOwner internalAccountOwner3 = locateAccountOwnerResult2.getInternalAccountOwner();
        InternalAccountOwner internalAccountOwner4 = locateAccountOwnerResult.getInternalAccountOwner();
        BigDecimal bigDecimal = performPaymentDTO.getAmount();
        if (bigDecimal == null && paymentTransferType.isUseFixedAmount()) {
            bigDecimal = paymentTransferType.getFixedAmount();
            performPaymentDTO.setAmount(bigDecimal);
        }
        this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performPaymentDTO.getCustomValues());
        PaymentPreviewVO paymentPreviewVO = this.preview(performPaymentDTO, paymentTransferType, internalAccountOwner3, internalAccountOwner4, bigDecimal);
        if (!BigDecimalHelper.isPositive((BigDecimal)paymentPreviewVO.getMainAmount().getAmount())) {
            throw new ValidationException(this.message(BankingKeys.Transfers.ERROR_INVALID_AMOUNT, new Object[0]));
        }
        Pair pair = this.transactionAuthorizationService.initialAuthorization(paymentTransferType, bigDecimal);
        paymentPreviewVO.setAttribute(AuthorizationLevel.class.getSimpleName(), pair == null ? null : pair.getSecond());
        paymentPreviewVO.setPendingAuthorization(pair != null);
        paymentPreviewVO.setConfirmationMessage(this.getTranslatedValue((BaseEntity)paymentTransferType, QPaymentTransferType.paymentTransferType.confirmationMessage));
        if (this.transactionService.isCheckConfirmation(paymentTransferType, internalAccountOwner3, performPaymentDTO.getAmount(), DateHelper.now())) {
            credentialInputDTO = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput();
            paymentPreviewVO.setConfirmationPasswordInput(credentialInputDTO);
            if (sessionData != null && credentialInputDTO != null) {
                credentialInputDTO.setEmailToSendOtp(null);
                credentialInputDTO.setMobilePhonesToSendOtp(null);
            }
        }
        paymentPreviewVO.setSkipConfirmation(paymentPreviewVO.getConfirmationPasswordInput() == null && paymentTransferType.isSkipConfirmation());
        credentialInputDTO = null;
        if (bl2) {
            Account account = this.accountService.load(internalAccountOwner3, paymentTransferType.getFrom());
            Account account2 = this.accountService.load(internalAccountOwner4, paymentTransferType.getTo());
            credentialInputDTO = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.PREVIEW, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performPaymentDTO).attribute("paymentType", (Object)paymentTransferType).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)internalAccountOwner3).attribute("fromOwnerResult", (Object)locateAccountOwnerResult2).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)internalAccountOwner4).attribute("toOwnerResult", (Object)locateAccountOwnerResult).attribute("preview", (Object)paymentPreviewVO).attribute("authorizationType", pair == null ? null : pair.getFirst()).attribute("authorizationLevel", pair == null ? null : pair.getSecond());
            credentialInputDTO.fireValidated();
        }
        this.transactionService.updatePreviewAndPayment((BasePaymentPreviewVO)paymentPreviewVO, (PerformTransactionDTO)performPaymentDTO, locateAccountOwnerResult2, locateAccountOwnerResult, (TransferType)paymentTransferType, sessionData);
        if (credentialInputDTO != null) {
            credentialInputDTO.fireSaved();
        }
        return paymentPreviewVO;
    }

    public PaymentData getData(Long l) throws FrameworkException {
        Payment payment = this.find(Payment.class, l);
        return this.getData(payment, true);
    }

    public PaymentData getData(Payment payment, boolean bl) {
        PerformPaymentDTO performPaymentDTO;
        PaymentTransferType paymentTransferType;
        PaymentData paymentData = (PaymentData)this.transactionService.newData((Transaction)payment, bl);
        if (payment.getAuthorizationStatus() == TransactionAuthorizationStatus.PENDING_AUTHORIZATION) {
            paymentTransferType = (PaymentTransferType)payment.getType();
            performPaymentDTO = new PerformPaymentDTO();
            performPaymentDTO.setAttribute(TransactionData.TRANSACTION.getName(), (Object)payment);
            performPaymentDTO.setAmount(payment.getAmount());
            performPaymentDTO.setOwner(payment.getFromOwner());
            performPaymentDTO.setSubject(payment.getToOwner());
            performPaymentDTO.setType(new TransferTypeVO(payment.getType().getId()));
            performPaymentDTO.setCustomValues(this.conversionHandler.convertList(CustomFieldValueDTO.class, (Iterable)payment.getCustomValues()));
            paymentData.setFeesOnAuthorization(this.transferFeeService.preview((PerformTransactionDTO)performPaymentDTO, paymentTransferType, payment.getFromOwner(), payment.getToOwner(), payment.getAmount()));
        }
        if ((paymentTransferType = this.voucherService.getDetailsOnPayment(payment)) != null) {
            performPaymentDTO = paymentData.getTransaction();
            performPaymentDTO.setDescription(paymentTransferType.getDescription());
            performPaymentDTO.setFromName(paymentTransferType.getFromName());
            performPaymentDTO.setToName(paymentTransferType.getToName());
            paymentData.setVoucherTransaction(paymentTransferType.getVoucherTransaction());
            paymentData.setBoughtVouchers(paymentTransferType.getBoughtVouchers());
        }
        if ((performPaymentDTO = payment.getTransfer()) != null && bl) {
            TransferData transferData = this.transferService.getData((Transfer)performPaymentDTO, false);
            paymentData.setTransferData(transferData);
        }
        return paymentData;
    }

    public Payment importPayment(PerformPaymentDTO performPaymentDTO, boolean bl) throws FrameworkException {
        this.setSendNotifications(performPaymentDTO, bl);
        return this.doPerform(performPaymentDTO, true, PaymentCreationType.IMPORT, null);
    }

    @PostConstruct
    public void initialize() {
        this.transactionAuthorizationService.registerHandler(AuthorizationAction.AUTHORIZED, Payment.class, payment -> {
            this.transferService.insertPaymentTransfer(payment);
            if (payment.getCreationType() == PaymentCreationType.VOUCHER_BUYING) {
                QVoucherPack qVoucherPack = QVoucherPack.voucherPack;
                VoucherPack voucherPack = (VoucherPack)((DBQuery)this.from(new EntityPath[]{qVoucherPack}).where((Predicate)qVoucherPack.buy().eq(payment))).singleResult((Expression)qVoucherPack);
                if (voucherPack.getConfiguration().isReserveAmount()) {
                    this.accountService.reserveAmountIfNeeded(voucherPack);
                }
            }
        });
    }

    public void notifyPaymentPerformed(Payment payment) {
        if (payment.isPendingAuthorization()) {
            this.transactionAuthorizationService.notifyPendingAuthorization((BasePayment)payment);
        } else {
            this.notificationHandler.admin().paymentPerformed((Transaction)payment);
            PaymentTransferType paymentTransferType = (PaymentTransferType)payment.getType();
            this.transactionFeedbackService.notifyTransactionFeedback(paymentTransferType);
            User user = payment.getFromUser();
            if (user != null && paymentTransferType.isNotifyPaymentPerformed()) {
                if (payment.getChannel().isSms()) {
                    this.notificationHandler.user((BasicUser)user).account().smsPerformedPayment((Transaction)payment, payment.getCurrencyAmount(), (AccountOwner)payment.getToOwner(), payment.getDescription(), payment.getTransactionNumber());
                } else {
                    this.notificationHandler.user((BasicUser)user).account().allNonSmsPerformedPayments((Transaction)payment, payment.getCurrencyAmount(), (AccountOwner)payment.getToOwner(), payment.getDescription(), payment.getTransactionNumber());
                }
            }
        }
    }

    public PaymentVO perform(PerformPaymentDTO performPaymentDTO) throws TransferException, ValidationException, PasswordException {
        SessionData sessionData = this.getSessionData();
        Payment payment = this.doPerform(performPaymentDTO, true, this.resolveCreationType(sessionData.getChannel()), null);
        return (PaymentVO)this.conversionHandler.convert(PaymentVO.class, (Object)payment);
    }

    public PaymentPreviewVO preview(PerformPaymentDTO performPaymentDTO) throws ValidationException {
        return this.doPreview(performPaymentDTO, true, true, null, PaymentCreationType.DIRECT);
    }

    public PaymentPreviewVO previewAcceptPaymentRequest(PaymentRequest paymentRequest) {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO((InternalTransaction)paymentRequest, true);
        PaymentPreviewVO paymentPreviewVO = this.doPreview(performPaymentDTO, false, true, null, PaymentCreationType.REQUEST);
        paymentPreviewVO.setSkipConfirmation(false);
        return paymentPreviewVO;
    }

    public PaymentPreviewVO previewApproveTicket(Ticket ticket) {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO((InternalTransaction)ticket, true);
        PaymentPreviewVO paymentPreviewVO = this.doPreview(performPaymentDTO, false, true, null, PaymentCreationType.TICKET);
        paymentPreviewVO.setSkipConfirmation(false);
        return paymentPreviewVO;
    }

    public PaymentPreviewVO previewReceive(PerformPaymentDTO performPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performPaymentDTO.getOwner();
        return (PaymentPreviewVO)this.transactionService.receive(internalAccountOwner, () -> this.doPreview(performPaymentDTO, true, true, sessionData, PaymentCreationType.POS));
    }

    public PaymentPreviewVO previewVoucherBuying(VoucherType voucherType, User user, BigDecimal bigDecimal, List<CustomFieldValueDTO> list) {
        PerformPaymentDTO performPaymentDTO = this.toBuyVoucherParams(voucherType, user, bigDecimal, list);
        return this.doPreview(performPaymentDTO, true, true, null, PaymentCreationType.VOUCHER_BUYING);
    }

    public Payment processTicket(Ticket ticket) {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO((InternalTransaction)ticket, false);
        Payment payment = new Payment();
        if (ticket.getBy() instanceof Operator) {
            payment.setReceivedBy((Operator)ticket.getBy());
        }
        return this.doPerform(performPaymentDTO, null, null, payment, PaymentCreationType.TICKET);
    }

    public PaymentVO receive(PerformPaymentDTO performPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performPaymentDTO.getOwner();
        Payment payment = (Payment)this.transactionService.receive(internalAccountOwner, () -> this.doPerform(performPaymentDTO, true, PaymentCreationType.POS, sessionData));
        return (PaymentVO)this.conversionHandler.convert(PaymentVO.class, (Object)payment);
    }

    public Payment refund(Voucher voucher) {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO(voucher);
        Payment payment = new Payment();
        return this.doPerform(performPaymentDTO, null, null, payment, PaymentCreationType.VOUCHER_REFUNDING);
    }

    public String toId(Long l) {
        return l == null ? null : l.toString();
    }

    public void validate(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        this.validate(performPaymentDTO, null, true, false, true, false, PaymentCreationType.DIRECT);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    protected PerformPaymentDTO toBuyVoucherParams(VoucherType voucherType, User user, BigDecimal bigDecimal, List<CustomFieldValueDTO> list) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner((InternalAccountOwner)user);
        performPaymentDTO.setSubject((InternalAccountOwner)SystemAccountOwner.instance());
        performPaymentDTO.setAmount(bigDecimal);
        performPaymentDTO.setType(new TransferTypeVO(voucherType.getConfiguration().getBuyType().getId()));
        performPaymentDTO.setCustomValues(list);
        return performPaymentDTO;
    }

    private Payment doPerform(PerformPaymentDTO performPaymentDTO, boolean bl, PaymentCreationType paymentCreationType, SessionData sessionData) {
        Token token;
        LocateAccountOwnerResult locateAccountOwnerResult;
        this.validate(performPaymentDTO, sessionData, bl, false, false, true, paymentCreationType);
        SessionData sessionData2 = this.getSessionData();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performPaymentDTO.getType());
        InternalAccountOwner internalAccountOwner = performPaymentDTO.getOwner();
        InternalAccountOwner internalAccountOwner2 = performPaymentDTO.getSubject();
        if (sessionData == null) {
            locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        } else {
            locateAccountOwnerResult = (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner));
            performPaymentDTO.setOwner(locateAccountOwnerResult.getInternalAccountOwner());
        }
        if (paymentCreationType.isUseConfirmationPassword() && this.transactionService.isCheckConfirmation(paymentTransferType, locateAccountOwnerResult.getInternalAccountOwner(), performPaymentDTO.getAmount(), DateHelper.now())) {
            token = PerformPaymentConfirmationField.confirmation((PerformInternalTransactionDTO)performPaymentDTO);
            if (paymentCreationType == PaymentCreationType.POS) {
                DeviceConfirmationServiceLocal.setCreatorUserAttr((CreateDeviceConfirmationParams)token, (BasicUser)sessionData.getLoggedBasicUser());
            }
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(performPaymentDTO.getConfirmationPassword(), (CreateDeviceConfirmationParams)token);
        }
        if ((token = sessionData2.getToken()) instanceof NFCToken) {
            ((NFCToken)token).resetChallenge();
        }
        LocateAccountOwnerResult locateAccountOwnerResult2 = paymentCreationType == PaymentCreationType.POS ? this.accountHandler.locate((AccountOwner)internalAccountOwner2) : this.transactionService.locateForPayment(internalAccountOwner2);
        this.transactionServiceSecurity.checkPaymentParameters(locateAccountOwnerResult, locateAccountOwnerResult2, paymentCreationType, paymentTransferType);
        Payment payment = new Payment();
        payment.setCreationType(paymentCreationType);
        if (sessionData != null) {
            payment.setReceivedBy(sessionData.getLoggedOperator());
            payment.setAccessClient(sessionData.getAccessClient());
        }
        payment.setSendNotifications(this.isSendNotifications(performPaymentDTO));
        return this.doPerform(performPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, payment, paymentCreationType);
    }

    private <P extends Payment> P doPerform(PerformPaymentDTO performPaymentDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, P p, PaymentCreationType paymentCreationType) {
        if (locateAccountOwnerResult == null) {
            locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performPaymentDTO.getOwner());
        }
        if (locateAccountOwnerResult2 == null) {
            locateAccountOwnerResult2 = this.transactionService.locateForPayment(performPaymentDTO.getSubject());
        }
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performPaymentDTO.getType());
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)performPaymentDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        if (paymentCreationType.validatePaymentAmount()) {
            this.transactionService.validatePaymentAmount(locateAccountOwnerResult, locateAccountOwnerResult2, paymentTransferType, bigDecimal, null);
        }
        if (paymentCreationType.validateMinTimeBetweenPayments()) {
            this.transactionService.validateMinTimeBetweenPayments(locateAccountOwnerResult, paymentTransferType);
        }
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getFrom());
        Account account2 = this.accountService.load(locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CONFIRM, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performPaymentDTO).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)locateAccountOwnerResult2.getAccountOwner()).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        this.transactionService.fill(p, (TransferType)paymentTransferType, paymentCreationType, account, account2, (BasicUser)locateAccountOwnerResult2.getOperator(), performPaymentDTO.getFromName(), performPaymentDTO.getToName(), bigDecimal, performPaymentDTO.getDescription(), (Collection)performPaymentDTO.getCustomValues());
        boolean bl = paymentCreationType != PaymentCreationType.IMPORT || p.isSendNotifications();
        p.setPendingNotification(p.isPendingAuthorization() || bl);
        this.transactionService.persist(p);
        if (p.isPendingAuthorization()) {
            this.accountService.reserveAmountForAuthorization((PerformTransactionDTO)performPaymentDTO, p);
            this.transactionAuthorizationService.authorizeFirstLevelIfNeeded(p);
        } else if (p.getTransfer() == null) {
            this.transferService.insertPaymentTransfer(p);
        }
        if (p.isPendingNotification()) {
            this.recurringTaskHandler.scheduleAwake(TransactionNotificationProcessingRecurringTask.class);
        }
        extensionPointAccessor.attribute("transaction", p).attribute("authorizationType", (Object)p.getAuthorizationType()).attribute("authorizationLevel", (Object)p.getNextAuthorizationLevel()).fireSaved();
        return p;
    }

    private boolean isSendNotifications(PerformPaymentDTO performPaymentDTO) {
        return !Boolean.FALSE.equals(performPaymentDTO.getAttribute(IMPORT_PAYMENT_SEND_NOTIFICATIONS));
    }

    private PaymentPreviewVO preview(PerformPaymentDTO performPaymentDTO, PaymentTransferType paymentTransferType, InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, BigDecimal bigDecimal) {
        Account account = this.accountService.load(internalAccountOwner, paymentTransferType.getFrom());
        Account account2 = this.accountService.load(internalAccountOwner2, paymentTransferType.getTo());
        TransferFeesPreviewVO transferFeesPreviewVO = this.transferFeeService.preview((PerformTransactionDTO)performPaymentDTO, paymentTransferType, internalAccountOwner, internalAccountOwner2, bigDecimal);
        PaymentPreviewVO paymentPreviewVO = (PaymentPreviewVO)this.conversionHandler.convert(PaymentPreviewVO.class, (Object)transferFeesPreviewVO);
        FromRatesData fromRatesData = this.rateHandler.getFromRates(account, (TransferType)paymentTransferType, paymentPreviewVO.getTotalAmount().getAmount(), null, RateVisibility.PARAM);
        this.rateHandler.copy((HasRates)fromRatesData, (HasRates)paymentPreviewVO);
        if (fromRatesData.isEnforcedZeroDRate()) {
            paymentPreviewVO.setPreviousDRate(fromRatesData.getPreviousD());
            paymentPreviewVO.setTransferDRate(fromRatesData.getTransferD());
        }
        paymentPreviewVO.setFromAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        paymentPreviewVO.setToAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account2));
        return paymentPreviewVO;
    }

    private PaymentCreationType resolveCreationType(Channel channel) {
        BuiltInChannel builtInChannel = (BuiltInChannel)ObjectHelper.defaultValue((Object)BuiltInChannel.getByInternalName((String)channel.getInternalName()), (Object)BuiltInChannel.WEB_SERVICES);
        switch (builtInChannel) {
            case POS: {
                return PaymentCreationType.POS;
            }
            case TICKET: {
                return PaymentCreationType.TICKET;
            }
            case EASY_INVOICE: {
                return PaymentCreationType.EASY_INVOICE;
            }
        }
        return PaymentCreationType.DIRECT;
    }

    private void setSendNotifications(PerformPaymentDTO performPaymentDTO, boolean bl) {
        performPaymentDTO.setAttribute(IMPORT_PAYMENT_SEND_NOTIFICATIONS, (Object)bl);
    }

    private PerformPaymentDTO toPerformDTO(ExternalPayment externalPayment, User user) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner(externalPayment.getFromOwner());
        performPaymentDTO.setSubject((InternalAccountOwner)user);
        performPaymentDTO.setAmount(externalPayment.getAmount());
        performPaymentDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)externalPayment.getType()));
        performPaymentDTO.setDescription(externalPayment.getDescription());
        this.customFieldValueHandler.cloneCustomValuesData((ModelWithCustomValues)performPaymentDTO, (Collection)externalPayment.getCustomValues());
        ModelHelper.clearIds((Iterable)performPaymentDTO.getCustomValues());
        return performPaymentDTO;
    }

    private PerformPaymentDTO toPerformDTO(InternalTransaction internalTransaction, boolean bl) {
        boolean bl2;
        PaymentRequest paymentRequest;
        InternalAccountOwner internalAccountOwner = internalTransaction.getFromOwner();
        if (internalTransaction instanceof PaymentRequest) {
            paymentRequest = (PaymentRequest)internalTransaction;
            boolean bl3 = bl2 = paymentRequest.getScheduling() == null || paymentRequest.getScheduling() == SchedulingType.NOT_SCHEDULED;
            if (!bl2 || !ObjectHelper.isOneOf((Object)paymentRequest.getStatus(), (Object[])new Object[]{PaymentRequestStatus.OPEN, PaymentRequestStatus.SCHEDULED})) {
                throw new IllegalActionException("Invalid scheduled payment status: " + String.valueOf(paymentRequest.getStatus()));
            }
        } else if (internalTransaction instanceof Ticket) {
            paymentRequest = (Ticket)internalTransaction;
            bl2 = bl;
            if (bl2 && paymentRequest.getStatus() != TicketStatus.OPEN || !bl2 && paymentRequest.getStatus() != TicketStatus.APPROVED && (paymentRequest.getStatus() != TicketStatus.OPEN || StringHelper.isNotBlank((Object)paymentRequest.getSuccessUrl()))) {
                throw new IllegalActionException("Invalid ticket status: " + String.valueOf(paymentRequest.getStatus()));
            }
            if (internalAccountOwner == null) {
                internalAccountOwner = this.getLoggedUser();
            }
        }
        paymentRequest = new PerformPaymentDTO();
        paymentRequest.setOwner(internalAccountOwner);
        paymentRequest.setSubject(internalTransaction.getToOwner());
        paymentRequest.setFromName(internalTransaction.getFromName());
        paymentRequest.setToName(internalTransaction.getFromName());
        paymentRequest.setAmount(internalTransaction.getAmount());
        paymentRequest.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)internalTransaction.getType()));
        paymentRequest.setDescription(internalTransaction.getDescription());
        Set set = internalTransaction.getCustomValues();
        Set<TransactionCustomFieldValue> set2 = new HashSet();
        if (bl && CollectionHelper.isNotEmpty((Iterable)set)) {
            List list = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
            for (TransactionCustomFieldValue transactionCustomFieldValue : set) {
                if (!list.contains(transactionCustomFieldValue.getField())) continue;
                set2.add(transactionCustomFieldValue);
            }
        } else if (!bl) {
            set2 = set;
        }
        if (bl) {
            paymentRequest.setCustomValues(this.conversionHandler.convertList(CustomFieldValueDTO.class, set2));
        } else {
            this.customFieldValueHandler.cloneCustomValuesData((ModelWithCustomValues)paymentRequest, set2);
        }
        ModelHelper.clearIds((Iterable)paymentRequest.getCustomValues());
        return paymentRequest;
    }

    private PerformPaymentDTO toPerformDTO(Voucher voucher) {
        VoucherPack voucherPack = voucher.getPack();
        PaymentTransferType paymentTransferType = voucherPack.getConfiguration().getRefundType();
        if (voucherPack.getBuyer() == null || ObjectHelper.isNotOneOf((Object)voucher.getStatus(), (Object[])new Object[]{VoucherStatus.OPEN, VoucherStatus.EXPIRED}) || voucher.getRefund() != null || paymentTransferType == null) {
            throw new IllegalActionException();
        }
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setOwner((InternalAccountOwner)SystemAccountOwner.instance());
        performPaymentDTO.setSubject((InternalAccountOwner)voucherPack.getBuyer());
        performPaymentDTO.setAmount(voucher.getBalance());
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return performPaymentDTO;
    }

    private void validate(PerformPaymentDTO performPaymentDTO, SessionData sessionData, boolean bl, boolean bl2, boolean bl3, boolean bl4, PaymentCreationType paymentCreationType) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performPaymentDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(performPaymentDTO.getSubject());
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)performPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, sessionData, paymentCreationType).validateCustomFields(bl).allowSearchingTTWhenNoneIsGiven(true).validateConfirmationPassword(bl2).excludeHideInForm(bl3).validateNFCChallenge(bl4).validateAmount(true).build();
        Validator validator = this.transactionService.prepareValidation(prepareValidationParameter).getValidator();
        this.validate(validator, performPaymentDTO, "performPaymentDTO");
    }
}

