/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import java.util.Collection;
import org.cyclos.entities.banking.QVoucher;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpireVouchersRecurringTask
extends EntityBatchRecurringTask<Voucher> {
    @Autowired
    private VoucherServiceLocal voucherService;

    public ExpireVouchersRecurringTask() {
        super(Voucher.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.EXPIRE_VOUCHERS;
    }

    @Override
    protected void finish(Voucher voucher, Throwable throwable) throws Throwable {
        if (voucher.getStatus().isActuallyOpen()) {
            voucher.setStatus(VoucherStatus.EXPIRED);
        }
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QVoucher qVoucher = QVoucher.voucher;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qVoucher}).where(new Predicate[]{qVoucher.status.in((Object[])VoucherStatus.getExpirableStatuses()), Expressions.asDateTime((Expression)qVoucher.expirationDate.coalesce(new Expression[]{qVoucher.pack().expirationDate})).lt((Expression)Expressions.currentTimestamp())})).limit(200L)).list((Expression)qVoucher.id);
    }

    @Override
    protected void process(Voucher voucher) throws Throwable {
        this.voucherService.expire(voucher);
    }
}

