/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QAccountRates;
import org.cyclos.entities.banking.QRateParameters;
import org.cyclos.entities.banking.RateParameters;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.RatedCurrencyAmount;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.RateTypeHandler;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.ResetRatesBackgroundTask;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateParametersDTO;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRateTypeHandlerImpl<T, R extends RateParameters, D extends RateParametersDTO>
extends BaseNetworkedHandlerImpl
implements RateTypeHandler<T, R, D> {
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;

    public void applyIncomingTransfer(RatesData ratesData, Transfer transfer) {
        Date date = transfer.getDate();
        Currency currency = transfer.getTo().getType().getCurrency();
        if (this.isEnabled(currency, date) && transfer.getTo().getType().getLimitType() != AccountTypeLimitType.UNLIMITED) {
            BigDecimal bigDecimal = ratesData.getVirtualRatedBalance();
            Object object = this.getNullSafeRawRate((RatedEntity)transfer, currency, date);
            object = this.adjustIncomingRawRateInTransfer(object, transfer);
            RatedCurrencyAmount ratedCurrencyAmount = new RatedCurrencyAmount(transfer.getAmount(), object, currency);
            Object object2 = this.getNullSafeRawRate((RatedEntity)ratesData, currency, date);
            RatedCurrencyAmount ratedCurrencyAmount2 = new RatedCurrencyAmount(bigDecimal, object2, currency);
            T t = this.merge(ratedCurrencyAmount2, ratedCurrencyAmount, date);
            this.setRawRate((RatedEntity)ratesData, t);
        }
    }

    public void calculateFromRates(FromRatesData fromRatesData, Account account, TransferType transferType, BigDecimal bigDecimal) {
        Date date;
        Currency currency = account.getCurrency();
        if (this.isEnabled(currency, date = fromRatesData.getDate())) {
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal3;
            if (account.getType().getLimitType() == AccountTypeLimitType.UNLIMITED) {
                this.applyTransferTypeDefaults((RatesData)fromRatesData, transferType);
            } else if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal) && BigDecimalHelper.isPositive((BigDecimal)(bigDecimal3 = bigDecimal.subtract(bigDecimal2 = fromRatesData.getVirtualRatedBalance()).max(BigDecimal.ZERO)))) {
                fromRatesData.setChangedDueToCreation(true);
                BigDecimal bigDecimal4 = this.getCreationValue(currency, date);
                Object object = this.convert(bigDecimal4, date);
                RatedCurrencyAmount ratedCurrencyAmount = new RatedCurrencyAmount(bigDecimal3, object, currency);
                Object object2 = this.getNullSafeRawRate((RatedEntity)fromRatesData, null, date);
                BigDecimal bigDecimal5 = bigDecimal.subtract(bigDecimal3);
                RatedCurrencyAmount ratedCurrencyAmount2 = new RatedCurrencyAmount(bigDecimal5, object2, currency);
                T t = this.merge(ratedCurrencyAmount, ratedCurrencyAmount2, date);
                this.setRawRate((RatedEntity)fromRatesData, t);
                this.setRate((HasRates)fromRatesData, this.convert(t, date));
            }
        }
    }

    public BigDecimal getCreationValue(Currency currency, Date date) {
        R r = this.getRateParameters(currency, date);
        if (r == null) {
            return null;
        }
        return r.getCreationValue();
    }

    public Date getEnableDate(Currency currency, Date date) {
        Date date2 = date == null ? DateHelper.now() : date;
        QRateParameters qRateParameters = this.getQuery();
        List list = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qRateParameters}).where((Predicate)qRateParameters.currency().id.eq((Object)currency.getId()))).orderBy(qRateParameters.startDate.desc())).list((Expression)qRateParameters);
        Date date3 = null;
        for (RateParameters rateParameters : list) {
            if (rateParameters.getStartDate().after(date2)) continue;
            if (rateParameters.getEndDate() != null && !rateParameters.getEndDate().after(date2) && !rateParameters.getEndDate().equals(date3)) break;
            date3 = rateParameters.getStartDate();
        }
        return date3;
    }

    public R getRateParameters(Currency currency, Date date) {
        if (date == null) {
            return this.getCurrentRateParameters(currency);
        }
        List<R> list = this.getParametersList();
        Date date2 = date == null ? DateHelper.now() : date;
        for (RateParameters rateParameters : list) {
            if (!rateParameters.getCurrency().equals((Object)currency) || rateParameters.getStartDate().after(date2) || rateParameters.getEndDate() != null && !rateParameters.getEndDate().after(date2)) continue;
            return (R)rateParameters;
        }
        return null;
    }

    public T inverseMerge(RatedCurrencyAmount<T> ratedCurrencyAmount, RatedCurrencyAmount<T> ratedCurrencyAmount2, Date date) {
        Currency currency;
        Currency currency2 = ratedCurrencyAmount.getCurrency();
        if (!currency2.equals((Object)(currency = ratedCurrencyAmount2.getCurrency()))) {
            throw new IllegalArgumentException("inequal currencies for two to-be-merged sets of units");
        }
        if (!this.isEnabled(currency2, date)) {
            return null;
        }
        BigDecimal bigDecimal = ratedCurrencyAmount.getAmount();
        BigDecimal bigDecimal2 = ratedCurrencyAmount2.getAmount();
        ratedCurrencyAmount.setDate(date);
        BigDecimal bigDecimal3 = this.convert(ratedCurrencyAmount.getRawRate(), date);
        ratedCurrencyAmount2.setDate(date);
        BigDecimal bigDecimal4 = this.convert(ratedCurrencyAmount2.getRawRate(), date);
        BigDecimal bigDecimal5 = bigDecimal.multiply(bigDecimal3);
        BigDecimal bigDecimal6 = bigDecimal2.multiply(bigDecimal4);
        BigDecimal bigDecimal7 = bigDecimal5.subtract(bigDecimal6);
        BigDecimal bigDecimal8 = bigDecimal.subtract(bigDecimal2);
        BigDecimal bigDecimal9 = bigDecimal7.divide(bigDecimal8, 10, RoundingMode.HALF_UP);
        Object object = this.convert(bigDecimal9, date);
        return (T)object;
    }

    public boolean isEnabled(Currency currency, Date date) {
        return this.getRateParameters(currency, date) != null;
    }

    public boolean isVisible(Account account, Date date, RateVisibility rateVisibility) {
        if (rateVisibility == null || rateVisibility == RateVisibility.NOT || !this.isEnabled(account.getCurrency(), date)) {
            return false;
        }
        boolean bl = account.getType().getLimitType() == AccountTypeLimitType.UNLIMITED;
        switch (rateVisibility) {
            case ALL: {
                return true;
            }
            case PARAM: {
                return this.isVisibleToUser(account.getCurrency(), date);
            }
            case PARAM_NO_UNLIMITED: {
                return !bl && this.isVisibleToUser(account.getCurrency(), date);
            }
        }
        return false;
    }

    public boolean isVisibleToUser(Currency currency, Date date) {
        R r = this.getRateParameters(currency, date);
        if (r != null) {
            return this.isAdmin() || r.isShowToUser();
        }
        return false;
    }

    public T merge(RatedCurrencyAmount<T> ratedCurrencyAmount, RatedCurrencyAmount<T> ratedCurrencyAmount2, Date date) throws IllegalArgumentException {
        Currency currency;
        Currency currency2 = ratedCurrencyAmount.getCurrency();
        if (!currency2.equals((Object)(currency = ratedCurrencyAmount2.getCurrency()))) {
            throw new IllegalArgumentException("inequal currencies for two to-be-merged sets of units");
        }
        if (!this.isEnabled(currency2, date)) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)ratedCurrencyAmount.getAmount());
        BigDecimal bigDecimal2 = BigDecimalHelper.zeroWhenNull((BigDecimal)ratedCurrencyAmount2.getAmount());
        ratedCurrencyAmount.setDate(date);
        BigDecimal bigDecimal3 = this.convert(ratedCurrencyAmount.getRawRate(), date);
        ratedCurrencyAmount2.setDate(date);
        BigDecimal bigDecimal4 = this.convert(ratedCurrencyAmount2.getRawRate(), date);
        BigDecimal bigDecimal5 = bigDecimal.multiply(bigDecimal3);
        BigDecimal bigDecimal6 = bigDecimal2.multiply(bigDecimal4);
        BigDecimal bigDecimal7 = bigDecimal5.add(bigDecimal6);
        BigDecimal bigDecimal8 = bigDecimal.add(bigDecimal2);
        BigDecimal bigDecimal9 = bigDecimal7.divide(bigDecimal8, 10, RoundingMode.HALF_UP);
        Object object = this.convert(bigDecimal9, date);
        return (T)object;
    }

    public long nullAllAccountRates(Currency currency) {
        boolean bl = currency.getaRateParameters() == null && currency.getdRateParameters() == null;
        QAccountRates qAccountRates = QAccountRates.accountRates;
        JPAUpdateClause jPAUpdateClause = this.update((EntityPath<?>)qAccountRates).setNull(this.getAccountRatesFieldPath());
        if (bl) {
            jPAUpdateClause.set((Path)qAccountRates.rateBalanceCorrection, (Object)BigDecimal.ZERO);
        }
        return jPAUpdateClause.where(new Predicate[]{qAccountRates.account().type().currency().id.eq((Object)currency.getId())}).execute();
    }

    public void resolveValidator(Validator validator, CurrencyDTO currencyDTO) {
        RateParametersDTO rateParametersDTO = this.getRateParametersDTO(currencyDTO);
        if (rateParametersDTO != null && rateParametersDTO.isEnabledOnForm()) {
            Validator validator2 = new Validator();
            validator2.general(object -> {
                if (this.allowEnabling(currencyDTO)) {
                    return null;
                }
                return new ValidationError(BankingKeys.Rates.REENABLE_NOT_ALLOWED);
            });
            this.assignValidator(validator, validator2);
        }
    }

    public void toEntity(Currency currency, D d) {
        RateParametersChangeAction rateParametersChangeAction = this.haveRateParametersChanged(currency, d);
        switch (rateParametersChangeAction.ordinal()) {
            case 2: 
            case 4: {
                break;
            }
            case 0: {
                this.appendToRateParametersHistory(d, currency);
                break;
            }
            case 1: {
                this.appendToRateParametersHistory(d, currency);
                break;
            }
            case 3: {
                this.immediateDisableActions(currency);
                RateParameters rateParameters = this.closeRateParametersInHistory(currency, true);
                this.backgroundTaskHandler.schedule(ResetRatesBackgroundTask.scheduling(rateParameters));
                break;
            }
        }
    }

    protected abstract T adjustIncomingRawRateInTransfer(T var1, Transfer var2);

    protected abstract void assignEntityToCurrency(R var1, Currency var2);

    protected abstract void assignValidator(Validator var1, Validator var2);

    protected <C> C convert(Class<C> clazz, Object object) {
        return (C)this.conversionHandler.convert(clazz, object);
    }

    protected abstract Path getAccountRatesFieldPath();

    protected abstract R getCurrentRateParameters(Currency var1);

    protected abstract Class<R> getEntityClass();

    protected abstract List<R> getParametersList();

    protected abstract QRateParameters getQuery();

    protected boolean hasEqualProperties(R r, D d) {
        boolean bl = r.isShowToUser() == d.isShowToUser();
        return bl;
    }

    protected void immediateDisableActions(Currency currency) {
    }

    private boolean allowEnabling(CurrencyDTO currencyDTO) {
        if (currencyDTO.isTransient()) {
            return true;
        }
        RateParameters rateParameters = this.getLastClosedRateParameters(currencyDTO.getId());
        if (rateParameters == null) {
            return true;
        }
        return !rateParameters.isMarkedForResetting();
    }

    private void appendToRateParametersHistory(D d, Currency currency) {
        Date date;
        RateParameters rateParameters = this.closeRateParametersInHistory(currency);
        Date date2 = date = rateParameters == null ? null : rateParameters.getEndDate();
        if (date == null) {
            date = DateHelper.now();
        }
        d.setId(null);
        d.setCurrency(new CurrencyVO(currency.getId()));
        d.setStartDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)date));
        RateParameters rateParameters2 = (RateParameters)this.conversionHandler.convert(this.getEntityClass(), d);
        this.assignEntityToCurrency(rateParameters2, currency);
    }

    private RateParameters closeRateParametersInHistory(Currency currency) {
        return this.closeRateParametersInHistory(currency, false);
    }

    private RateParameters closeRateParametersInHistory(Currency currency, boolean bl) {
        RateParameters rateParameters = this.getRateParameters(currency);
        if (rateParameters != null) {
            rateParameters.setEndDate(DateHelper.now());
            if (bl) {
                rateParameters.setMarkedForResetting(true);
            }
            this.entityManagerHandler.persist((IEntity)rateParameters);
            this.assignEntityToCurrency(null, currency);
        }
        return rateParameters;
    }

    private RateParameters getLastClosedRateParameters(Long l) {
        QRateParameters qRateParameters = this.getQuery();
        return (RateParameters)((DBQuery)((DBQuery)this.from(new EntityPath[]{qRateParameters}).where(new Predicate[]{qRateParameters.currency().id.eq((Object)l), qRateParameters.endDate.isNotNull()})).orderBy(qRateParameters.endDate.desc())).singleResult((Expression)qRateParameters);
    }

    private RateParametersChangeAction haveRateParametersChanged(Currency currency, D d) {
        if (currency.isTransient()) {
            if (d == null || !d.isEnabledOnForm()) {
                return RateParametersChangeAction.NORATES;
            }
            return RateParametersChangeAction.ENABLED_ANEW;
        }
        R r = this.getRateParameters(currency, null);
        if (d == null || !d.isEnabledOnForm()) {
            return r == null ? RateParametersChangeAction.NORATES : RateParametersChangeAction.DISABLED_ANEW;
        }
        if (d.getId() == null) {
            return RateParametersChangeAction.ENABLED_ANEW;
        }
        if (this.hasEqualProperties(r, d)) {
            return RateParametersChangeAction.UNCHANGED;
        }
        return RateParametersChangeAction.CHANGED;
    }

    abstract void applyTransferTypeDefaults(RatesData var1, TransferType var2);

    protected static enum RateParametersChangeAction {
        ENABLED_ANEW,
        CHANGED,
        UNCHANGED,
        DISABLED_ANEW,
        NORATES;

    }
}

