/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.cyclos.entities.Application;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivingRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NEXT;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.ARCHIVING;
    }

    @Override
    public String getNotesForLogging() {
        int n = this.cyclosProperties.getArchivingMonths();
        return n >= 1 ? String.format("Retention period: %d months", n) : "Disabled";
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.NEXT_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        Date date = this.getWindowEdge();
        if (!this.shouldRun(date)) {
            return 0L;
        }
        this.updateApplication(date);
        return this.archiveAccounts();
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    private long archiveAccounts() {
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            InvocationContext.ensure().addCommitListener(true, () -> this.applicationHandler.finishArchiving(0));
            return this.nativeQueryHandler.archiveAccountBalances();
        });
    }

    private Date getWindowEdge() {
        int n = this.cyclosProperties.getArchivingMonths();
        if (n < 1) {
            return null;
        }
        Date date = Date.from(OffsetDateTime.now(ZoneOffset.UTC).with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS).minusMonths(n).toInstant());
        return date;
    }

    private boolean shouldRun(Date date) {
        if (date == null) {
            return false;
        }
        return (Boolean)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            Application application = this.applicationHandler.getApplication();
            Date date2 = application.getArchivingDate();
            return date2 == null || date2.before(date) || !application.isArchivingFinished();
        });
    }

    private void updateApplication(Date date) {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Application application = this.applicationHandler.getApplication();
            application.setArchivingDate(date);
            application.setArchivingFinished(false);
            return null;
        });
    }
}

