/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.UserAccount;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.springframework.stereotype.Component;

@Component
public class AccountPaymentAmountLimitVOConverter
extends ObjectConverter<AccountPaymentAmountLimitVO> {
    public AccountPaymentAmountLimitVOConverter() {
        super(AccountPaymentAmountLimitVO.class);
    }

    @Override
    protected void fill(Object object, AccountPaymentAmountLimitVO accountPaymentAmountLimitVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, accountPaymentAmountLimitVO, objectArray, conversionContext);
        if (object instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)object;
            accountPaymentAmountLimitVO.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, userAccount));
            accountPaymentAmountLimitVO.setMaxLimit(userAccount.getPaymentAmountLimit());
            accountPaymentAmountLimitVO.setMaxLimitFromProduct(userAccount.isPaymentAmountLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerDayLimit(userAccount.getPaymentAmountPerDayLimit());
            accountPaymentAmountLimitVO.setMaxPerDayLimitFromProduct(userAccount.isPaymentAmountPerDayLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerWeekLimit(userAccount.getPaymentAmountPerWeekLimit());
            accountPaymentAmountLimitVO.setMaxPerWeekLimitFromProduct(userAccount.isPaymentAmountPerWeekLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerMonthLimit(userAccount.getPaymentAmountPerMonthLimit());
            accountPaymentAmountLimitVO.setMaxPerMonthLimitFromProduct(userAccount.isPaymentAmountPerMonthLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerYearLimit(userAccount.getPaymentAmountPerYearLimit());
            accountPaymentAmountLimitVO.setMaxPerYearLimitFromProduct(userAccount.isPaymentAmountPerYearLimitFromProduct());
        }
    }
}

