/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.Collection;
import java.util.EnumSet;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SingletonAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountHandlerImpl
extends BaseNetworkedHandlerImpl
implements AccountHandler {
    @Autowired
    private ContactServiceLocal contactService;

    public String getAccountNumber(IAccount iAccount) {
        Object object;
        boolean bl;
        if (iAccount == null) {
            return null;
        }
        String string = null;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(iAccount);
        AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
        boolean bl2 = bl = accountNumberConfiguration != null && accountNumberConfiguration.isEnabled();
        if (bl && iAccount instanceof UserAccount) {
            object = ((UserAccount)iAccount).getUser();
            bl = this.profileFieldHandler.isAllowed((BasicUser)object, (ProfileField)BasicProfileField.ACCOUNT_NUMBER, ProfileFieldAction.VIEW);
        }
        if (bl) {
            string = iAccount.getNumber();
            object = accountNumberConfiguration.getMask();
            if (StringHelper.isNotBlank((Object)object)) {
                string = MaskHelper.applyMask((String)object, (String)string);
            }
            return string;
        }
        return null;
    }

    public InternalAccountOwner getAccountOwner() {
        return this.locate((AccountOwner)this.getLoggedUser()).getInternalAccountOwner();
    }

    public boolean isSystemAccountOwner(AccountOwner accountOwner) {
        return this.locate(accountOwner).getAccountOwner() instanceof SystemAccountOwner;
    }

    public LocateAccountOwnerResult locate(AccountOwner accountOwner) {
        return this.locate(accountOwner, false);
    }

    public LocateAccountOwnerResult locate(AccountOwner accountOwner, boolean bl) {
        return this.locate(accountOwner, true, true, true, bl, null, null, false);
    }

    public LocateAccountOwnerResult locate(AccountOwner accountOwner, boolean bl, boolean bl2, boolean bl3, boolean bl4, Collection<PrincipalType> collection, PrincipalType principalType, boolean bl5) {
        LocateUserResult locateUserResult;
        if (accountOwner == null) {
            return LocateAccountOwnerResult.empty();
        }
        if (accountOwner instanceof SingletonAccountOwner) {
            return LocateAccountOwnerResult.instance((SingletonAccountOwner)((SingletonAccountOwner)accountOwner));
        }
        if (accountOwner instanceof BasicUser) {
            if (accountOwner instanceof Operator && !bl3) {
                SessionData sessionData = this.getSessionData();
                if (sessionData.isOperator() && sessionData.getLoggedBasicUser().equals((Object)accountOwner)) {
                    accountOwner = sessionData.getLoggedUser();
                } else {
                    throw new EntityNotFoundException(User.class);
                }
            }
            locateUserResult = new LocateUserResult((BasicUser)accountOwner);
        } else {
            UserLocatorVO userLocatorVO = null;
            if (accountOwner instanceof UserLocatorVO) {
                userLocatorVO = (UserLocatorVO)accountOwner;
            } else if (accountOwner instanceof BasicUserVO) {
                userLocatorVO = ((BasicUserVO)accountOwner).getLocator();
                if (userLocatorVO == null) {
                    userLocatorVO = (UserLocatorVO)this.conversionHandler.convert(UserLocatorVO.class, (Object)accountOwner);
                }
            } else if (accountOwner instanceof IEntity) {
                userLocatorVO = (UserLocatorVO)this.conversionHandler.convert(UserLocatorVO.class, (Object)accountOwner);
            } else {
                throw new EntityNotFoundException();
            }
            EnumSet<LocateUserOption> enumSet = null;
            enumSet = bl4 ? EnumSet.of(LocateUserOption.IGNORE_HIDDEN) : EnumSet.of(LocateUserOption.IGNORE_HIDDEN, LocateUserOption.ACCOUNT_OWNER_ONLY);
            if (bl5) {
                enumSet.add(LocateUserOption.RECORD_FAILURE);
            }
            if (this.getSessionData().getChannel().isPos()) {
                enumSet.add(LocateUserOption.INVERSE_RELATION);
                enumSet.add(LocateUserOption.ENFORCE_CHANNEL);
            }
            if ((locateUserResult = this.userLocatorHandler.locate(userLocatorVO, enumSet, collection, principalType)).getBasicUser().isOperator() && !bl3) {
                SessionData sessionData = this.getSessionData();
                if (sessionData.isOperator() && sessionData.getLoggedBasicUser().equals((Object)locateUserResult.getBasicUser())) {
                    locateUserResult = new LocateUserResult((BasicUser)sessionData.getLoggedUser());
                } else {
                    throw new EntityNotFoundException(User.class);
                }
            }
            if (!(locateUserResult.getPrincipalType() != null || bl || bl2 && this.contactService.isContact(this.getLoggedUser(), locateUserResult.getUser()))) {
                throw new EntityNotFoundException(User.class);
            }
        }
        if (locateUserResult.getBasicUser().isAdmin()) {
            return LocateAccountOwnerResult.system();
        }
        return new LocateAccountOwnerResult(locateUserResult);
    }

    public LocateAccountOwnerResult locateOrCurrent(AccountOwner accountOwner) {
        return this.locateOrCurrent(accountOwner, false);
    }

    public LocateAccountOwnerResult locateOrCurrent(AccountOwner accountOwner, boolean bl) {
        if (accountOwner == null) {
            accountOwner = this.getAccountOwner();
        }
        return this.locate(accountOwner, bl);
    }

    public AccountOwner toAccountOwnerVO(AccountOwner accountOwner) {
        return this.toAccountOwnerVO(accountOwner, false);
    }

    public AccountOwner toAccountOwnerVO(AccountOwner accountOwner, boolean bl) {
        if (accountOwner == null) {
            return null;
        }
        return this.toAccountOwnerVO(this.locate(accountOwner, true), bl);
    }

    public InternalAccountOwner toAccountOwnerVO(InternalAccountOwner internalAccountOwner) {
        return this.toAccountOwnerVO(internalAccountOwner, false);
    }

    public InternalAccountOwner toAccountOwnerVO(InternalAccountOwner internalAccountOwner, boolean bl) {
        return (InternalAccountOwner)this.toAccountOwnerVO((AccountOwner)internalAccountOwner, true);
    }

    public AccountOwner toAccountOwnerVO(LocateAccountOwnerResult locateAccountOwnerResult) {
        return this.toAccountOwnerVO(locateAccountOwnerResult, false);
    }

    public AccountOwner toAccountOwnerVO(LocateAccountOwnerResult locateAccountOwnerResult, boolean bl) {
        if (locateAccountOwnerResult == null) {
            return null;
        }
        if (bl && locateAccountOwnerResult.isOperator()) {
            return (AccountOwner)this.conversionHandler.convert(OperatorVO.class, (Object)locateAccountOwnerResult.getOperator());
        }
        if (locateAccountOwnerResult.isUser()) {
            return (AccountOwner)this.conversionHandler.convert(UserVO.class, (Object)locateAccountOwnerResult.getUser());
        }
        return locateAccountOwnerResult.getAccountOwner();
    }
}

