/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.QAccountFee;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.AccountFeeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accountfees.AccountFeeBalanceHandling;
import org.cyclos.model.banking.accountfees.AccountFeeChargeMode;
import org.cyclos.model.banking.accountfees.AccountFeeDTO;
import org.cyclos.model.banking.accountfees.AccountFeeData;
import org.cyclos.model.banking.accountfees.AccountFeePaymentDirection;
import org.cyclos.model.banking.accountfees.AccountFeeQuery;
import org.cyclos.model.banking.accountfees.AccountFeeRunMode;
import org.cyclos.model.banking.accountfees.AccountFeeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Page;
import org.cyclos.utils.Percentage;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountFeeServiceImpl
extends CRUDServiceImpl<AccountFee, QAccountFee, AccountFeeDTO, AccountFeeData, AccountTypeVO>
implements AccountFeeServiceLocal {
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public AccountFeeServiceImpl() {
        super(AccountFee.class, QAccountFee.accountFee, AccountFeeDTO.class);
    }

    public List<AccountFee> listScheduledFeesReservingAmount(UserAccount userAccount) {
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)userAccount.getUser()).member(userAccount.getType());
        ArrayList<AccountFee> arrayList = new ArrayList<AccountFee>();
        Date date = new Date();
        for (AccountFee accountFee : memberProductAccessor.getAccountFees()) {
            if (!accountFee.isEnabled() || !accountFee.getEnabledSince().before(date) || accountFee.getBalanceHandling() != AccountFeeBalanceHandling.RESERVE) continue;
            arrayList.add(accountFee);
        }
        return arrayList;
    }

    public List<AccountFee> listVisible() throws FrameworkException {
        List list = this.getProducts().userManagement().getUserAccountsAccess();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QAccountFee)this.$).accountType().in((Collection)list))).orderBy(new OrderSpecifier[]{((QAccountFee)this.$).accountType().name.asc(), ((QAccountFee)this.$).name.asc()})).list((Expression)this.$);
    }

    @Override
    public AccountFee newEntity(AccountTypeVO accountTypeVO) {
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountTypeVO);
        AccountFee accountFee = new AccountFee();
        accountFee.setAccountType(userAccountType);
        accountFee.setChargeMode(AccountFeeChargeMode.FIXED);
        accountFee.setRunMode(AccountFeeRunMode.SCHEDULED);
        accountFee.setRecurrence(TimeInterval.ONE_MONTH);
        accountFee.setPaymentDirection(AccountFeePaymentDirection.TO_SYSTEM);
        return accountFee;
    }

    public Integer resolveBigDecimalScale(AccountType accountType, AccountFeeChargeMode accountFeeChargeMode) throws FrameworkException {
        if (accountFeeChargeMode.isFixed()) {
            return accountType.getCurrency().getPrecision();
        }
        return BigDecimalHelper.MAX_SCALE;
    }

    public UserAccountType resolveUserAccountType(AccountFee accountFee) {
        GeneratedTransferType generatedTransferType = accountFee.getTransferType();
        boolean bl = accountFee.getPaymentDirection() == AccountFeePaymentDirection.TO_SYSTEM;
        return (UserAccountType)(bl ? generatedTransferType.getFrom() : generatedTransferType.getTo());
    }

    public Page<AccountFeeVO> search(AccountFeeQuery accountFeeQuery) {
        return this.search(AccountFeeVO.class, accountFeeQuery);
    }

    public <T> Page<T> search(Class<T> clazz, AccountFeeQuery accountFeeQuery) throws FrameworkException {
        UserAccountType userAccountType;
        Currency currency;
        DBQuery<?> dBQuery = this.from();
        String string = StringHelper.trimToNull((Object)accountFeeQuery.getName());
        if (string != null) {
            dBQuery.where((Predicate)((QAccountFee)this.$).name.containsIgnoreCase(string));
        }
        if ((currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)accountFeeQuery.getCurrency())) != null) {
            dBQuery.where((Predicate)((QAccountFee)this.$).accountType().currency().eq((Object)currency));
        }
        if ((userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountFeeQuery.getAccountType())) != null) {
            dBQuery.where((Predicate)((QAccountFee)this.$).accountType().eq((Object)userAccountType));
        }
        if (!accountFeeQuery.isReturnDisabled()) {
            dBQuery.where((Predicate)((QAccountFee)this.$).enabled.eq(Boolean.valueOf(true)));
        }
        dBQuery.orderBy(new OrderSpecifier[]{((QAccountFee)this.$).enabled.desc(), ((QAccountFee)this.$).name.asc()});
        return dBQuery.page(clazz, (QueryParameters)accountFeeQuery, (Expression)this.$);
    }

    @Override
    protected AccountFeeData getData(AccountFee accountFee) {
        AccountFeeData accountFeeData = new AccountFeeData();
        accountFeeData.setDto((EntityDTO)((AccountFeeDTO)this.toDTO(accountFee)));
        CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountFee.getCurrency());
        accountFeeData.setCurrency(currencyVO);
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setUnlimited();
        transferTypeQuery.setNatures(EnumSet.of(TransferTypeNature.GENERATED));
        transferTypeQuery.setCurrency(currencyVO);
        transferTypeQuery.setFromNature(AccountTypeNature.SYSTEM);
        transferTypeQuery.setToAccountTypes(CollectionHelper.asSet((Object[])new AccountTypeVO[]{new AccountTypeVO(accountFee.getAccountType().getId())}));
        accountFeeData.setToUserTransferTypes(this.transferTypeService.search(transferTypeQuery).getPageItems());
        TransferTypeQuery transferTypeQuery2 = new TransferTypeQuery();
        transferTypeQuery2.setUnlimited();
        transferTypeQuery2.setNatures(EnumSet.of(TransferTypeNature.GENERATED));
        transferTypeQuery2.setCurrency(currencyVO);
        transferTypeQuery2.setFromAccountTypes(CollectionHelper.asSet((Object[])new AccountTypeVO[]{new AccountTypeVO(accountFee.getAccountType().getId())}));
        transferTypeQuery.setToNature(AccountTypeNature.SYSTEM);
        accountFeeData.setToSystemTransferTypes(this.transferTypeService.search(transferTypeQuery2).getPageItems());
        accountFeeData.setCustomScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.ACCOUNT_FEE_CALCULATION)));
        return accountFeeData;
    }

    @Override
    protected Object onBeforeSave(AccountFee accountFee, AccountFee accountFee2) {
        if (accountFee.getPaymentDirection() == AccountFeePaymentDirection.TO_USER) {
            accountFee.setBalanceHandling(AccountFeeBalanceHandling.FAIL_WHEN_NO_LIMIT);
        }
        if (accountFee.isManual()) {
            accountFee.setRecurrence(null);
            accountFee.setDayMonth(null);
            accountFee.setDayWeek(null);
            accountFee.setHour(null);
        } else {
            TimeField timeField = accountFee.getRecurrence().getField();
            if (timeField != TimeField.WEEKS) {
                accountFee.setDayWeek(null);
            }
            if (timeField != TimeField.MONTHS) {
                accountFee.setDayMonth(null);
            }
        }
        if (accountFee.isEnabled() && accountFee.getEnabledSince() == null) {
            accountFee.setEnabledSince(DateHelper.now());
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAccountFee)this.$).accountType().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(AccountFeeDTO accountFeeDTO) {
        org.cyclos.impl.utils.validation.Property property;
        MessageKey messageKey;
        UserAccountType userAccountType;
        boolean bl = accountFeeDTO.getRunMode() == AccountFeeRunMode.SCHEDULED;
        boolean bl2 = accountFeeDTO.getRunMode() == AccountFeeRunMode.MANUAL;
        boolean bl3 = accountFeeDTO.getChargeMode() != null && accountFeeDTO.getChargeMode().isVolume();
        boolean bl4 = accountFeeDTO.getChargeMode() != null && accountFeeDTO.getChargeMode().isCustom();
        boolean bl5 = accountFeeDTO.getChargeMode() == AccountFeeChargeMode.FIXED;
        boolean bl6 = accountFeeDTO.getBalanceHandling() == AccountFeeBalanceHandling.RESERVE;
        Validator validator = new Validator();
        if (accountFeeDTO.isTransient()) {
            validator.property((Property)AccountFeeDTO.ACCOUNT_TYPE, BankingKeys.AccountFees.ACCOUNT_TYPE).required();
            userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountFeeDTO.getAccountType());
        } else {
            userAccountType = ((AccountFee)this.find(accountFeeDTO.getId())).getAccountType();
        }
        validator.property(AccountFeeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        validator.property((Property)AccountFeeDTO.CHARGE_MODE, BankingKeys.AccountFees.CHARGE_MODE).required();
        validator.property((Property)AccountFeeDTO.PAYMENT_DIRECTION, BankingKeys.AccountFees.PAYMENT_DIRECTION).required();
        validator.property((Property)AccountFeeDTO.BALANCE_HANDLING, BankingKeys.AccountFees.BALANCE_HANDLING).required();
        validator.property((Property)AccountFeeDTO.TRANSFER_TYPE, BankingKeys.AccountFees.TRANSFER_TYPE).required().entity(GeneratedTransferType.class, (EntityValidation)new BaseEntityValidation<GeneratedTransferType>(){

            protected boolean isValid(Object object, Object object2, GeneratedTransferType generatedTransferType) {
                AccountFeeDTO accountFeeDTO = (AccountFeeDTO)object;
                if (userAccountType == null) {
                    return true;
                }
                AccountFeePaymentDirection accountFeePaymentDirection = accountFeeDTO.getPaymentDirection();
                if (accountFeePaymentDirection == null) {
                    return true;
                }
                if (accountFeePaymentDirection == AccountFeePaymentDirection.TO_SYSTEM) {
                    return generatedTransferType.getFrom().equals((Object)userAccountType) && generatedTransferType.isToSystem();
                }
                return generatedTransferType.getTo().equals((Object)userAccountType) && generatedTransferType.isFromSystem();
            }
        });
        if (bl4) {
            validator.property((Property)AccountFeeDTO.CUSTOM_SCRIPT, BankingKeys.AccountFees.CUSTOM_SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.ACCOUNT_FEE_CALCULATION;
                }
            });
        } else {
            messageKey = bl5 ? BankingKeys.AccountFees.AMOUNT : BankingKeys.AccountFees.PERCENTAGE;
            property = validator.property((Property)AccountFeeDTO.AMOUNT, messageKey);
            property.required();
            if (bl5) {
                property.positiveNonZero((HasCurrency)userAccountType);
            } else {
                property.positiveNonZero(BigDecimalHelper.MAX_SCALE).between((Comparable)new Percentage(BigDecimal.ZERO), (Comparable)new Percentage(BigDecimal.ONE));
            }
        }
        validator.property((Property)AccountFeeDTO.RUN_MODE, BankingKeys.AccountFees.RUN_MODE).required();
        if (bl) {
            messageKey = validator.property((Property)AccountFeeDTO.RECURRENCE, BankingKeys.AccountFees.RECURRENCE);
            messageKey.required().positiveIntegerNonZero().timeInterval();
            property = accountFeeDTO.getRecurrence();
            if (property != null && property.getField() != null) {
                switch (property.getField()) {
                    case DAYS: {
                        break;
                    }
                    case WEEKS: {
                        validator.property((Property)AccountFeeDTO.DAY_WEEK, BankingKeys.AccountFees.DAY).required();
                        break;
                    }
                    case MONTHS: {
                        validator.property((Property)AccountFeeDTO.DAY_MONTH, BankingKeys.AccountFees.DAY).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(28));
                        break;
                    }
                    default: {
                        messageKey.invalid();
                    }
                }
            }
            validator.property((Property)AccountFeeDTO.HOUR, BankingKeys.AccountFees.HOUR).required().between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23));
        } else if (bl2 && bl3) {
            validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.AccountFees.ERROR_VOLUME_FEES_MUST_BE_SCHEDULED, (Object[])new Object[0]));
        }
        if (!bl3 && bl6) {
            validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.AccountFees.ERROR_ONLY_VOLUME_FEES_CAN_RESERVE_AMOUNT, (Object[])new Object[0]));
        }
        return validator;
    }
}

