/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.sql.SQLQuery;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.AccountFeeLogEvent;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.QAccountFee;
import org.cyclos.entities.banking.QAccountFeeLog;
import org.cyclos.entities.banking.QAccountFeeLogEvent;
import org.cyclos.entities.banking.QAccountFeeTransfer;
import org.cyclos.entities.banking.QUserAccountFeeLog;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountFeeLog;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.banking.AccountFeeServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.DispatchAccountFeeChargesBackgroundTask;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.sql.postgresql.querydsl.QuerydslConfiguration;
import org.cyclos.impl.sql.postgresql.querytypes.SProductsAccountFees;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.accountfees.AccountFeeChargeMode;
import org.cyclos.model.banking.accountfees.AccountFeeExecutionSearchData;
import org.cyclos.model.banking.accountfees.AccountFeeExecutionVO;
import org.cyclos.model.banking.accountfees.AccountFeeLogData;
import org.cyclos.model.banking.accountfees.AccountFeeLogEventType;
import org.cyclos.model.banking.accountfees.AccountFeeLogEventVO;
import org.cyclos.model.banking.accountfees.AccountFeeLogQuery;
import org.cyclos.model.banking.accountfees.AccountFeeLogStatus;
import org.cyclos.model.banking.accountfees.AccountFeeLogVO;
import org.cyclos.model.banking.accountfees.AccountFeeLogsSearchData;
import org.cyclos.model.banking.accountfees.AccountFeeQuery;
import org.cyclos.model.banking.accountfees.AccountFeeRunMode;
import org.cyclos.model.banking.accountfees.AccountFeeVO;
import org.cyclos.model.banking.accountfees.AccountFeeWithTypeVO;
import org.cyclos.model.banking.accountfees.UserAccountFeeStatus;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class AccountFeeLogServiceImpl
extends BaseServiceImpl
implements AccountFeeLogServiceLocal {
    private static final QAccountFeeLog $ = QAccountFeeLog.accountFeeLog;
    private static final QUserAccountFeeLog uafl = QUserAccountFeeLog.userAccountFeeLog;
    @Autowired
    private AccountFeeServiceLocal accountFeeService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;

    public long archiveAccountFee(long l) {
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        QUserAccountFeeLog qUserAccountFeeLog = QUserAccountFeeLog.userAccountFeeLog;
        long l2 = this.rawEntityManagerHandler.delete((EntityPath)qUserAccountFeeLog).where(new Predicate[]{qUserAccountFeeLog.accountFeeLog().eq((Object)accountFeeLog)}).execute();
        if (accountFeeLog.getTotalChargedAmount() == null) {
            accountFeeLog.setTotalChargedAmount(this.calculateTotalChargedAmount(accountFeeLog));
        }
        accountFeeLog.setArchived(true);
        return l2;
    }

    public BigDecimal calculateAmount(AccountFeeLog accountFeeLog, UserAccount userAccount) throws FrameworkException {
        AccountFee accountFee = accountFeeLog.getAccountFee();
        if (!accountFee.isEnabled()) {
            return BigDecimal.ZERO;
        }
        return this.calculateAmount(userAccount, accountFee, accountFeeLog.getAmount(), accountFeeLog.getFreeBase(), this.getPeriodFromLog(accountFeeLog), accountFeeLog.getDate(), null);
    }

    public BigDecimal calculateReservedAmount(AccountFee accountFee, UserAccount userAccount) {
        Object object;
        Date date = DateHelper.now();
        if (!accountFee.isEnabled() || userAccount.isTransient() || accountFee.getEnabledSince().after(date) || !accountFee.isScheduled() || !accountFee.getChargeMode().isVolume()) {
            return null;
        }
        UserAccountFeeLog userAccountFeeLog = this.lastCharge(accountFee, userAccount.getUser());
        DatePeriod datePeriod = null;
        TimeZone timeZone = this.configurationHandler.getAccessor(accountFee.getNetwork()).getTimeZone();
        if (userAccountFeeLog == null) {
            object = this.getLastExecution(accountFee);
            datePeriod = object == null ? DatePeriod.previousPeriod((ITimeInterval)accountFee.getRecurrence(), (TimeZone)timeZone, (Date)accountFee.getEnabledSince()) : this.getPeriodFromLog((AccountFeeLog)object);
        } else {
            object = userAccountFeeLog == null ? null : userAccountFeeLog.getAccountFeeLog();
            datePeriod = this.getPeriodFromLog((AccountFeeLog)object);
        }
        object = BigDecimal.ZERO;
        while (true) {
            Pair<Date, DatePeriod> pair = this.getNextExecutionDateAndPeriod(accountFee, datePeriod);
            Date date2 = (Date)pair.getFirst();
            DatePeriod datePeriod2 = DatePeriod.previousPeriod((ITimeInterval)accountFee.getRecurrence(), (TimeZone)timeZone, (Date)date2);
            if (datePeriod2.getBegin().after(date)) break;
            BigDecimal bigDecimal = this.calculateAmount(userAccount, accountFee, accountFee.getAmount(), accountFee.getFreeBase(), datePeriod2, date2, ((BigDecimal)object).negate());
            if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal)) {
                object = ((BigDecimal)object).add(bigDecimal);
            }
            datePeriod = (DatePeriod)pair.getSecond();
        }
        return object;
    }

    public void chargeBatch(List<Long> list) {
        CollectionHelper.orEmpty(list).forEach(this::charge);
    }

    public int countUsers(AccountFeeLog accountFeeLog, Set<UserAccountFeeStatus> set) {
        return ((DBQuery)this.from(new EntityPath[]{uafl}).where(new Predicate[]{uafl.accountFeeLog().eq((Object)accountFeeLog), CollectionHelper.isEmpty(set) ? AccountFeeLogServiceImpl.uafl.id.isNotNull() : AccountFeeLogServiceImpl.uafl.status.in(set)})).count(AccountFeeLogServiceImpl.uafl.id);
    }

    public AccountFeeLogData getData(Long l) throws FrameworkException {
        AccountFeeLogData accountFeeLogData = new AccountFeeLogData();
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        accountFeeLogData.setAccountFeeLog((AccountFeeLogVO)this.conversionHandler.convert(AccountFeeLogVO.class, (Object)accountFeeLog));
        accountFeeLogData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountFeeLog.getAccountFee().getAccountType().getCurrency()));
        accountFeeLogData.setEvents(this.conversionHandler.convertList(AccountFeeLogEventVO.class, (Iterable)accountFeeLog.getEvents()));
        if (!accountFeeLog.isArchived()) {
            HashMap<UserAccountFeeStatus, Integer> hashMap = new HashMap<UserAccountFeeStatus, Integer>();
            BigDecimal bigDecimal = this.processUsers(accountFeeLog, hashMap);
            accountFeeLogData.setTotalChargedAmount(bigDecimal);
            accountFeeLogData.setTotalUsers(Integer.valueOf(hashMap.values().stream().mapToInt(Integer::intValue).sum()));
            accountFeeLogData.setUsersByStatus(hashMap);
            boolean bl = (Integer)ObjectHelper.defaultValue((Object)((Integer)hashMap.get(UserAccountFeeStatus.FAILED)), (Object)0) > 0;
            boolean bl2 = accountFeeLog.getStatus() == AccountFeeLogStatus.FINISHED;
            accountFeeLogData.setCanRechargeFailed(bl2 && bl);
            if (accountFeeLog.getStatus().isExecuting()) {
                this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
            }
        } else {
            accountFeeLogData.setTotalChargedAmount(accountFeeLog.getTotalChargedAmount());
        }
        return accountFeeLogData;
    }

    public AccountFeeExecutionSearchData getFeeExecutionsSearchData() throws FrameworkException {
        AccountFeeExecutionSearchData accountFeeExecutionSearchData = new AccountFeeExecutionSearchData();
        accountFeeExecutionSearchData.setCurrencies(this.currencyService.list());
        accountFeeExecutionSearchData.setQuery((QueryParameters)new AccountFeeQuery());
        return accountFeeExecutionSearchData;
    }

    public AccountFeeLog getLastExecution(AccountFee accountFee) {
        return (AccountFeeLog)((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.accountFee().eq((Object)accountFee))).orderBy(AccountFeeLogServiceImpl.$.date.desc())).singleResult((Expression)$);
    }

    public Date getNextExecutionDate(AccountFee accountFee, AccountFeeLog accountFeeLog) {
        Pair<Date, DatePeriod> pair = this.getNextExecutionDateAndPeriod(accountFee, this.getPeriodFromLog(accountFeeLog));
        return pair == null ? null : (Date)pair.getFirst();
    }

    public AccountFeeLogsSearchData getSearchData(AccountFeeVO accountFeeVO) throws FrameworkException {
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeVO);
        AccountFeeLogsSearchData accountFeeLogsSearchData = new AccountFeeLogsSearchData();
        accountFeeLogsSearchData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountFee.getAccountType().getCurrency()));
        accountFeeLogsSearchData.setAccountFee((AccountFeeWithTypeVO)this.conversionHandler.convert(AccountFeeWithTypeVO.class, (Object)accountFee));
        accountFeeLogsSearchData.setAllowManualCharge(accountFee.isEnabled() && accountFee.isManual());
        Date date = this.getNextExecutionDate(accountFee, this.getLastExecution(accountFee));
        accountFeeLogsSearchData.setNextExecution(this.conversionHandler.toDateTime(date));
        SProductsAccountFees sProductsAccountFees = SProductsAccountFees.productsAccountFees;
        List list = (List)this.jdbcTemplate.execute(connection -> ((SQLQuery)((SQLQuery)new SQLQuery(connection, QuerydslConfiguration.get()).from((Expression)sProductsAccountFees)).select(sProductsAccountFees.productId).where((Predicate)sProductsAccountFees.accountFeeId.eq((Object)accountFee.getId()))).fetch());
        Set set = list.stream().map(l -> (ProductVO)this.conversionHandler.convert(ProductVO.class, (Object)this.rawEntityManagerHandler.find(Product.class, l))).collect(Collectors.toSet());
        accountFeeLogsSearchData.setProducts(set);
        AccountFeeLogQuery accountFeeLogQuery = (AccountFeeLogQuery)QueryHelper.newQuery(AccountFeeLogQuery.class);
        accountFeeLogQuery.setAccountFee((AccountFeeVO)accountFeeLogsSearchData.getAccountFee());
        accountFeeLogsSearchData.setQuery((QueryParameters)accountFeeLogQuery);
        return accountFeeLogsSearchData;
    }

    public CloseableIterator<Long> getUserAFLIdsToCharge(AccountFeeLog accountFeeLog) {
        return this.nextToChargeQuery(accountFeeLog).iterate((Expression)AccountFeeLogServiceImpl.uafl.id);
    }

    public long insertMissingScheduledExecutions() throws FrameworkException {
        MutableLong mutableLong = new MutableLong();
        QAccountFee qAccountFee = QAccountFee.accountFee;
        CloseableIterator closeableIterator = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qAccountFee}).where(new Predicate[]{qAccountFee.enabled.isTrue(), qAccountFee.runMode.eq((Object)AccountFeeRunMode.SCHEDULED)})).iterate((Expression)qAccountFee);
        this.processBatch(closeableIterator, (T accountFee) -> {
            while (this.insertNextExecution((AccountFee)accountFee) != null) {
                mutableLong.increment();
            }
        });
        return mutableLong.longValue();
    }

    public void markFinished(Long l) {
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        if (!accountFeeLog.getStatus().isExecuting()) {
            return;
        }
        boolean bl = accountFeeLog.getStatus() == AccountFeeLogStatus.RECHARGING_FAILED;
        accountFeeLog.setStatus(AccountFeeLogStatus.FINISHED);
        accountFeeLog.setTotalChargedAmount(this.calculateTotalChargedAmount(accountFeeLog));
        this.createEvent(accountFeeLog, bl ? AccountFeeLogEventType.RECHARGING_FAILED_FINISHED : AccountFeeLogEventType.FINISHED);
        boolean bl2 = this.hasFailedUsers(accountFeeLog);
        SystemAlertType systemAlertType = bl2 ? SystemAlertType.ACCOUNT_FEE_CHARGED_WITH_FAILURES : SystemAlertType.ACCOUNT_FEE_CHARGED_NO_FAILURES;
        AccountFee accountFee = accountFeeLog.getAccountFee();
        if (systemAlertType != SystemAlertType.ACCOUNT_FEE_CHARGED_NO_FAILURES || accountFee.isNotifyWhenSuccess()) {
            this.alertService.create(accountFee.getNetwork(), systemAlertType, new Object[]{accountFee.getAccountType().getName(), accountFee.getName()});
        }
    }

    public void rechargeFailed(Long l) throws FrameworkException {
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        if (accountFeeLog.getStatus() != AccountFeeLogStatus.FINISHED || !this.hasFailedUsers(accountFeeLog)) {
            throw new IllegalActionException();
        }
        accountFeeLog.setStatus(AccountFeeLogStatus.RECHARGING_FAILED);
        accountFeeLog.setRechargeAttempt(accountFeeLog.getRechargeAttempt() + 1);
        this.createEvent(accountFeeLog, AccountFeeLogEventType.RECHARGING_FAILED_STARTED);
        this.backgroundTaskHandler.schedule(DispatchAccountFeeChargesBackgroundTask.scheduling(accountFeeLog));
    }

    public UserAccount resolveAccount(AccountFeeLog accountFeeLog, User user) {
        UserAccountType userAccountType = this.accountFeeService.resolveUserAccountType(accountFeeLog.getAccountFee());
        return (UserAccount)this.accountService.load((InternalAccountOwner)user, (AccountType)userAccountType);
    }

    public Long runNow(AccountFeeVO accountFeeVO) throws FrameworkException {
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeVO);
        if (!accountFee.isEnabled() || !accountFee.isManual()) {
            throw new IllegalActionException();
        }
        AccountFeeLog accountFeeLog = this.getLastExecution(accountFee);
        if (accountFeeLog != null && accountFeeLog.getStatus() == AccountFeeLogStatus.RUNNING) {
            return accountFeeLog.getId();
        }
        AccountFeeLog accountFeeLog2 = this.insertNextExecution(accountFee);
        return accountFeeLog2.getId();
    }

    public Page<AccountFeeLogVO> search(AccountFeeLogQuery accountFeeLogQuery) throws FrameworkException {
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeLogQuery.getAccountFee());
        if (accountFee == null) {
            throw new ValidationException();
        }
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)accountFeeLogQuery.getPeriod());
        Page page = ((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.accountFee().eq((Object)accountFee), AccountFeeLogServiceImpl.$.date.period(datePeriod)})).orderBy(AccountFeeLogServiceImpl.$.date.desc())).page((QueryParameters)accountFeeLogQuery, (Expression)$);
        return PageImpl.transformed((Page)page, this::toVO);
    }

    public Page<AccountFeeExecutionVO> searchFeeExecutions(AccountFeeQuery accountFeeQuery) throws FrameworkException {
        Page page = this.accountFeeService.search(accountFeeQuery);
        return PageImpl.transformed((Page)page, accountFeeVO -> {
            Date date;
            AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, accountFeeVO);
            AccountFeeExecutionVO accountFeeExecutionVO = (AccountFeeExecutionVO)this.conversionHandler.convert(AccountFeeExecutionVO.class, (Object)accountFee);
            accountFeeExecutionVO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountFee.getAccountType().getCurrency()));
            AccountFeeLog accountFeeLog = this.getLastExecution(accountFee);
            Date date2 = date = accountFeeLog == null ? null : accountFeeLog.getDate();
            if (date != null) {
                accountFeeExecutionVO.setLastExecution(this.conversionHandler.toDateTime(date));
                accountFeeExecutionVO.setLastExecutionStatus(accountFeeLog.getStatus());
            } else {
                accountFeeExecutionVO.setLastExecutionStatus(AccountFeeLogStatus.NEVER_RAN);
            }
            if (accountFee.isScheduled()) {
                Date date3 = this.getNextExecutionDate(accountFee, accountFeeLog);
                accountFeeExecutionVO.setNextExecution(this.conversionHandler.toDateTime(date3));
            }
            return accountFeeExecutionVO;
        });
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        Function<QAccountFeeLog, QNetwork> function = qAccountFeeLog -> qAccountFeeLog.accountFee().accountType().currency().network();
        networkPathRegistry.register(function.apply(QAccountFeeLog.accountFeeLog));
        networkPathRegistry.register(function.apply(QAccountFeeLogEvent.accountFeeLogEvent.accountFeeLog()));
    }

    private BigDecimal calculateAmount(UserAccount userAccount, AccountFee accountFee, BigDecimal bigDecimal, BigDecimal bigDecimal2, DatePeriod datePeriod, Date date, BigDecimal bigDecimal3) {
        AccountFeeChargeMode accountFeeChargeMode = accountFee.getChargeMode();
        BigDecimal bigDecimal4 = null;
        if (accountFeeChargeMode.isFixed()) {
            BigDecimal bigDecimal5;
            boolean bl = true;
            if (bigDecimal2 != null && (bigDecimal5 = this.accountService.getBalance((Account)userAccount, date)).compareTo(bigDecimal2) <= 0) {
                bl = false;
            }
            if (bl) {
                bigDecimal4 = bigDecimal;
            }
        } else if (accountFeeChargeMode.isBalance()) {
            boolean bl = !accountFeeChargeMode.isNegative();
            BigDecimal bigDecimal6 = this.accountService.getBalance((Account)userAccount, date);
            boolean bl2 = true;
            if (bigDecimal2 != null) {
                bigDecimal6 = bl ? bigDecimal6.subtract(bigDecimal2) : bigDecimal6.add(bigDecimal2);
            }
            if (bl && bigDecimal6.compareTo(BigDecimal.ZERO) <= 0 || !bl && bigDecimal6.compareTo(BigDecimal.ZERO) >= 0) {
                bl2 = false;
            }
            if (bl2) {
                bigDecimal4 = bigDecimal.multiply(bigDecimal6.abs());
            }
        } else if (accountFeeChargeMode.isVolume()) {
            BigDecimal bigDecimal7 = this.accountService.getAverageBalance((Account)userAccount, bigDecimal3, datePeriod, accountFeeChargeMode.isPositive(), bigDecimal2);
            bigDecimal4 = bigDecimal.multiply(bigDecimal7);
        } else if (accountFeeChargeMode.isCustom()) {
            CustomScript customScript = accountFee.getCustomScript();
            String string = accountFee.getCustomScriptParameters();
            bigDecimal4 = (BigDecimal)this.customScriptService.newAccessor(customScript, string).bind("fee", (Object)accountFee).bind("account", (Object)userAccount).bind("executionDate", (Object)date).run(BigDecimal.class);
        }
        bigDecimal4 = BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal4);
        return BigDecimalHelper.round((BigDecimal)bigDecimal4, (int)userAccount.getCurrency().getPrecision());
    }

    private BigDecimal calculateTotalChargedAmount(AccountFeeLog accountFeeLog) {
        QAccountFeeTransfer qAccountFeeTransfer = QAccountFeeTransfer.accountFeeTransfer;
        BigDecimal bigDecimal = (BigDecimal)((DBQuery)this.from(new EntityPath[]{qAccountFeeTransfer}).where((Predicate)qAccountFeeTransfer.accountFeeLog().eq((Object)accountFeeLog))).singleResult((Expression)qAccountFeeTransfer.amount.sum());
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal), (int)accountFeeLog.getCurrency().getPrecision());
        return bigDecimal2;
    }

    private void charge(Long l) {
        MutableInt mutableInt = new MutableInt();
        MutableObject mutableObject = new MutableObject();
        try {
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                UserAccountFeeLog userAccountFeeLog = this.find(UserAccountFeeLog.class, l);
                if (userAccountFeeLog.getStatus().isFinished()) {
                    return null;
                }
                return this.invokerHandler.runAs(SessionDataFactory.system((Network)userAccountFeeLog.getNetwork()), () -> {
                    UserAccountFeeStatus userAccountFeeStatus;
                    AccountFeeLog accountFeeLog = userAccountFeeLog.getAccountFeeLog();
                    mutableInt.setValue(accountFeeLog.getRechargeAttempt());
                    mutableObject.setValue((Object)userAccountFeeLog.getAmount());
                    if (mutableObject.getValue() == null) {
                        userAccountFeeStatus = this.resolveAccount(accountFeeLog, userAccountFeeLog.getUser());
                        mutableObject.setValue((Object)BigDecimalHelper.zeroWhenNull((BigDecimal)this.calculateAmount(accountFeeLog, (UserAccount)userAccountFeeStatus)));
                        userAccountFeeLog.setAmount((BigDecimal)mutableObject.getValue());
                    }
                    userAccountFeeStatus = UserAccountFeeStatus.SKIPPED;
                    if (BigDecimalHelper.isPositive((BigDecimal)((BigDecimal)mutableObject.getValue()))) {
                        this.transferService.insertAccountFeeTransfer(userAccountFeeLog);
                        userAccountFeeStatus = UserAccountFeeStatus.CHARGED;
                    }
                    this.update((EntityPath<?>)uafl).set((Path)AccountFeeLogServiceImpl.uafl.status, (Object)userAccountFeeStatus).set((Path)AccountFeeLogServiceImpl.uafl.amount, (Object)((BigDecimal)mutableObject.getValue())).where(new Predicate[]{AccountFeeLogServiceImpl.uafl.id.eq((Object)userAccountFeeLog.getId())}).execute();
                    return null;
                });
            });
        }
        catch (Exception exception) {
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                UserAccountFeeLog userAccountFeeLog = this.find(UserAccountFeeLog.class, l);
                userAccountFeeLog.setStatus(UserAccountFeeStatus.FAILED);
                userAccountFeeLog.setAmount((BigDecimal)mutableObject.getValue());
                userAccountFeeLog.setErrorDetails(ExceptionUtils.getStackTrace((Throwable)exception));
                userAccountFeeLog.setRechargeAttempt(mutableInt.intValue());
                return null;
            });
        }
    }

    private AccountFeeLogEvent createEvent(AccountFeeLog accountFeeLog, AccountFeeLogEventType accountFeeLogEventType) {
        AccountFeeLogEvent accountFeeLogEvent = new AccountFeeLogEvent();
        accountFeeLogEvent.setAccountFeeLog(accountFeeLog);
        accountFeeLogEvent.setDate(new Date());
        accountFeeLogEvent.setType(accountFeeLogEventType);
        accountFeeLogEvent.setBy(this.getLoggedUser());
        this.persist((IEntity)accountFeeLogEvent);
        accountFeeLog.getEvents().add(0, accountFeeLogEvent);
        return accountFeeLogEvent;
    }

    private Pair<Date, DatePeriod> getNextExecutionDateAndPeriod(AccountFee accountFee, DatePeriod datePeriod) {
        Date date;
        if (!accountFee.isEnabled() || accountFee.isManual()) {
            return null;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(accountFee.getNetwork());
        TimeZone timeZone = configurationAccessor.getTimeZone();
        Date date2 = accountFee.getEnabledSince();
        TimeInterval timeInterval = accountFee.getRecurrence();
        Date date3 = datePeriod == null ? date2 : (date2.after(date = datePeriod.getEnd()) ? date2 : DateHelper.add((Date)date, (TimeField)TimeField.DAYS, (int)1));
        date = DatePeriod.periodIncluding((ITimeInterval)timeInterval, (TimeZone)timeZone, (Date)date3);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date.getEnd());
        calendar.add(5, 1);
        switch (timeInterval.getField()) {
            case WEEKS: {
                int n = accountFee.getDayWeek().ordinal() + 1;
                while (calendar.get(7) != n) {
                    calendar.add(5, 1);
                }
                break;
            }
            case MONTHS: {
                calendar.set(5, accountFee.getDayMonth());
                break;
            }
        }
        calendar.set(11, accountFee.getHour());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date4 = calendar.getTime();
        return Pair.create((Object)date4, (Object)date);
    }

    private DatePeriod getPeriodFromLog(AccountFeeLog accountFeeLog) {
        if (accountFeeLog == null) {
            return null;
        }
        if (accountFeeLog.getPeriod() != null) {
            return accountFeeLog.getPeriod();
        }
        TimeInterval timeInterval = accountFeeLog.getAccountFee().getRecurrence();
        if (timeInterval == null) {
            return null;
        }
        return DatePeriod.previousPeriod((ITimeInterval)timeInterval, (TimeZone)this.configurationHandler.getAccessor(accountFeeLog.getNetwork()).getTimeZone(), (Date)accountFeeLog.getDate());
    }

    private boolean hasFailedUsers(AccountFeeLog accountFeeLog) {
        QUserAccountFeeLog qUserAccountFeeLog = QUserAccountFeeLog.userAccountFeeLog;
        return ((DBQuery)this.from(new EntityPath[]{qUserAccountFeeLog}).where(new Predicate[]{qUserAccountFeeLog.accountFeeLog().eq((Object)accountFeeLog), qUserAccountFeeLog.status.eq((Object)UserAccountFeeStatus.FAILED)})).hasResults();
    }

    private AccountFeeLog insertNextExecution(AccountFee accountFee) {
        boolean bl;
        AccountFeeLog accountFeeLog;
        Date date;
        if (!accountFee.isEnabled() || accountFee.getNetwork() != null && !accountFee.getNetwork().isEnabled()) {
            return null;
        }
        Date date2 = date = new Date();
        DatePeriod datePeriod = null;
        if (accountFee.isScheduled()) {
            AccountFeeLog accountFeeLog2 = this.getLastExecution(accountFee);
            accountFeeLog = this.getNextExecutionDateAndPeriod(accountFee, this.getPeriodFromLog(accountFeeLog2));
            date2 = (Date)accountFeeLog.getFirst();
            if (date2.after(date)) {
                return null;
            }
            DatePeriod datePeriod2 = datePeriod = !accountFee.getChargeMode().isVolume() ? null : (DatePeriod)accountFeeLog.getSecond();
        }
        if (bl = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.accountFee().eq((Object)accountFee), AccountFeeLogServiceImpl.$.date.eq((Object)date2)})).hasResults()) {
            return null;
        }
        accountFeeLog = new AccountFeeLog();
        accountFeeLog.setStatus(AccountFeeLogStatus.PREPARING);
        accountFeeLog.setAccountFee(accountFee);
        accountFeeLog.setDate(date2);
        accountFeeLog.setPeriod(datePeriod);
        accountFeeLog.setAmount(accountFee.getAmount());
        accountFeeLog.setFreeBase(accountFee.getFreeBase());
        this.persist((IEntity)accountFeeLog);
        this.createEvent(accountFeeLog, AccountFeeLogEventType.STARTED);
        this.backgroundTaskHandler.schedule(DispatchAccountFeeChargesBackgroundTask.scheduling(accountFeeLog));
        return accountFeeLog;
    }

    private UserAccountFeeLog lastCharge(AccountFee accountFee, User user) {
        QUserAccountFeeLog qUserAccountFeeLog = QUserAccountFeeLog.userAccountFeeLog;
        return (UserAccountFeeLog)((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserAccountFeeLog}).where(new Predicate[]{qUserAccountFeeLog.accountFeeLog().accountFee().eq((Object)accountFee), qUserAccountFeeLog.user().eq((Object)user), qUserAccountFeeLog.status.ne((Object)UserAccountFeeStatus.PENDING)})).orderBy(qUserAccountFeeLog.accountFeeLog().date.desc())).singleResult((Expression)qUserAccountFeeLog);
    }

    private DBQuery<?> nextToChargeQuery(AccountFeeLog accountFeeLog) {
        UserAccountFeeStatus userAccountFeeStatus = accountFeeLog.getStatus() == AccountFeeLogStatus.RECHARGING_FAILED ? UserAccountFeeStatus.FAILED : UserAccountFeeStatus.PENDING;
        DBQuery dBQuery = (DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{uafl}).where(new Predicate[]{AccountFeeLogServiceImpl.uafl.status.eq((Object)userAccountFeeStatus), uafl.accountFeeLog().eq((Object)accountFeeLog)});
        if (userAccountFeeStatus == UserAccountFeeStatus.FAILED) {
            dBQuery.where((Predicate)AccountFeeLogServiceImpl.uafl.rechargeAttempt.lt((Expression)AccountFeeLogServiceImpl.uafl.accountFeeLog().rechargeAttempt));
        }
        return (DBQuery)dBQuery.limit(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private BigDecimal processUsers(AccountFeeLog accountFeeLog, Map<UserAccountFeeStatus, Integer> map) {
        void var8_10;
        QUserAccountFeeLog qUserAccountFeeLog = QUserAccountFeeLog.userAccountFeeLog;
        EnumPath enumPath = qUserAccountFeeLog.status;
        NumberExpression numberExpression = qUserAccountFeeLog.id.count();
        NumberExpression numberExpression2 = qUserAccountFeeLog.amount.sum();
        List list = ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qUserAccountFeeLog}).leftJoin((EntityPath)$)).on((Predicate)qUserAccountFeeLog.accountFeeLog().eq((Expression)$))).where((Predicate)$.eq((Object)accountFeeLog))).groupBy((Expression)enumPath)).list(new Expression[]{enumPath, numberExpression, numberExpression2});
        for (UserAccountFeeStatus userAccountFeeStatus : UserAccountFeeStatus.values()) {
            map.put(userAccountFeeStatus, 0);
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (Tuple tuple : list) {
            UserAccountFeeStatus userAccountFeeStatus;
            userAccountFeeStatus = (UserAccountFeeStatus)tuple.get((Expression)enumPath);
            Long l = (Long)tuple.get((Expression)numberExpression);
            map.put(userAccountFeeStatus, l.intValue());
            if (userAccountFeeStatus != UserAccountFeeStatus.CHARGED) continue;
            BigDecimal bigDecimal2 = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple.get((Expression)numberExpression2)));
        }
        return var8_10;
    }

    private AccountFeeLogVO toVO(AccountFeeLog accountFeeLog) {
        AccountFeeLogVO accountFeeLogVO = (AccountFeeLogVO)this.conversionHandler.convert(AccountFeeLogVO.class, (Object)accountFeeLog);
        accountFeeLogVO.setHasFailedUsers(this.hasFailedUsers(accountFeeLog));
        return accountFeeLogVO;
    }
}

