/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.AccountFee;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accountfees.AccountFeeChargeMode;
import org.cyclos.model.banking.accountfees.AccountFeeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.utils.BigDecimalHelper;
import org.springframework.stereotype.Component;

@Component
public class AccountFeeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<AccountFee, AccountFeeDTO> {
    public Class<AccountFee> getEntityClass() {
        return AccountFee.class;
    }

    public EntityLogType getType() {
        return EntityLogType.ACCOUNT_FEE;
    }

    public EntityLogDescriptor<? extends AccountFeeDTO> resolveLogDescriptor(AccountFee accountFee) {
        return new EntityLogDescriptor(AccountFeeDTO.class).property(AccountFeeDTO.NAME, GeneralKeys.Ui.NAME).property(AccountFeeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(AccountFeeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)AccountFeeDTO.ENABLED, BankingKeys.AccountFees.ENABLED).property((Property)AccountFeeDTO.NOTIFY_WHEN_SUCCESS, BankingKeys.AccountFees.NOTIFY_WHEN_SUCCESS).property((Property)AccountFeeDTO.BALANCE_HANDLING, BankingKeys.AccountFees.BALANCE_HANDLING).property((Property)AccountFeeDTO.PAYMENT_DIRECTION, BankingKeys.AccountFees.PAYMENT_DIRECTION).property((Property)AccountFeeDTO.TRANSFER_TYPE, BankingKeys.AccountFees.TRANSFER_TYPE).property(this.toAmountAccess((Property<?, AccountFeeDTO>)AccountFeeDTO.AMOUNT), accountFee.getChargeMode().isFixed() ? BankingKeys.AccountFees.AMOUNT : BankingKeys.AccountFees.PERCENTAGE).property(this.toFreeBaseAccess((Property<?, AccountFeeDTO>)AccountFeeDTO.FREE_BASE), BankingKeys.AccountFees.FREE_BASE).property((Property)AccountFeeDTO.CUSTOM_SCRIPT, BankingKeys.AccountFees.CUSTOM_SCRIPT).property((Property)AccountFeeDTO.CUSTOM_SCRIPT_PARAMETERS, BankingKeys.AccountFees.CUSTOM_SCRIPT_PARAMETERS).property((Property)AccountFeeDTO.DAY_MONTH, BankingKeys.AccountFees.DAY).property((Property)AccountFeeDTO.DAY_WEEK, BankingKeys.AccountFees.DAY).property((Property)AccountFeeDTO.HOUR, BankingKeys.AccountFees.HOUR).property((Property)AccountFeeDTO.ENABLED_SINCE, BankingKeys.AccountFees.ENABLED_SINCE).property((Property)AccountFeeDTO.RECURRENCE, BankingKeys.AccountFees.RECURRENCE).property((Property)AccountFeeDTO.RUN_MODE, BankingKeys.AccountFees.RUN_MODE).property((Property)AccountFeeDTO.CHARGE_MODE, BankingKeys.AccountFees.CHARGE_MODE).ignore((Property)AccountFeeDTO.ACCOUNT_TYPE);
    }

    @Override
    protected AccountFee getEntityToViewLog(long l) {
        return this.hasPermission(Permission.ACCOUNT_CONFIGURATION_VIEW) ? this.find(AccountFee.class, l) : null;
    }

    private PropertyAccess toAmountAccess(Property<?, AccountFeeDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                AccountFee accountFee = (AccountFee)object;
                if (accountFee.getAmount() == null) {
                    return null;
                }
                AccountFeeChargeMode accountFeeChargeMode = accountFee.getChargeMode();
                if (accountFeeChargeMode.isBalance() || accountFeeChargeMode.isVolume()) {
                    return AccountFeeEntityLogHandlerImpl.this.getFormatter().format(accountFee.getAmount(), BigDecimalHelper.MAX_SCALE);
                }
                if (accountFeeChargeMode.isFixed()) {
                    return AccountFeeEntityLogHandlerImpl.this.getFormatter().format(accountFee.getAmount(), accountFee.getCurrency().getPrecision());
                }
                return super.get(object);
            }
        };
    }

    private PropertyAccess toFreeBaseAccess(Property<?, AccountFeeDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                AccountFee accountFee = (AccountFee)object;
                if (accountFee.getFreeBase() == null) {
                    return null;
                }
                return AccountFeeEntityLogHandlerImpl.this.getFormatter().format(accountFee.getFreeBase(), accountFee.getCurrency().getPrecision());
            }
        };
    }
}

