/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.banking.accounts.AccountBalanceLimitVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.utils.BigDecimalHelper;
import org.springframework.stereotype.Component;

@Component
public class AccountBalanceLimitVOConverter
extends ObjectConverter<AccountBalanceLimitVO> {
    public AccountBalanceLimitVOConverter() {
        super(AccountBalanceLimitVO.class);
    }

    @Override
    protected void fill(Object object, AccountBalanceLimitVO accountBalanceLimitVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, accountBalanceLimitVO, objectArray, conversionContext);
        if (object instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)object;
            accountBalanceLimitVO.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, userAccount));
            accountBalanceLimitVO.setCreditLimit(BigDecimalHelper.negative((BigDecimal)userAccount.getCreditLimit()));
            accountBalanceLimitVO.setCreditLimitFromProduct(userAccount.isCreditLimitFromProduct());
            accountBalanceLimitVO.setUpperCreditLimit(userAccount.getUpperCreditLimit());
            accountBalanceLimitVO.setUpperCreditLimitFromProduct(userAccount.isUpperCreditLimitFromProduct());
        }
    }
}

