/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.QUserIdentityProvider;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.UserIdentityProviderServiceLocal;
import org.cyclos.impl.users.IdentityProviderProfile;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderListData;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderStatus;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIdentityProviderServiceImpl
extends BaseServiceImpl
implements UserIdentityProviderServiceLocal {
    private static final QUserIdentityProvider $ = QUserIdentityProvider.userIdentityProvider;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public void disable(UserLocatorVO userLocatorVO, IdentityProviderVO identityProviderVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        IdentityProvider identityProvider = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)identityProviderVO);
        if (basicUser == null || identityProvider == null) {
            throw new ValidationException();
        }
        UserIdentityProvider userIdentityProvider = this.get(basicUser, identityProvider);
        if (userIdentityProvider == null) {
            userIdentityProvider = new UserIdentityProvider();
            userIdentityProvider.setStatus(UserIdentityProviderStatus.DISABLED);
            userIdentityProvider.setIdentityProvider(identityProvider);
            userIdentityProvider.setBasicUser(basicUser);
            this.persist((IEntity)userIdentityProvider);
        } else {
            this.clear(userIdentityProvider, UserIdentityProviderStatus.DISABLED);
        }
    }

    public UserIdentityProvider get(BasicUser basicUser, IdentityProvider identityProvider) {
        if (basicUser == null || identityProvider == null) {
            return null;
        }
        return (UserIdentityProvider)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{$.basicUser().eq((Object)basicUser), $.identityProvider().eq((Object)identityProvider)})).singleResult((Expression)$);
    }

    public UserIdentityProvider get(IdentityProvider identityProvider, String string) {
        if (identityProvider == null || string == null) {
            return null;
        }
        return (UserIdentityProvider)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.identityProvider().eq((Object)identityProvider), UserIdentityProviderServiceImpl.$.identifier.eq((Object)string)})).singleResult((Expression)$);
    }

    public UserIdentityProviderListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        List list = this.identityProviderService.listEnabled(basicUser);
        UserIdentityProviderListData userIdentityProviderListData = new UserIdentityProviderListData();
        userIdentityProviderListData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        userIdentityProviderListData.setIdentityProviders(list.stream().map(identityProvider -> {
            UserIdentityProvider userIdentityProvider = this.get(basicUser, (IdentityProvider)identityProvider);
            if (userIdentityProvider == null) {
                userIdentityProvider = new UserIdentityProvider();
                userIdentityProvider.setStatus(UserIdentityProviderStatus.NOT_LINKED);
                userIdentityProvider.setIdentityProvider(identityProvider);
            }
            return userIdentityProvider;
        }).filter(Objects::nonNull).map(this.conversionHandler.convertingFunction(UserIdentityProviderVO.class, new Object[0])).collect(Collectors.toList()));
        return userIdentityProviderListData;
    }

    public UserIdentityProvider link(IdentityProvider identityProvider, UserPrincipal userPrincipal, IdentityProviderProfile identityProviderProfile, boolean bl) {
        BasicUser basicUser = userPrincipal.getBasicUser();
        String string = identityProviderProfile.getId();
        UserIdentityProvider userIdentityProvider2 = this.get(identityProvider, string);
        if (userIdentityProvider2 != null && !userIdentityProvider2.getBasicUser().equals((Object)basicUser)) {
            throw new ValidationException(this.message(AccessKeys.UserIdentityProviders.ERROR_LINK_OTHER_USER, identityProvider.getName(), identityProviderProfile.getName(), userIdentityProvider2.getBasicUser()));
        }
        userIdentityProvider2 = this.get(basicUser, identityProvider);
        Consumer<UserIdentityProvider> consumer = userIdentityProvider -> {
            userIdentityProvider.setName(identityProviderProfile.getName());
            userIdentityProvider.setEmail(identityProviderProfile.getEmail());
            userIdentityProvider.setStatus(UserIdentityProviderStatus.LINKED);
            userIdentityProvider.setLinkDate(new Date());
            userIdentityProvider.setLinkRemoteAddress(this.getSessionData().getRemoteAddress());
            userIdentityProvider.initFrom(userPrincipal);
            userIdentityProvider.setIdentifier(string);
        };
        if (userIdentityProvider2 == null) {
            userIdentityProvider2 = new UserIdentityProvider();
            userIdentityProvider2.setIdentityProvider(identityProvider);
            consumer.accept(userIdentityProvider2);
            userIdentityProvider2.setNetwork(basicUser.getNetwork());
            this.rawEntityManagerHandler.persist((IEntity)userIdentityProvider2);
        } else if (userIdentityProvider2.getStatus() != UserIdentityProviderStatus.DISABLED || bl) {
            consumer.accept(userIdentityProvider2);
        }
        return userIdentityProvider2;
    }

    public List<UserIdentityProvider> list(BasicUser basicUser) {
        List list = this.identityProviderService.listEnabled(basicUser);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyList();
        }
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{$.basicUser().eq((Object)basicUser), $.identityProvider().in((Collection)list)})).list((Expression)$);
    }

    public void removeAll(BasicUser basicUser) {
        this.delete((EntityPath<?>)$).where(new Predicate[]{$.basicUser().eq((Object)basicUser)}).execute();
    }

    public void unlink(UserLocatorVO userLocatorVO, IdentityProviderVO identityProviderVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        IdentityProvider identityProvider = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)identityProviderVO);
        if (basicUser == null || identityProvider == null) {
            throw new ValidationException();
        }
        UserIdentityProvider userIdentityProvider = this.get(basicUser, identityProvider);
        if (userIdentityProvider != null) {
            this.clear(userIdentityProvider, UserIdentityProviderStatus.NOT_LINKED);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.network());
    }

    private void clear(UserIdentityProvider userIdentityProvider, UserIdentityProviderStatus userIdentityProviderStatus) {
        BasicUser basicUser = userIdentityProvider.getBasicUser();
        userIdentityProvider.setStatus(userIdentityProviderStatus);
        userIdentityProvider.initFrom(null);
        userIdentityProvider.setLinkDate(null);
        userIdentityProvider.setIdentifier(null);
        userIdentityProvider.setName(null);
        userIdentityProvider.setEmail(null);
        userIdentityProvider.setBasicUser(basicUser);
    }
}

