/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserChannel;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.userchannels.UserChannelData;
import org.cyclos.model.access.userchannels.UserChannelsData;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserChannelServiceImpl
extends BaseServiceImpl
implements UserChannelServiceLocal {
    @Autowired
    private ChannelServiceLocal channelService;

    public boolean enableChannel(User user, Channel channel) throws FrameworkException {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        List list = configurationAccessor.getChannels();
        if (!list.contains(channel)) {
            return false;
        }
        UserChannel userChannel = user.getChannel(channel);
        if (userChannel == null) {
            userChannel = new UserChannel();
            userChannel.setUser(user);
            userChannel.setChannel(channel);
            userChannel.setEnabled(true);
            this.persist((IEntity)userChannel);
            user.getChannels().add(userChannel);
        } else {
            userChannel.setEnabled(true);
        }
        return true;
    }

    public List<Channel> getAccessibleChannels(BasicUser basicUser) throws FrameworkException {
        List list = this.channelService.listAll();
        CollectionUtils.filter((Iterable)list, channel -> this.isChannelAccessible(basicUser, (Channel)channel));
        return list;
    }

    public UserChannelsData getChannelsData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        List list = configurationAccessor.getChannels();
        ArrayList<UserChannelData> arrayList = new ArrayList<UserChannelData>(list.size());
        for (Channel channel : list) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            if (channelConfiguration == null || !channelConfiguration.isEnabled()) continue;
            UserChannelAccess userChannelAccess = channelConfiguration.getUserAccess();
            if (userChannelAccess == null) {
                userChannelAccess = UserChannelAccess.DEFAULT_DISABLED;
            }
            UserChannelData userChannelData = new UserChannelData();
            userChannelData.setChannel((ChannelVO)this.conversionHandler.convert(ChannelVO.class, (Object)channel));
            userChannelData.setAccess(userChannelAccess);
            userChannelData.setEnabled(this.isChannelAccessible((BasicUser)user, channel));
            arrayList.add(userChannelData);
        }
        UserChannelsData userChannelsData = new UserChannelsData();
        userChannelsData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userChannelsData.setChannels(arrayList);
        return userChannelsData;
    }

    public boolean isChannelAccessible(BasicUser basicUser, Channel channel) throws FrameworkException {
        boolean bl;
        if (basicUser.isGlobal() && this.getSessionData().getNetwork() != null) {
            return true;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
        boolean bl2 = bl = channelConfiguration != null && channelConfiguration.isEnabled();
        if (!bl) {
            return false;
        }
        UserChannelAccess userChannelAccess = (UserChannelAccess)ObjectHelper.defaultValue((Object)channelConfiguration.getUserAccess(), (Object)UserChannelAccess.DEFAULT_DISABLED);
        if (userChannelAccess == UserChannelAccess.ENFORCED_ENABLED) {
            return true;
        }
        UserChannel userChannel = basicUser.getUser().getChannel(channel);
        if (userChannel == null) {
            return userChannelAccess == UserChannelAccess.DEFAULT_ENABLED;
        }
        return userChannel.isEnabled();
    }

    public void saveChannels(UserLocatorVO userLocatorVO, Set<ChannelVO> set) throws FrameworkException {
        Set set2 = this.conversionHandler.convertSet(Channel.class, set);
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        List list = configurationAccessor.getChannels();
        Set set3 = user.getChannels();
        set3.removeIf(userChannel -> {
            Channel channel = userChannel.getChannel();
            if (!list.contains(channel)) {
                this.entityManagerHandler.remove((IEntity)userChannel, false);
                return true;
            }
            return false;
        });
        for (Channel channel : list) {
            UserChannelAccess userChannelAccess;
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            UserChannelAccess userChannelAccess2 = userChannelAccess = channelConfiguration == null ? null : channelConfiguration.getUserAccess();
            if (userChannelAccess == null) {
                userChannelAccess = UserChannelAccess.DEFAULT_DISABLED;
            }
            boolean bl = channelConfiguration == null || !channelConfiguration.isEnabled() ? false : (userChannelAccess == UserChannelAccess.ENFORCED_ENABLED ? true : set2 != null && set2.contains(channel));
            UserChannel userChannel2 = set3.stream().filter(userChannel -> userChannel.getChannel().equals((Object)channel)).findFirst().orElse(null);
            if (userChannel2 == null) {
                userChannel2 = new UserChannel();
                userChannel2.setUser(user);
                userChannel2.setChannel(channel);
                user.getChannels().add(userChannel2);
            }
            userChannel2.setEnabled(bl);
            if (!userChannel2.isTransient()) continue;
            this.entityManagerHandler.persist((IEntity)userChannel2, false);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

