/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import org.cyclos.entities.users.QAccessLog;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeLoginLogsRecurringTask
extends SimpleRecurringTask {
    private static final QAccessLog $ = QAccessLog.accessLog;
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_LOGIN_LOGS;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        int n = this.cyclosProperties.getPurgeLoginLogsDays();
        if (n < 1) {
            return 0L;
        }
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.DAYS, (int)n);
        return this.rawEntityManagerHandler.delete((EntityPath)$).where(new Predicate[]{PurgeLoginLogsRecurringTask.$.date.before((Comparable)date)}).execute();
    }
}

