/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.PasswordLog;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.QPassword;
import org.cyclos.entities.access.QPasswordLog;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.UpdatePasswordStatusListener;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QProductPasswordAction;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.CaptchaServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.PasswordHelper;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.validation.BasePropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidSecurityAnswerException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.SecurityQuestion;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordDTO;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordData;
import org.cyclos.model.access.passwords.ChangeGeneratedPasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordData;
import org.cyclos.model.access.passwords.ForgotPasswordRequestDTO;
import org.cyclos.model.access.passwords.GenerateNewPasswordConfirmationField;
import org.cyclos.model.access.passwords.GetChangeForgottenPasswordDataParams;
import org.cyclos.model.access.passwords.IForgotPasswordParams;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordActionDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.PasswordLogVO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwords.SecurityQuestionVO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionData;
import org.cyclos.model.access.passwords.UserPasswordsData;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.totps.TotpSecretData;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordServiceImpl
extends BaseServiceImpl
implements PasswordServiceLocal {
    private static final QProductPasswordAction ppa = QProductPasswordAction.productPasswordAction;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CaptchaServiceLocal captchaService;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private OtpHandler otpHandler;
    @Autowired
    private TotpServiceLocal totpService;

    public String activate(PasswordTypeVO passwordTypeVO) throws FrameworkException, IllegalActionException {
        boolean bl;
        BasicUser basicUser = this.getLoggedBasicUser();
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordTypeVO);
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.ACTIVATE);
        Pair<Password, PasswordStatus> pair = this.getPasswordAndStatus(basicUser, passwordType);
        PasswordStatus passwordStatus = (PasswordStatus)pair.getSecond();
        boolean bl2 = passwordType.getPasswordMode() == PasswordMode.GENERATED && (passwordStatus == PasswordStatus.EXPIRED || passwordStatus == PasswordStatus.RESET);
        boolean bl3 = passwordType.isRequiresAdminAuthorization();
        boolean bl4 = bl = bl3 && passwordStatus == PasswordStatus.PENDING;
        if (!bl2 && !bl && bl3) {
            throw new IllegalActionException();
        }
        Password password = (Password)pair.getFirst();
        String string = this.generatePassword(passwordType);
        if (password == null) {
            password = (Password)this.create(basicUser, passwordType, string, PasswordStatus.ACTIVE).getSecond();
        } else {
            String string2 = this.passwordHandler.encode(basicUser, passwordType, string);
            password.setValue(string2);
            password.setStatus(PasswordStatus.ACTIVE);
            password.setDate(DateHelper.now());
            this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, PasswordStatus.ACTIVE);
        }
        this.validateLoginConfirmation(passwordType);
        this.createLog(password.getUser(), password.getType(), PasswordAction.ACTIVATE);
        return string;
    }

    public void addValidations(org.cyclos.impl.utils.validation.Property property, final BasicUser basicUser, String string, final PasswordType passwordType, boolean bl) {
        if (passwordType.getPasswordMode() != PasswordMode.MANUAL) {
            return;
        }
        property.length((IIntegerRange)passwordType.getLength());
        property.add((PropertyValidation)new PasswordObviousValidation(basicUser, passwordType));
        final StringBuilder stringBuilder = new StringBuilder();
        if (passwordType.getInputMethod() == PasswordInputMethod.TEXT_BOX) {
            MessageKey messageKey = passwordType.getLowerCaseLetters() == Availability.REQUIRED ? GeneralKeys.Errors.LOWER_CASE_LETTERS_REQUIRED : GeneralKeys.Errors.LOWER_CASE_LETTERS_NOT_ALLOWED;
            MessageKey messageKey2 = passwordType.getUpperCaseLetters() == Availability.REQUIRED ? GeneralKeys.Errors.UPPER_CASE_LETTERS_REQUIRED : GeneralKeys.Errors.UPPER_CASE_LETTERS_NOT_ALLOWED;
            MessageKey messageKey3 = passwordType.getNumbers() == Availability.REQUIRED ? GeneralKeys.Errors.NUMBERS_REQUIRED : GeneralKeys.Errors.NUMBERS_NOT_ALLOWED;
            MessageKey messageKey4 = passwordType.getSpecialCharacters() == Availability.REQUIRED ? GeneralKeys.Errors.SPECIAL_CHARACTERS_REQUIRED : GeneralKeys.Errors.SPECIAL_CHARACTERS_NOT_ALLOWED;
            property.add((PropertyValidation)new CharsetValidation(passwordType.getLowerCaseLetters(), StringHelper.LOWERCASE_LETTERS, messageKey));
            property.add((PropertyValidation)new CharsetValidation(passwordType.getUpperCaseLetters(), "ABCDEFGHIJKLMNOPQRSTUVWXYZ", messageKey2));
            property.add((PropertyValidation)new CharsetValidation(passwordType.getNumbers(), "0123456789", messageKey3));
            property.add((PropertyValidation)new CharsetValidation(passwordType.getSpecialCharacters(), "`@!\"#$%&'()*+,-./:;<=>?[\\]^_{}~", messageKey4));
            if (passwordType.getLowerCaseLetters() != Availability.DISABLED) {
                stringBuilder.append(StringHelper.LOWERCASE_LETTERS);
            }
            if (passwordType.getUpperCaseLetters() != Availability.DISABLED) {
                stringBuilder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            }
            if (passwordType.getNumbers() != Availability.DISABLED) {
                stringBuilder.append("0123456789");
            }
            if (passwordType.getSpecialCharacters() != Availability.DISABLED) {
                stringBuilder.append("`@!\"#$%&'()*+,-./:;<=>?[\\]^_{}~");
            }
        } else if (passwordType.getInputMethod() == PasswordInputMethod.VIRTUAL_KEYBOARD) {
            stringBuilder.append(passwordType.getPossibleCharacters());
        }
        property.add((PropertyValidation)new BasePropertyValidation(new ValidationError(AccessKeys.Passwords.ERROR_CUSTOM_CHARACTERS, new Object[]{stringBuilder})){

            protected boolean isValid(Object object, Object object2, Object object3) {
                return StringUtils.containsOnly((CharSequence)object3.toString(), (String)stringBuilder.toString());
            }
        });
        if (!bl && passwordType.isAvoidRepeatedValue()) {
            property.add((PropertyValidation)new BasePropertyValidation(new ValidationError(AccessKeys.Passwords.ERROR_USED_IN_PAST)){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    return !PasswordServiceImpl.this.existsInHistory(basicUser, object3.toString(), passwordType);
                }
            });
        }
    }

    public void allowActivation(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        Pair<BasicUser, PasswordType> pair = this.load(passwordActionDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.ALLOW_ACTIVATION);
        this.setStatus(basicUser, passwordType, PasswordStatus.PENDING);
        this.createLog(basicUser, passwordType, PasswordAction.ALLOW_ACTIVATION);
    }

    public void blockByTries(Password password) {
        BasicUser basicUser = password.getUser();
        PasswordType passwordType = password.getType();
        String string = this.getTranslatedName((NamedEntity)passwordType);
        switch (passwordType.getInvalidAction()) {
            case TEMPORARILY_BLOCK: {
                TimeField timeField;
                int n;
                TimeInterval timeInterval = passwordType.getBlockTime();
                try {
                    n = timeInterval.getAmount();
                    timeField = timeInterval.getField();
                }
                catch (Exception exception) {
                    n = 0;
                    timeField = null;
                }
                if (n <= 0) break;
                Date date = DateHelper.add((Date)DateHelper.now(), (TimeField)timeField, (int)n);
                password.setBlockedUntil(date);
                if (basicUser instanceof User) {
                    this.alertService.create((User)basicUser, UserAlertType.PASSWORD_TEMPORARILY_BLOCKED, new Object[]{string, passwordType.getInvalidAttempts(), this.getSessionData().getRemoteAddress()});
                }
                this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, PasswordStatus.TEMPORARILY_BLOCKED);
                break;
            }
            case INDEFINITELY_BLOCK: {
                password.setStatus(PasswordStatus.INDEFINITELY_BLOCKED);
                if (basicUser instanceof User) {
                    this.alertService.create((User)basicUser, UserAlertType.PASSWORD_DISABLED_BY_TRIES, new Object[]{string, passwordType.getInvalidAttempts(), this.getSessionData().getRemoteAddress()});
                }
                this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, PasswordStatus.INDEFINITELY_BLOCKED);
            }
        }
    }

    public void change(ChangePasswordDTO changePasswordDTO) {
        this.validate(changePasswordDTO);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changePasswordDTO.getUser());
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)changePasswordDTO.getType());
        if (passwordType.getPasswordMode() != PasswordMode.MANUAL) {
            throw new IllegalActionException();
        }
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.CHANGE);
        if (this.shouldCheckOldPassword(basicUser, passwordType, null)) {
            this.passwordHandler.checkPassword(passwordType, basicUser, true, changePasswordDTO.getOldPassword());
        }
        this.change(basicUser, passwordType, changePasswordDTO.getNewPassword(), changePasswordDTO.isForceChange() ? PasswordStatus.RESET : PasswordStatus.ACTIVE);
        this.validateLoginConfirmation(passwordType);
        this.createLog(basicUser, passwordType, PasswordAction.CHANGE);
    }

    public void changeForgottenPassword(ChangeForgottenPasswordDTO changeForgottenPasswordDTO) throws FrameworkException, InvalidSecurityAnswerException {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = this.validateForgotPasswordCode(sessionData, (IForgotPasswordParams)changeForgottenPasswordDTO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        PasswordType passwordType = configurationAccessor.getChannelConfiguration(sessionData.getChannel()).getAccessPassword();
        this.validate(configurationAccessor, basicUser, passwordType, changeForgottenPasswordDTO);
        this.checkForgotPasswordAllowed(sessionData, basicUser);
        if (configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION) {
            Object object;
            String string = basicUser.getSecurityAnswer();
            boolean bl = false;
            if (StringHelper.isNotBlank((Object)string) && StringHelper.isNotBlank((Object)changeForgottenPasswordDTO.getSecurityAnswer())) {
                object = ByteBuffer.allocate(8).putLong(basicUser.getId()).array();
                String string2 = this.applicationHandler.decrypt(string, (byte[])object);
                String string3 = changeForgottenPasswordDTO.getSecurityAnswer();
                bl = string2.equalsIgnoreCase(string3);
            }
            if (bl) {
                this.failedActionHandler.clearUserFailures(FailedAction.FAILED_SECURITY_ANSWER, basicUser);
            } else {
                object = passwordType.getInvalidAttempts();
                boolean bl2 = this.failedActionHandler.recordUserFailure(FailedAction.FAILED_SECURITY_ANSWER, basicUser, (Integer)object, () -> {
                    BasicUser basicUser2 = (BasicUser)this.rawEntityManagerHandler.find(BasicUser.class, basicUser.getId());
                    this.basicUserService.clearValidationKey(basicUser2);
                });
                throw new InvalidSecurityAnswerException(bl2);
            }
        }
        this.basicUserService.clearValidationKey(basicUser);
        if (passwordType.getPasswordMode() == PasswordMode.GENERATED) {
            this.resetAndSend(basicUser, passwordType, CollectionHelper.asSet((Object[])new SendMedium[]{changeForgottenPasswordDTO.getSendMedium()}));
            this.createLog(basicUser, passwordType, PasswordAction.RESET_AND_SEND);
        } else {
            this.change(basicUser, passwordType, changeForgottenPasswordDTO.getNewPassword(), PasswordStatus.ACTIVE);
            this.createLog(basicUser, passwordType, PasswordAction.CHANGE);
        }
    }

    public Pair<String, Password> create(BasicUser basicUser, PasswordType passwordType, String string, PasswordStatus passwordStatus) throws FrameworkException, IllegalActionException {
        if (basicUser == null || passwordType == null) {
            throw new NullPointerException();
        }
        this.checkHasPasswordType(basicUser, passwordType);
        Password password = new Password();
        password.setUser(basicUser);
        password.setDate(DateHelper.now());
        password.setType(passwordType);
        password.setStatus(passwordStatus);
        if (string == null && ObjectHelper.isOneOf((Object)passwordStatus, (Object[])new Object[]{PasswordStatus.ACTIVE, PasswordStatus.EXPIRED, PasswordStatus.RESET})) {
            string = this.generatePassword(passwordType);
        }
        password.setValue(string == null ? null : this.passwordHandler.encode(basicUser, passwordType, string));
        this.persist((IEntity)password);
        basicUser.getPasswords().add(password);
        return Pair.create((Object)string, (Object)password);
    }

    public void disable(PasswordActionDTO passwordActionDTO) {
        Pair<BasicUser, PasswordType> pair = this.load(passwordActionDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.DISABLE);
        this.setStatus(basicUser, passwordType, PasswordStatus.DISABLED);
        this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, PasswordStatus.DISABLED);
        this.createLog(basicUser, passwordType, PasswordAction.DISABLE);
    }

    public void enable(PasswordActionDTO passwordActionDTO) {
        Pair<BasicUser, PasswordType> pair = this.load(passwordActionDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        PasswordMode passwordMode = passwordType.getPasswordMode();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.ENABLE);
        Password password = this.findPassword(basicUser, passwordType);
        if (EnumSet.of(PasswordMode.GENERATED, PasswordMode.OTP).contains(passwordMode) && StringHelper.isBlank((Object)password.getValue())) {
            password.setStatus(PasswordStatus.PENDING);
        } else {
            PasswordStatus passwordStatus;
            if (password.getValue() == null) {
                passwordStatus = PasswordStatus.NEVER_CREATED;
                this.remove((IEntity)password);
            } else {
                passwordStatus = PasswordStatus.ACTIVE;
                password.setStatus(passwordStatus);
            }
            this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, passwordStatus);
        }
        this.createLog(basicUser, passwordType, PasswordAction.ENABLE);
    }

    public boolean exists(BasicUser basicUser, PasswordType passwordType) {
        Password password = this.findPassword(basicUser, passwordType);
        return password != null;
    }

    public OtpResult forgotPasswordRequest(ForgotPasswordRequestDTO forgotPasswordRequestDTO) throws FrameworkException {
        this.basicValidate(forgotPasswordRequestDTO);
        SessionData sessionData = this.getSessionData();
        UserLocatorVO userLocatorVO = forgotPasswordRequestDTO.getUser();
        LocateUserResult locateUserResult = this.locateUserForForgotPassword(sessionData, userLocatorVO);
        BasicUser basicUser = locateUserResult.getBasicUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        this.validate(forgotPasswordRequestDTO, configurationAccessor);
        this.checkForgotPasswordAllowed(sessionData, basicUser);
        SendMedium sendMedium = this.configurationHandler.getAccessAccessor(basicUser).getForgotPasswordSendMedium();
        SendMedium sendMedium2 = (SendMedium)ObjectHelper.defaultValue((Object)(sendMedium == null ? forgotPasswordRequestDTO.getSendMedium() : sendMedium), (Object)SendMedium.EMAIL);
        List<MobilePhone> list = sendMedium2 == SendMedium.SMS ? (locateUserResult.getMobilePhone() != null ? Collections.singletonList(locateUserResult.getMobilePhone()) : basicUser.getMobilePhones().stream().filter(MobilePhone::isEnabledForSms).collect(Collectors.toList())) : null;
        this.captchaService.removeInternalCaptcha(configurationAccessor.getCaptchaConfiguration(), forgotPasswordRequestDTO.getCaptchaResponse());
        if (sendMedium2 == SendMedium.SMS && CollectionHelper.isEmpty(list)) {
            throw new ValidationException(this.message(AccessKeys.Passwords.OTP_ERROR_NO_MOBILE, new Object[0]));
        }
        return (OtpResult)this.conversionHandler.convert(OtpResult.class, (Object)this.otpHandler.sendForForgotPassword(locateUserResult, list, sendMedium2));
    }

    public String generateNew(ChangeGeneratedPasswordDTO changeGeneratedPasswordDTO) {
        BasicUser basicUser = this.getLoggedBasicUser();
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)changeGeneratedPasswordDTO.getType());
        if (passwordType.getPasswordMode() != PasswordMode.GENERATED) {
            throw new IllegalActionException();
        }
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.CHANGE);
        Pair<Password, PasswordStatus> pair = this.getPasswordAndStatus(basicUser, passwordType);
        Password password = (Password)pair.getFirst();
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(changeGeneratedPasswordDTO.getConfirmationPassword(), GenerateNewPasswordConfirmationField.confirmation((PasswordTypeVO)new PasswordTypeVO(passwordType.getId())));
        String string = this.generatePassword(passwordType);
        if (password == null) {
            throw new IllegalActionException();
        }
        String string2 = this.passwordHandler.encode(basicUser, passwordType, string);
        password.setValue(string2);
        password.setStatus(PasswordStatus.ACTIVE);
        password.setDate(DateHelper.now());
        this.createLog(basicUser, passwordType, PasswordAction.CHANGE);
        return string;
    }

    public ChangeForgottenPasswordData getChangeForgottenPasswordData(@NotNull GetChangeForgottenPasswordDataParams getChangeForgottenPasswordDataParams) throws FrameworkException {
        SecurityQuestion securityQuestion;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = this.validateForgotPasswordCode(sessionData, (IForgotPasswordParams)getChangeForgottenPasswordDataParams);
        Channel channel = sessionData.getChannel();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        PasswordType passwordType = configurationAccessor.getChannelConfiguration(channel).getAccessPassword();
        if (ObjectHelper.isNotOneOf((Object)passwordType.getPasswordMode(), (Object[])new Object[]{PasswordMode.MANUAL, PasswordMode.GENERATED})) {
            throw new IllegalActionException("Cannot change a forgotten password with mode " + String.valueOf(passwordType.getPasswordMode()));
        }
        ForgotPasswordMode forgotPasswordMode = configurationAccessor.getForgotPasswordMode();
        if (forgotPasswordMode == ForgotPasswordMode.DISABLED || forgotPasswordMode == ForgotPasswordMode.SECURITY_QUESTION && (basicUser.getSecurityQuestion() == null || StringUtils.isEmpty((CharSequence)basicUser.getSecurityAnswer()))) {
            throw new IllegalActionException();
        }
        ChangeForgottenPasswordData changeForgottenPasswordData = new ChangeForgottenPasswordData();
        changeForgottenPasswordData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        changeForgottenPasswordData.setPrincipalsData(this.basicUserService.getPrincipalsData(basicUser, channel));
        changeForgottenPasswordData.setPasswordType((PasswordTypeDetailedVO)this.conversionHandler.convert(PasswordTypeDetailedVO.class, (Object)passwordType));
        if (forgotPasswordMode == ForgotPasswordMode.SECURITY_QUESTION) {
            securityQuestion = basicUser.getSecurityQuestion();
            changeForgottenPasswordData.setSecurityQuestion(this.message(securityQuestion.getMessageKey(), new Object[0]));
        }
        securityQuestion = new ChangeForgottenPasswordDTO();
        securityQuestion.setUser(getChangeForgottenPasswordDataParams.getUser());
        securityQuestion.setCode(getChangeForgottenPasswordDataParams.getCode());
        changeForgottenPasswordData.setChangeDTO((ChangeForgottenPasswordDTO)securityQuestion);
        return changeForgottenPasswordData;
    }

    public ChangePasswordData getChangePasswordData(boolean bl) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
        BasicUser basicUser = this.getLoggedBasicUser();
        PasswordType passwordType = bl ? channelAccessAccessor.getLoginConfirmation().getPassword() : channelAccessAccessor.getAccessPassword();
        this.checkAllowedAction(basicUser, passwordType, passwordType != null && passwordType.getPasswordMode() == PasswordMode.GENERATED ? PasswordAction.ACTIVATE : PasswordAction.CHANGE);
        ChangePasswordDTO changePasswordDTO = new ChangePasswordDTO();
        changePasswordDTO.setUser((BasicUserVO)this.conversionHandler.convert(UserVO.class, (Object)basicUser));
        changePasswordDTO.setType((PasswordTypeDetailedVO)this.conversionHandler.convert(PasswordTypeDetailedVO.class, (Object)passwordType));
        ChangePasswordData changePasswordData = new ChangePasswordData();
        changePasswordData.setRequireOldPassword(this.shouldCheckOldPassword(basicUser, passwordType, null));
        changePasswordData.setChangePassword(changePasswordDTO);
        return changePasswordData;
    }

    public UserPasswordsData getData(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        BasicUser basicUser2 = this.getLoggedBasicUser();
        UserPasswordsData userPasswordsData = new UserPasswordsData();
        userPasswordsData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        List list = configurationAccessor.getPasswords();
        List list2 = list.stream().filter(passwordType -> passwordType.getPasswordMode().allowActions()).map(passwordType -> this.getPasswordData(basicUser, (PasswordType)passwordType)).collect(Collectors.toList());
        userPasswordsData.setPasswords(list2);
        userPasswordsData.setSendMediums(CollectionHelper.sort((Collection)this.profileFieldHandler.getSendMediums(basicUser)));
        userPasswordsData.setPins(this.pinService.getData(userLocatorVO));
        TotpSecretData totpSecretData = this.totpService.getData(new BasicUserVO(basicUser.getId()));
        if (totpSecretData != null) {
            totpSecretData.setUser(null);
            userPasswordsData.setTotpSecret(totpSecretData);
        }
        if (basicUser.equals((Object)basicUser2)) {
            userPasswordsData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            if (this.isPendingSecurityQuestion(basicUser)) {
                userPasswordsData.setSecurityQuestionData(this.getSetSecurityQuestionData());
            }
        }
        return userPasswordsData;
    }

    public Date getExpirationDate(Password password) {
        return this.getExpirationDate(password.getType(), password.getDate());
    }

    public Pair<Password, PasswordStatus> getPasswordAndStatus(BasicUser basicUser, PasswordType passwordType) {
        PasswordStatus passwordStatus = null;
        Password password = null;
        if (passwordType.getPasswordMode() == PasswordMode.SCRIPT) {
            passwordStatus = PasswordStatus.ACTIVE;
        } else {
            password = this.findPassword(basicUser, passwordType);
            if (password != null) {
                passwordStatus = password.getStatus();
                if (passwordStatus == PasswordStatus.ACTIVE) {
                    if (password.getBlockedUntil() != null && password.getBlockedUntil().after(new Date())) {
                        passwordStatus = PasswordStatus.TEMPORARILY_BLOCKED;
                    } else if (this.hasExpired(passwordType, password.getDate())) {
                        passwordStatus = PasswordStatus.EXPIRED;
                    }
                }
            } else {
                passwordStatus = PasswordStatus.NEVER_CREATED;
            }
        }
        return Pair.create((Object)password, (Object)passwordStatus);
    }

    public PasswordData getPasswordData(BasicUser basicUser, PasswordType passwordType) throws FrameworkException {
        PasswordData passwordData = new PasswordData();
        passwordData.setType((PasswordTypeDetailedVO)this.conversionHandler.convert(PasswordTypeDetailedVO.class, (Object)passwordType));
        Pair<Password, PasswordStatus> pair = this.getPasswordAndStatus(basicUser, passwordType);
        PasswordStatus passwordStatus = (PasswordStatus)pair.getSecond();
        passwordData.setStatus(passwordStatus);
        if (pair.getFirst() != null) {
            passwordData.setDate(this.conversionHandler.toDateTime(((Password)pair.getFirst()).getDate()));
        }
        passwordData.setActions(this.getAllowedActions(basicUser, passwordType, () -> passwordStatus));
        passwordData.setRequireOldPasswordForChange(this.shouldCheckOldPassword(basicUser, passwordType, () -> passwordStatus));
        if (this.getSessionData().isManagerOf(basicUser)) {
            passwordData.setLogs(this.conversionHandler.convertList(PasswordLogVO.class, this.getPasswordLogs(basicUser, passwordType)));
        }
        return passwordData;
    }

    public PasswordData getPasswordData(UserLocatorVO userLocatorVO, PasswordTypeVO passwordTypeVO) throws FrameworkException {
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordTypeVO);
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        return this.getPasswordData(basicUser, passwordType);
    }

    public List<PasswordLog> getPasswordLogs(BasicUser basicUser, PasswordType passwordType) {
        QPasswordLog qPasswordLog = QPasswordLog.passwordLog;
        return ((DBQuery)this.from(new EntityPath[]{qPasswordLog}).where((Predicate)qPasswordLog.user().eq((Object)basicUser).and((Predicate)qPasswordLog.passwordType().eq((Object)passwordType)))).list((Expression)qPasswordLog);
    }

    public PropertyAccess getPropertyAccess(Property<?, ?> property, PasswordType passwordType, final String string) {
        Object object = StringHelper.isNotBlank((Object)passwordType.getInternalName()) ? passwordType.getInternalName() : "password_" + this.applicationHandler.getIdMask().apply(passwordType.getId());
        final String string2 = (String)object + "." + property.getName();
        return new BasePropertyAccess(){

            public Object get(Object object) {
                return string;
            }

            public String getPropertyName() {
                return string2;
            }
        };
    }

    public PasswordStatus getRedundantAccessPasswordStatus(BasicUser basicUser, PasswordType passwordType) {
        if (!this.shouldReadRedundantStatus(passwordType)) {
            return PasswordStatus.ACTIVE;
        }
        List list = StringHelper.split((String)basicUser.getPasswordStatuses(), (String)"|");
        for (String string : list) {
            List list2 = StringHelper.split((String)string, (String)",");
            if (!passwordType.getId().toString().equals(list2.get(0))) continue;
            PasswordStatus passwordStatus = PasswordStatus.valueOf((String)((String)list2.get(2)));
            if (passwordStatus == PasswordStatus.ACTIVE) {
                DateTime dateTime = DateTime.parse((String)((String)list2.get(1)));
                if (StringHelper.isBlank((Object)dateTime.getTimeZone())) {
                    dateTime.setTimeZone(ZoneId.systemDefault().getId());
                }
                return this.hasExpired(passwordType, this.conversionHandler.toDate((IDate)dateTime)) ? PasswordStatus.EXPIRED : PasswordStatus.ACTIVE;
            }
            return passwordStatus;
        }
        return PasswordStatus.NEVER_CREATED;
    }

    public SetSecurityQuestionData getSetSecurityQuestionData() throws FrameworkException {
        SetSecurityQuestionData setSecurityQuestionData = new SetSecurityQuestionData();
        setSecurityQuestionData.setSecurityQuestions(EnumSet.allOf(SecurityQuestion.class).stream().map(this::toSecurityQuestionVO).collect(Collectors.toList()));
        SetSecurityQuestionDTO setSecurityQuestionDTO = new SetSecurityQuestionDTO();
        setSecurityQuestionDTO.setSecurityQuestion(SecurityQuestion.A);
        setSecurityQuestionData.setDto(setSecurityQuestionDTO);
        return setSecurityQuestionData;
    }

    public Pair<PasswordStatus, Set<PasswordAction>> getStatusAndActions(BasicUser basicUser, PasswordType passwordType) throws FrameworkException {
        PasswordStatus passwordStatus = (PasswordStatus)this.getPasswordAndStatus(basicUser, passwordType).getSecond();
        Set<PasswordAction> set = this.getAllowedActions(basicUser, passwordType, () -> passwordStatus);
        return Pair.create((Object)passwordStatus, set);
    }

    @Autowired
    public void initialize() {
        UpdatePasswordStatusListener.register(this::updateUser);
    }

    public boolean isPendingSecurityQuestion() {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isLoggedIn()) {
            return false;
        }
        return this.isPendingSecurityQuestion(sessionData.getLoggedBasicUser());
    }

    public boolean isUserCanChangePassword(BasicUser basicUser, PasswordType passwordType) throws FrameworkException {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)basicUser.getUser());
        BooleanProperties booleanProperties = productsAccessor.product().getPasswordActions().get((Object)passwordType);
        return booleanProperties != null && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.change);
    }

    public boolean remove(BasicUser basicUser, PasswordType passwordType) throws FrameworkException {
        Password password = this.findPassword(basicUser, passwordType);
        if (password != null) {
            this.rawEntityManagerHandler.remove((IEntity)password);
            return true;
        }
        return false;
    }

    public List<String> requestNewOTP(SendMedium sendMedium, String string, List<Long> list) throws FrameworkException {
        if (StringHelper.isBlank((Object)string) || this.getSessionData().getChannelName().equals(string)) {
            return this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).requestNewOTP(sendMedium, list);
        }
        return (List)this.invokerHandler.runAs(SessionDataFactory.inChannel((String)string), () -> this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).requestNewOTP(sendMedium, list));
    }

    public List<String> requestNewOTPForLoginConfirmation(SendMedium sendMedium, List<Long> list) throws FrameworkException, SmsSendingException {
        return this.passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION).requestNewOTP(sendMedium, list);
    }

    public void reset(PasswordActionDTO passwordActionDTO) {
        Pair<BasicUser, PasswordType> pair = this.load(passwordActionDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.RESET);
        this.makeOld(basicUser, passwordType);
        this.setStatus(basicUser, passwordType, PasswordStatus.PENDING);
        this.createLog(basicUser, passwordType, PasswordAction.RESET);
    }

    public void resetAndSend(ResetAndSendPasswordDTO resetAndSendPasswordDTO) {
        Pair<BasicUser, PasswordType> pair = this.load((PasswordActionDTO)resetAndSendPasswordDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.RESET_AND_SEND);
        this.resetAndSend(basicUser, passwordType, resetAndSendPasswordDTO.getSendMediums());
        this.createLog(basicUser, passwordType, PasswordAction.RESET_AND_SEND);
    }

    public void resetSecurityQuestion(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        if (configurationAccessor.getForgotPasswordMode() != ForgotPasswordMode.SECURITY_QUESTION) {
            throw new IllegalActionException();
        }
        basicUser.setSecurityQuestion(null);
        basicUser.setSecurityAnswer(null);
    }

    public void setSecurityQuestion(BasicUser basicUser, SetSecurityQuestionDTO setSecurityQuestionDTO) {
        this.validate(setSecurityQuestionDTO);
        if (basicUser == null || basicUser.isTransient()) {
            throw new IllegalActionException();
        }
        basicUser.setSecurityQuestion(setSecurityQuestionDTO.getSecurityQuestion());
        byte[] byArray = ByteBuffer.allocate(8).putLong(basicUser.getId()).array();
        String string = this.applicationHandler.encryptAsString(setSecurityQuestionDTO.getSecurityAnswer(), byArray);
        basicUser.setSecurityAnswer(string);
    }

    public void setSecurityQuestion(SetSecurityQuestionDTO setSecurityQuestionDTO) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException();
        }
        this.setSecurityQuestion(basicUser, setSecurityQuestionDTO);
    }

    public void unblock(PasswordActionDTO passwordActionDTO) {
        Pair<BasicUser, PasswordType> pair = this.load(passwordActionDTO);
        BasicUser basicUser = (BasicUser)pair.getFirst();
        PasswordType passwordType = (PasswordType)pair.getSecond();
        this.checkAllowedAction(basicUser, passwordType, PasswordAction.UNBLOCK);
        Password password = this.findPassword(basicUser, passwordType);
        password.setBlockedUntil(null);
        password.setStatus(PasswordStatus.ACTIVE);
        this.passwordHandler.notifyPasswordStatusChanged(passwordType, basicUser, PasswordStatus.ACTIVE);
        this.failedActionHandler.clearPasswordFailures(basicUser, passwordType, false);
        this.createLog(basicUser, passwordType, PasswordAction.UNBLOCK);
    }

    public void updateUser(BasicUser basicUser) {
        InvocationContext invocationContext = InvocationContext.get();
        HashSet hashSet = (HashSet)invocationContext.getAttribute((Object)"usersToUpdatePassword", HashSet::new);
        hashSet.add(basicUser.getId());
        invocationContext.addBeforeEndListener(() -> {
            if (hashSet.remove(basicUser.getId())) {
                BasicUser basicUser2 = (BasicUser)this.rawEntityManagerHandler.find(BasicUser.class, basicUser.getId());
                ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser2);
                List list = configurationAccessor.getPasswords();
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>(list.size());
                for (PasswordType passwordType : list) {
                    Password password;
                    if (!this.shouldReadRedundantStatus(passwordType) || (password = this.findPassword(basicUser2, passwordType)) == null) continue;
                    arrayList.add((CallSite)((Object)(passwordType.getId() + "," + String.valueOf(this.conversionHandler.toDateTime(password.getDate())) + "," + String.valueOf(password.getStatus()))));
                }
                basicUser2.setPasswordStatuses(CollectionHelper.join(arrayList, (String)"|"));
            }
        });
    }

    protected LocateUserResult locateUserForForgotPassword(SessionData sessionData, UserLocatorVO userLocatorVO) {
        LocateUserResult locateUserResult;
        try {
            locateUserResult = this.doLocateUserForForgotPassword(userLocatorVO, sessionData);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FORGOT_PASSWORD_REQUEST, sessionData.getRemoteAddress(), userLocatorVO, sessionData.getConfiguration().getInvalidUsernameAttempts(), sessionData.getConfiguration().getRemoteAddressBlockTime());
            if (bl) {
                throw new RemoteAddressBlockedException();
            }
            throw entityNotFoundException;
        }
        return locateUserResult;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QPassword.password.user().network(), true);
    }

    private void addAction(PasswordMode passwordMode, PasswordStatus passwordStatus, Set<PasswordAction> set, PasswordAction passwordAction) {
        if (passwordAction.allowed(passwordMode, passwordStatus)) {
            set.add(passwordAction);
        }
    }

    private void addPasswordChars(StringBuilder stringBuilder, StringBuilder stringBuilder2, Availability availability, String string) {
        if (availability == null) {
            availability = Availability.OPTIONAL;
        }
        switch (availability) {
            case REQUIRED: {
                stringBuilder.append(SecureRandomHelper.random((int)1, (String)string));
                stringBuilder2.append(string);
                break;
            }
            case OPTIONAL: {
                stringBuilder2.append(string);
                break;
            }
        }
    }

    private void basicValidate(ForgotPasswordRequestDTO forgotPasswordRequestDTO) {
        Validator validator = new Validator();
        validator.property((Property)ForgotPasswordRequestDTO.USER, AccessKeys.Login.PRINCIPAL).required();
        this.validate(validator, forgotPasswordRequestDTO, "basicValidate");
    }

    private void change(BasicUser basicUser, PasswordType passwordType, String string, PasswordStatus passwordStatus) {
        this.makeOld(basicUser, passwordType);
        this.create(basicUser, passwordType, string, passwordStatus);
        this.updateUser(basicUser);
    }

    private void checkAllowedAction(BasicUser basicUser, PasswordType passwordType, PasswordAction passwordAction) {
        if (passwordType == null) {
            throw new IllegalActionException("Missing password type");
        }
        if (!this.getAllowedActions(basicUser, passwordType, null).contains(passwordAction)) {
            throw new IllegalActionException("Not allowed password action: " + String.valueOf(passwordAction));
        }
    }

    private void checkForgotPasswordAllowed(SessionData sessionData, BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        ForgotPasswordMode forgotPasswordMode = configurationAccessor.getForgotPasswordMode();
        if (forgotPasswordMode == null || !forgotPasswordMode.showForgotPassword()) {
            throw new EntityNotFoundException(BasicUser.class);
        }
        if (forgotPasswordMode == ForgotPasswordMode.SECURITY_QUESTION && (basicUser.getSecurityQuestion() == null || StringHelper.isBlank((Object)basicUser.getSecurityAnswer()))) {
            throw new ValidationException(this.message(AccessKeys.Passwords.CHANGE_FORGOTTEN_ERROR_NO_SECURITY_QUESTION, new Object[0]));
        }
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(sessionData.getChannel());
        PasswordType passwordType = channelConfiguration.getAccessPassword();
        PasswordStatus passwordStatus = (PasswordStatus)this.getPasswordAndStatus(basicUser, passwordType).getSecond();
        if (!passwordStatus.allowForgotPassword(passwordType.isRequiresAdminAuthorization())) {
            throw new ValidationException(this.message(AccessKeys.Passwords.CHANGE_FORGOTTEN_ERROR_PASSWORD_STATUS, passwordStatus));
        }
    }

    private void checkHasPasswordType(BasicUser basicUser, PasswordType passwordType) {
        if (!this.hasPasswordType(basicUser, passwordType)) {
            throw new IllegalActionException();
        }
    }

    private void createLog(BasicUser basicUser, PasswordType passwordType, PasswordAction passwordAction) {
        PasswordLog passwordLog = new PasswordLog();
        passwordLog.setUser(basicUser);
        passwordLog.setPasswordType(passwordType);
        passwordLog.setAction(passwordAction);
        passwordLog.setDate(DateHelper.now());
        passwordLog.setBy(this.getLoggedBasicUser());
        this.persist((IEntity)passwordLog);
    }

    private LocateUserResult doLocateUserForForgotPassword(UserLocatorVO userLocatorVO, SessionData sessionData) {
        OutboundSmsConfiguration outboundSmsConfiguration;
        if (!ModelHelper.isValid((UserLocatorVO)userLocatorVO)) {
            throw new EntityNotFoundException(BasicUser.class);
        }
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        HashSet<BuiltInPrincipalType> hashSet = new HashSet<BuiltInPrincipalType>(sessionData.getChannelAccessAccessor().getPrincipalTypes());
        if (configurationAccessor.isEmailUnique()) {
            hashSet.add(this.principalTypeService.getEmail());
        }
        if ((outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration()) != null && outboundSmsConfiguration.isEnabled() && configurationAccessor.isMobileUnique()) {
            hashSet.add(this.principalTypeService.getMobilePhone());
        }
        return this.userLocatorHandler.locate(sessionData.getNetwork(), userLocatorVO, EnumSet.of(LocateUserOption.ACTIVE_ONLY, LocateUserOption.IGNORE_HIDDEN), hashSet, null);
    }

    private boolean existsInHistory(BasicUser basicUser, String string, PasswordType passwordType) {
        if (basicUser == null || basicUser.isTransient()) {
            return false;
        }
        QPassword qPassword = QPassword.password;
        List list = ((DBQuery)this.from(new EntityPath[]{qPassword}).where(new Predicate[]{qPassword.user().eq((Object)basicUser), qPassword.type().eq((Object)passwordType)})).list((Expression)qPassword);
        for (Password password : list) {
            if (!this.passwordHandler.matches(password, string)) continue;
            return true;
        }
        return false;
    }

    private Password findPassword(BasicUser basicUser, PasswordType passwordType) {
        if (basicUser == null || passwordType == null) {
            throw new EntityNotFoundException(Password.class);
        }
        QPassword qPassword = QPassword.password;
        return (Password)((DBQuery)((DBQuery)this.from(new EntityPath[]{qPassword}).where(new Predicate[]{qPassword.user().eq((Object)basicUser), qPassword.type().eq((Object)passwordType), qPassword.status.ne((Object)PasswordStatus.OLD)})).orderBy(qPassword.date.desc())).singleResult((Expression)qPassword);
    }

    private String generatePassword(PasswordType passwordType) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (passwordType.getInputMethod() == PasswordInputMethod.TEXT_BOX) {
            this.addPasswordChars(stringBuilder, stringBuilder2, passwordType.getLowerCaseLetters(), StringHelper.LOWERCASE_LETTERS);
            this.addPasswordChars(stringBuilder, stringBuilder2, passwordType.getNumbers(), "0123456789");
            if (passwordType.getLength().getMin() - stringBuilder.length() > 0) {
                stringBuilder.append(SecureRandomHelper.random((int)(passwordType.getLength().getMin() - stringBuilder.length()), (String)stringBuilder2.toString()));
            }
            string = SecureRandomHelper.random((int)stringBuilder.length(), (String)stringBuilder.toString());
        } else {
            string = SecureRandomHelper.random((int)passwordType.getLength().getMin(), (String)passwordType.getPossibleCharacters());
        }
        return string;
    }

    private Set<PasswordAction> getAllowedActions(BasicUser basicUser, PasswordType passwordType, Supplier<PasswordStatus> supplier) {
        BooleanProperties booleanProperties;
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        PasswordMode passwordMode = passwordType.getPasswordMode();
        if (!this.hasPasswordType(basicUser, passwordType)) {
            return Collections.emptySet();
        }
        SessionData sessionData = this.getSessionData();
        PasswordStatus passwordStatus = supplier != null ? supplier.get() : (PasswordStatus)this.getPasswordAndStatus(basicUser, passwordType).getSecond();
        boolean bl8 = passwordMode == PasswordMode.GENERATED;
        boolean bl9 = !sessionData.isLoggedIn() ? true : sessionData.getLoggedBasicUser().equals((Object)basicUser);
        boolean bl10 = basicUser instanceof Operator;
        boolean bl11 = passwordType.isRequiresAdminAuthorization();
        ChannelConfiguration channelConfiguration = this.configurationHandler.getAccessor(basicUser).getChannelConfiguration(this.channelService.getMain());
        boolean bl12 = bl7 = channelConfiguration == null ? false : ObjectHelper.isOneOf((Object)passwordType, (Object[])new Object[]{channelConfiguration.getAccessPassword(), channelConfiguration.getLoginConfirmation().getPassword()});
        if (sessionData.isSystem()) {
            bl6 = true;
            bl5 = true;
            bl4 = true;
            bl3 = true;
            bl2 = true;
            bl = true;
            boolean bl13 = true;
        } else {
            object = bl9 ? this.productsHandler.getAccessor(basicUser).product().getPasswordActions() : sessionData.getProducts().userManagement().getUserPasswordActions();
            booleanProperties = object.get((Object)passwordType);
            if (bl10 && !bl9) {
                boolean bl14;
                boolean bl15 = bl14 = this.permission(basicUser).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
                bl = bl14 && !bl8;
                bl2 = bl14;
                bl3 = bl14;
                bl4 = bl14 && !bl9;
                bl5 = bl14;
                bl6 = bl14 && bl8;
            } else {
                boolean bl16 = booleanProperties != null;
                bl = bl16 && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.change) && !bl8;
                bl2 = bl16 && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.enable);
                bl3 = bl2 && (!bl9 || !bl7);
                bl4 = bl16 && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.reset) && !bl9;
                bl5 = bl16 && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.unblock);
                bl6 = bl16 && booleanProperties.isSet((Path)PasswordServiceImpl.ppa.change) && bl9 && bl8;
            }
        }
        object = new HashSet();
        PasswordAction passwordAction = booleanProperties = !bl8 || bl7 ? PasswordAction.RESET_AND_SEND : PasswordAction.RESET;
        if (bl4 && booleanProperties == PasswordAction.RESET_AND_SEND && this.profileFieldHandler.getSendMediums(basicUser).isEmpty()) {
            bl4 = false;
        }
        switch (passwordStatus) {
            case NEVER_CREATED: {
                if (bl8) {
                    if (bl9 && !bl11) {
                        this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.ACTIVATE);
                    }
                    if (bl11 && this.isAdmin() && bl2) {
                        this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.ALLOW_ACTIVATION);
                    }
                } else {
                    if (bl) {
                        this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.CHANGE);
                    }
                    if (bl3) {
                        this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.DISABLE);
                    }
                }
                if (!bl4) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, (PasswordAction)booleanProperties);
                break;
            }
            case DISABLED: {
                if (bl2) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.ENABLE);
                }
                if (bl4) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, (PasswordAction)booleanProperties);
                }
                if (!bl2 || !bl) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.CHANGE);
                break;
            }
            case PENDING: {
                if (bl3) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.DISABLE);
                }
                if (!bl9) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.ACTIVATE);
                break;
            }
            case ACTIVE: {
                if (bl || bl6) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.CHANGE);
                }
                if (bl4) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, (PasswordAction)booleanProperties);
                }
                if (!bl3) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.DISABLE);
                break;
            }
            case TEMPORARILY_BLOCKED: 
            case INDEFINITELY_BLOCKED: {
                if (bl5) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.UNBLOCK);
                }
                if (bl) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.CHANGE);
                }
                if (bl4) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, (PasswordAction)booleanProperties);
                }
                if (!bl3) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.DISABLE);
                break;
            }
            case RESET: 
            case EXPIRED: {
                if (bl) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.CHANGE);
                }
                if (bl9 && bl8) {
                    this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, PasswordAction.ACTIVATE);
                }
                if (!bl4) break;
                this.addAction(passwordMode, passwordStatus, (Set<PasswordAction>)object, (PasswordAction)booleanProperties);
                break;
            }
        }
        return object;
    }

    private Date getExpirationDate(PasswordType passwordType, Date date) {
        TimeInterval timeInterval = passwordType.getExpiresAfter();
        if (timeInterval != null && timeInterval.isValid()) {
            return DateHelper.add((Date)date, (ITimeInterval)timeInterval);
        }
        return null;
    }

    private boolean hasExpired(PasswordType passwordType, Date date) {
        Date date2 = this.getExpirationDate(passwordType, date);
        return date2 != null && date2.before(new Date());
    }

    private boolean hasPasswordType(BasicUser basicUser, PasswordType passwordType) {
        return passwordType != null && this.configurationHandler.getAccessAccessor(basicUser).getPasswords().contains(passwordType);
    }

    private boolean isPendingSecurityQuestion(BasicUser basicUser) {
        Group group;
        ConfigurationHandler configurationHandler = (ConfigurationHandler)InvocationContext.bean(ConfigurationHandler.class);
        ConfigurationAccessor configurationAccessor = configurationHandler.getAccessor((BasicGroup)(group = basicUser.getUser().getGroup()));
        return configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION && StringHelper.isBlank((Object)basicUser.getSecurityAnswer()) && Objects.equals(basicUser.getNetwork(), group.getNetwork());
    }

    private Pair<BasicUser, PasswordType> load(PasswordActionDTO passwordActionDTO) {
        return Pair.create((Object)((BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)passwordActionDTO.getUser())), (Object)((PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordActionDTO.getType())));
    }

    private void makeOld(BasicUser basicUser, PasswordType passwordType) {
        Password password = this.findPassword(basicUser, passwordType);
        if (password != null) {
            password.setStatus(PasswordStatus.OLD);
        }
    }

    private void resetAndSend(BasicUser basicUser, PasswordType passwordType, Set<SendMedium> set) {
        boolean bl;
        Set set2 = this.profileFieldHandler.getSendMediums(basicUser);
        if (CollectionHelper.isEmpty(set)) {
            set = set2;
            if (CollectionHelper.isEmpty((Iterable)set)) {
                throw new IllegalActionException("No possible send mediums");
            }
        } else {
            for (SendMedium sendMedium : set) {
                if (set2.contains(sendMedium)) continue;
                throw new IllegalActionException("The specified send medium is not usable: " + String.valueOf(sendMedium));
            }
        }
        this.makeOld(basicUser, passwordType);
        PasswordStatus passwordStatus = passwordType.getPasswordMode() == PasswordMode.GENERATED ? PasswordStatus.ACTIVE : ((bl = this.productsHandler.getAccessor(basicUser).product().getPasswordActions().isSet((Object)passwordType, (Path)QProductPasswordAction.productPasswordAction.change)) ? PasswordStatus.RESET : PasswordStatus.ACTIVE);
        String string = (String)this.create(basicUser, passwordType, null, passwordStatus).getFirst();
        boolean bl2 = set.contains(SendMedium.EMAIL);
        boolean bl3 = set.contains(SendMedium.SMS);
        DirectUserSessionData directUserSessionData = new DirectUserSessionData(basicUser, this.getSessionData());
        this.invokerHandler.runAs((SessionData)directUserSessionData, () -> {
            if (bl2) {
                this.mailHandler.send(null, basicUser, MailContext.PASSWORD_RESET, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.PASSWORD_RESET_SUBJECT, new Object[]{passwordType}).body(ContentManagementKeys.Emails.PASSWORD_RESET_BODY, new Object[]{passwordType, string}), new FileInfo[0]);
            }
            if (bl3) {
                String string2 = this.message(MessagingKeys.Notifications.SMS_PASSWORD_RESET, basicUser, passwordType, string);
                this.outboundSmsHandler.send(basicUser, string2, OutboundSmsType.PASSWORD_RESET);
            }
            return null;
        });
    }

    private void setStatus(BasicUser basicUser, PasswordType passwordType, PasswordStatus passwordStatus) {
        Password password = this.findPassword(basicUser, passwordType);
        if (password == null) {
            password = (Password)this.create(basicUser, passwordType, null, passwordStatus).getSecond();
        } else {
            password.setStatus(passwordStatus);
        }
    }

    private boolean shouldCheckOldPassword(BasicUser basicUser, PasswordType passwordType, Supplier<PasswordStatus> supplier) {
        if (basicUser.equals((Object)this.getLoggedBasicUser()) && passwordType.getPasswordMode() != PasswordMode.GENERATED) {
            boolean bl = ObjectHelper.isOneOf((Object)passwordType, (Object[])new Object[]{this.passwordHandler.accessor(CredentialUsage.ACCESS).getPassword(), this.passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION).getPassword()});
            PasswordStatus passwordStatus = supplier != null ? supplier.get() : (PasswordStatus)this.getPasswordAndStatus(basicUser, passwordType).getSecond();
            return passwordStatus != PasswordStatus.NEVER_CREATED && (!bl || ObjectHelper.isNotOneOf((Object)passwordStatus, (Object[])new Object[]{PasswordStatus.EXPIRED, PasswordStatus.RESET}));
        }
        return false;
    }

    private boolean shouldReadRedundantStatus(PasswordType passwordType) {
        return ObjectHelper.isNotOneOf((Object)passwordType.getPasswordMode(), (Object[])new Object[]{PasswordMode.OTP, PasswordMode.SCRIPT});
    }

    private SecurityQuestionVO toSecurityQuestionVO(SecurityQuestion securityQuestion) {
        SecurityQuestionVO securityQuestionVO = new SecurityQuestionVO();
        securityQuestionVO.setSecurityQuestion(securityQuestion);
        securityQuestionVO.setLabel(this.message(securityQuestion.getMessageKey(), new Object[0]));
        return securityQuestionVO;
    }

    private void validate(ChangePasswordDTO changePasswordDTO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changePasswordDTO.getUser());
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)changePasswordDTO.getType());
        Validator validator = new Validator();
        validator.property((Property)ChangePasswordDTO.USER, UsersKeys.Users.USER).required();
        validator.property((Property)ChangePasswordDTO.TYPE, AccessKeys.Passwords.TYPE).required();
        if (basicUser != null && passwordType != null) {
            validator.property((Property)ChangePasswordDTO.NEW_PASSWORD, AccessKeys.Passwords.ACTION_CHANGE_NEW_PASSWORD).required();
            validator.property((Property)ChangePasswordDTO.CONFIRM_NEW_PASSWORD, AccessKeys.Passwords.ACTION_CHANGE_NEW_PASSWORD_CONFIRM).required().add((object, object2, object3) -> {
                if (!Objects.equals(changePasswordDTO.getNewPassword(), changePasswordDTO.getConfirmNewPassword())) {
                    return new ValidationError(AccessKeys.Passwords.ERROR_PASSWORD_DOES_NOT_MATCH);
                }
                return null;
            });
            if (this.shouldCheckOldPassword(basicUser, passwordType, null)) {
                validator.property((Property)ChangePasswordDTO.OLD_PASSWORD, AccessKeys.Passwords.ACTION_CHANGE_OLD_PASSWORD).required();
            }
            this.addValidations(validator.property((Property)ChangePasswordDTO.NEW_PASSWORD, AccessKeys.Passwords.NEW_PASSWORD), basicUser, basicUser.getUsername(), passwordType, false);
        }
        this.validate(validator, changePasswordDTO, "changePasswordDTO");
    }

    private void validate(ConfigurationAccessor configurationAccessor, BasicUser basicUser, PasswordType passwordType, ChangeForgottenPasswordDTO changeForgottenPasswordDTO) {
        PasswordMode passwordMode;
        Validator validator = new Validator();
        validator.property((Property)ChangeForgottenPasswordDTO.USER, AccessKeys.Passwords.CHANGE_FORGOTTEN_USER).required();
        validator.property((Property)ChangeForgottenPasswordDTO.CODE, AccessKeys.Passwords.CHANGE_FORGOTTEN_CODE).required();
        if (configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION) {
            validator.property((Property)ChangeForgottenPasswordDTO.SECURITY_ANSWER, AccessKeys.Passwords.SECURITY_ANSWER).required();
        }
        if ((passwordMode = passwordType.getPasswordMode()) == PasswordMode.MANUAL) {
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)ChangeForgottenPasswordDTO.NEW_PASSWORD, AccessKeys.Passwords.ACTION_CHANGE_NEW_PASSWORD).required();
            this.addValidations(property, basicUser, basicUser.getUsername(), passwordType, false);
            org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)ChangeForgottenPasswordDTO.CONFIRM_NEW_PASSWORD, AccessKeys.Passwords.ACTION_CHANGE_NEW_PASSWORD_CONFIRM).required();
            if (!Objects.equals(changeForgottenPasswordDTO.getNewPassword(), changeForgottenPasswordDTO.getConfirmNewPassword())) {
                property2.invalid();
            }
        }
        this.validate(validator, changeForgottenPasswordDTO, "changeForgottenPasswordDTO");
    }

    private void validate(ForgotPasswordRequestDTO forgotPasswordRequestDTO, ConfigurationAccessor configurationAccessor) {
        SendMedium sendMedium;
        Validator validator = new Validator();
        CaptchaConfiguration captchaConfiguration = configurationAccessor.getCaptchaConfiguration();
        if (captchaConfiguration.isUseOnForgotPassword()) {
            validator.property((Property)ForgotPasswordRequestDTO.CAPTCHA_RESPONSE, AccessKeys.Passwords.CAPTCHA).captcha(captchaConfiguration);
        }
        if ((sendMedium = configurationAccessor.getForgotPasswordSendMedium()) != null) {
            validator.property((Property)ForgotPasswordRequestDTO.SEND_MEDIUM, AccessKeys.Passwords.CHANGE_FORGOTTEN_SEND_MEDIUM).anyOf(new Object[]{sendMedium});
        }
        this.validate(validator, forgotPasswordRequestDTO, "forgotPasswordRequestDTO");
    }

    private void validate(SetSecurityQuestionDTO setSecurityQuestionDTO) {
        Validator validator = new Validator();
        validator.property((Property)SetSecurityQuestionDTO.SECURITY_QUESTION, AccessKeys.Passwords.SECURITY_QUESTION).required();
        validator.property((Property)SetSecurityQuestionDTO.SECURITY_ANSWER, AccessKeys.Passwords.SECURITY_ANSWER).required().maxLength(200);
        this.validate(validator, setSecurityQuestionDTO, "setSecurityQuestionDTO");
    }

    private BasicUser validateForgotPasswordCode(SessionData sessionData, IForgotPasswordParams iForgotPasswordParams) {
        Validator validator = new Validator();
        validator.property((Property)ChangeForgottenPasswordDTO.USER, AccessKeys.Login.PRINCIPAL).required();
        validator.property((Property)ChangeForgottenPasswordDTO.CODE, AccessKeys.Passwords.CHANGE_FORGOTTEN_CODE).required().fixedLength(6);
        this.validate(validator, iForgotPasswordParams, "validateForgotPasswordCode");
        LocateUserResult locateUserResult = this.locateUserForForgotPassword(sessionData, iForgotPasswordParams.getUser());
        BasicUser basicUser = locateUserResult.getBasicUser();
        try {
            this.otpHandler.verify(OtpType.FORGOT_PASSWORD, (OtpOwner)basicUser, iForgotPasswordParams.getCode());
            return basicUser;
        }
        catch (ValidationException validationException) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
            PasswordType passwordType = configurationAccessor.getChannelConfiguration(sessionData.getChannel()).getAccessPassword();
            boolean bl = this.failedActionHandler.recordPasswordFailure(basicUser, passwordType, true);
            if (bl) {
                bl = this.failedActionHandler.recordBlockedUserFailedAction((UserLocatorVO)locateUserResult.getLocator());
                if (bl) {
                    throw new RemoteAddressBlockedException();
                }
                throw new PasswordStatusException((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType), passwordType.getInvalidAction().getPasswordStatus());
            }
            String string = this.message(GeneralKeys.Errors.INVALID, this.message(AccessKeys.Passwords.CHANGE_FORGOTTEN_CODE, new Object[0]));
            throw new ValidationException(GetChangeForgottenPasswordDataParams.CODE.getName(), string);
        }
    }

    private void validateLoginConfirmation(PasswordType passwordType) {
        SessionData sessionData = this.getSessionData();
        Session session = sessionData.getSession();
        if (session != null && passwordType.equals((Object)sessionData.getChannelAccessAccessor().getLoginConfirmation().getPassword())) {
            session.setPendingLoginConfirmation(false);
        }
    }

    private final class PasswordObviousValidation
    extends BasePropertyValidation {
        private final BasicUser user;
        private final PasswordType passwordType;

        private PasswordObviousValidation(BasicUser basicUser, PasswordType passwordType) {
            super(new ValidationError(GeneralKeys.Errors.TOO_OBVIOUS));
            this.user = basicUser;
            this.passwordType = passwordType;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            if (this.user == null) {
                return true;
            }
            return this.passwordType.isAvoidObvious() ? !PasswordHelper.isTooObvious((String)object3.toString(), Arrays.asList(this.user.getUsername(), this.user.getEmail(), StringUtils.substringBefore((String)this.user.getEmail(), (String)"@"))) : true;
        }
    }

    protected class CharsetValidation
    extends BasePropertyValidation {
        private String charset;
        private Availability policy;

        public CharsetValidation(Availability availability, String string, MessageKey messageKey) {
            super(new ValidationError(messageKey));
            this.charset = string;
            this.policy = availability;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            String string = (String)object3;
            if (this.policy == null) {
                return true;
            }
            switch (this.policy) {
                case DISABLED: {
                    return StringUtils.containsNone((CharSequence)string, (String)this.charset);
                }
                case REQUIRED: {
                    return StringUtils.containsAny((CharSequence)string, (CharSequence)this.charset);
                }
                case OPTIONAL: {
                    return true;
                }
            }
            return false;
        }
    }
}

