/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.DynamicOidcClient;
import org.cyclos.entities.access.OidcClient;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.QBaseOidcClient;
import org.cyclos.entities.access.QDynamicOidcClient;
import org.cyclos.entities.access.QOidcAuthorization;
import org.cyclos.entities.access.QOidcClient;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.DynamicOidcClientConfiguration;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.OidcClientImage;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.OidcClientImageServiceLocal;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.OidcServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.oidcclients.BaseOidcClientDTO;
import org.cyclos.model.access.oidcclients.DynamicOidcClientDTO;
import org.cyclos.model.access.oidcclients.OidcClientDTO;
import org.cyclos.model.access.oidcclients.OidcClientData;
import org.cyclos.model.access.oidcclients.OidcClientQuery;
import org.cyclos.model.access.oidcclients.OidcClientSearchData;
import org.cyclos.model.access.oidcclients.OidcClientVO;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.model.access.oidc.RegisterRequest;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.services.access.OidcRegisterException;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.URIHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OidcClientServiceImpl
extends CRUDServiceImpl<BaseOidcClient, QBaseOidcClient, BaseOidcClientDTO, OidcClientData, Void>
implements OidcClientServiceLocal {
    private static final BidiMap<Class<? extends BaseOidcClient>, Class<? extends BaseOidcClientDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Object[] EXCLUDED_PROPERTIES;
    @Autowired
    private OidcClientImageServiceLocal oidcClientImageService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private LinkGeneratorHandler linkGenerationHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CyclosProperties cyclosProperties;
    private UrlValidator webUrlValidator;
    private UrlValidator webPlainUrlValidator;
    private UrlValidator nativeUrlValidator;

    public OidcClientServiceImpl() {
        super(BaseOidcClient.class, QBaseOidcClient.baseOidcClient, BaseOidcClientDTO.class);
    }

    public OidcClientAccessor getAccessor(BaseOidcClient baseOidcClient) {
        if (baseOidcClient == null || !baseOidcClient.isEnabled()) {
            return DisabledOidcClientAccessor.INSTANCE;
        }
        if (baseOidcClient instanceof DynamicOidcClient) {
            Configuration configuration = ((DynamicOidcClient)baseOidcClient).getConfiguration();
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
            DynamicOidcClientConfiguration dynamicOidcClientConfiguration = configurationAccessor.getDynamicOidcClientConfiguration();
            return (OidcClientAccessor)ObjectHelper.defaultValue((Object)dynamicOidcClientConfiguration, (Object)DisabledOidcClientAccessor.INSTANCE);
        }
        return (OidcClient)baseOidcClient;
    }

    public BaseOidcClient getByClientId(String string) {
        return (BaseOidcClient)((DBQuery)this.selectFrom(this.$).where((Predicate)((QBaseOidcClient)this.$).clientId.eq((Object)string))).fetchFirst();
    }

    public OidcClientSearchData getSearchData() throws FrameworkException {
        OidcClientSearchData oidcClientSearchData = new OidcClientSearchData();
        OidcClientQuery oidcClientQuery = (OidcClientQuery)QueryHelper.newQuery(OidcClientQuery.class);
        oidcClientSearchData.setQuery((QueryParameters)oidcClientQuery);
        return oidcClientSearchData;
    }

    @PostConstruct
    public void initialize() {
        String[] stringArray = new String[]{"https"};
        String[] stringArray2 = new String[]{"https", "http"};
        long l = 0L;
        if (this.cyclosProperties.isDevelopment()) {
            l += 8L;
        }
        this.webUrlValidator = new UrlValidator(stringArray, l);
        this.webPlainUrlValidator = new UrlValidator(stringArray2, l);
        this.nativeUrlValidator = new UrlValidator(9L);
    }

    public List<OidcClient> listStaticEnabled() {
        QOidcClient qOidcClient = QOidcClient.oidcClient;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qOidcClient}).where((Predicate)qOidcClient.enabled.isTrue())).orderBy(qOidcClient.name.asc())).list((Expression)qOidcClient);
    }

    @Override
    public BaseOidcClient newEntity(Void void_) {
        OidcClient oidcClient = new OidcClient();
        oidcClient.setEnabled(true);
        oidcClient.setScopes(CollectionHelper.asSet((Object[])new Scope[]{Scope.OPENID, Scope.PROFILE, Scope.EMAIL}));
        oidcClient.setSecret(this.newSecret());
        oidcClient.setAccessTokenExpiration(new TimeInterval(Integer.valueOf(1), TimeField.MINUTES));
        return oidcClient;
    }

    public DynamicOidcClient registerDynamic(RegisterRequest registerRequest) {
        List list;
        String string;
        block13: {
            boolean bl;
            DynamicOidcClientConfiguration dynamicOidcClientConfiguration;
            block12: {
                dynamicOidcClientConfiguration = this.getSessionData().getConfiguration().getDynamicOidcClientConfiguration();
                if (dynamicOidcClientConfiguration == null || !dynamicOidcClientConfiguration.isEnabled()) {
                    OidcRegisterException.throwDisabled();
                }
                if (registerRequest.getApplicationType() != null && !OidcServiceLocal.APPLICATION_TYPES.contains(registerRequest.getApplicationType())) {
                    OidcRegisterException.throwClient((String)("Invalid parameter: application_type. Allowed values are: " + StringHelper.join((Collection)OidcServiceLocal.APPLICATION_TYPES, (String)", ")));
                }
                string = (String)ObjectHelper.defaultValue((Object)registerRequest.getApplicationType(), (Object)"web");
                registerRequest.setApplicationType(string);
                bl = "native".equals(string);
                UrlValidator urlValidator = bl ? this.nativeUrlValidator : (dynamicOidcClientConfiguration.isAllowUnencryptedUris() ? this.webPlainUrlValidator : this.webUrlValidator);
                list = CollectionHelper.orEmpty((List)(registerRequest == null ? null : registerRequest.getRedirectUris()));
                if (list.isEmpty()) break block12;
                if (list.stream().allMatch(arg_0 -> ((UrlValidator)urlValidator).isValid(arg_0)) && URIHelper.inSameOrigin(list.stream())) break block13;
            }
            OidcRegisterException.throwRedirectUri((!bl && dynamicOidcClientConfiguration.isAllowUnencryptedUris() ? 1 : 0) != 0);
        }
        this.checkInSameDomain(list, "logo_uri", registerRequest.getLogoUri());
        this.checkInSameDomain(list, "client_uri", registerRequest.getClientUri());
        this.checkInSameDomain(list, "policy_uri", registerRequest.getPolicyUri());
        this.checkInSameDomain(list, "tos_uri", registerRequest.getTosUri());
        List<String> list2 = registerRequest.getResponseTypes();
        if (CollectionHelper.isEmpty((Iterable)list2)) {
            list2 = Collections.singletonList("code");
        } else if (!list2.stream().allMatch(OidcServiceLocal.RESPONSE_TYPES::contains)) {
            OidcRegisterException.throwClient((String)("Invalid parameter: response_types. Allowed values are:" + StringHelper.join((Collection)OidcServiceLocal.RESPONSE_TYPES, (String)", ")));
        }
        List<String> list3 = registerRequest.getGrantTypes();
        if (CollectionHelper.isEmpty((Iterable)list3)) {
            list3 = Collections.singletonList("authorization_code");
        } else if (!list3.stream().allMatch(OidcServiceLocal.GRANT_TYPES::contains)) {
            OidcRegisterException.throwClient((String)("Invalid parameter: grant_types. Allowed values are:" + StringHelper.join((Collection)OidcServiceLocal.GRANT_TYPES, (String)", ")));
        }
        if (list2.contains("code") && !list3.contains("authorization_code") || CollectionHelper.containsAny(list2, (Object[])new Object[]{"id_token", "token"}) && !list3.contains("implicit")) {
            OidcRegisterException.throwClient((String)"Incompatible parameter values: grant_types / response_types");
        }
        DynamicOidcClient dynamicOidcClient = new DynamicOidcClient();
        dynamicOidcClient.setClientId(StringHelper.randomAlphanumeric((int)32));
        dynamicOidcClient.setSecret(StringHelper.randomAlphanumeric((int)64));
        dynamicOidcClient.setApplicationType(string);
        dynamicOidcClient.setRedirectUris(StringHelper.join((Collection)registerRequest.getRedirectUris(), (String)"\n"));
        dynamicOidcClient.setCreationDate(new Date());
        dynamicOidcClient.setImageUrl(registerRequest.getLogoUri());
        dynamicOidcClient.setName((String)ObjectHelper.defaultValue((Object)registerRequest.getClientName(), () -> URIHelper.of((String)((String)CollectionHelper.first((Iterable)list))).getHost()));
        dynamicOidcClient.setWebsite(registerRequest.getClientUri());
        dynamicOidcClient.setTermsOfServiceUrl(registerRequest.getTosUri());
        dynamicOidcClient.setPrivacyPolicyUrl(registerRequest.getPolicyUri());
        dynamicOidcClient.setGrantTypes(StringHelper.join(list3, (String)" "));
        dynamicOidcClient.setResponseTypes(StringHelper.join(list2, (String)" "));
        this.persist((IEntity)dynamicOidcClient);
        return dynamicOidcClient;
    }

    public Page<OidcClientVO> search(OidcClientQuery oidcClientQuery) {
        BasicUser basicUser;
        QBaseOidcClient qBaseOidcClient = (QBaseOidcClient)this.$;
        if (oidcClientQuery.getNature() != null) {
            switch (oidcClientQuery.getNature()) {
                case DYNAMIC: {
                    qBaseOidcClient = QDynamicOidcClient.dynamicOidcClient._super;
                    break;
                }
                case STATIC: {
                    qBaseOidcClient = QOidcClient.oidcClient._super;
                }
            }
        }
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qBaseOidcClient});
        if (StringHelper.isNotBlank((Object)oidcClientQuery.getKeywords())) {
            dBQuery.where((Predicate)qBaseOidcClient.name.containsIgnoreCase(oidcClientQuery.getKeywords()));
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)oidcClientQuery.getUser())) != null) {
            QOidcAuthorization qOidcAuthorization = QOidcAuthorization.oidcAuthorization;
            dBQuery.where((Predicate)((DBQuery)this.entityManagerHandler.subQuery(new EntityPath[]{qOidcAuthorization}).where(new Predicate[]{qOidcAuthorization.client().eq((Expression)qBaseOidcClient), qOidcAuthorization.basicUser().eq((Object)basicUser)})).exists());
        }
        if (oidcClientQuery.getEnabled() != null) {
            dBQuery.where((Predicate)qBaseOidcClient.enabled.eq(oidcClientQuery.getEnabled()));
        }
        dBQuery.orderBy(qBaseOidcClient.name.asc());
        return dBQuery.page(OidcClientVO.class, (QueryParameters)oidcClientQuery, (Expression)qBaseOidcClient);
    }

    @Override
    public BaseOidcClient toEntity(BaseOidcClientDTO baseOidcClientDTO) {
        Image image;
        OidcClientDTO oidcClientDTO;
        OidcClientDTO oidcClientDTO2;
        if (baseOidcClientDTO instanceof OidcClientDTO && (oidcClientDTO2 = (OidcClientDTO)baseOidcClientDTO).getImage() == null && oidcClientDTO2.isPersistent()) {
            oidcClientDTO = (BaseOidcClient)this.find(baseOidcClientDTO.getId());
            this.oidcClientImageService.removeAll((BaseEntity)((OidcClient)oidcClientDTO));
        }
        oidcClientDTO2 = (BaseOidcClient)super.toEntity(baseOidcClientDTO);
        if (baseOidcClientDTO instanceof OidcClientDTO && (oidcClientDTO = (OidcClientDTO)baseOidcClientDTO).getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)oidcClientDTO.getImage())) instanceof TempImage) {
            ((OidcClient)oidcClientDTO2).setUploadedImage((TempImage)image);
        }
        return oidcClientDTO2;
    }

    @Override
    protected OidcClientData getData(BaseOidcClient baseOidcClient) {
        OidcClientData oidcClientData = new OidcClientData();
        oidcClientData.setDto((EntityDTO)((BaseOidcClientDTO)this.toDTO(baseOidcClient)));
        String string = StringHelper.removeEnd((String)this.linkGenerationHandler.root(null), (String)"/");
        oidcClientData.setDiscoveryUrl(string + "/.well-known/openid-configuration");
        if (baseOidcClient instanceof OidcClient) {
            oidcClientData.setAccounts(this.accountTypeService.listAll().stream().filter(accountType -> accountType instanceof UserAccountType).map(this.conversionHandler.convertingFunction(AccountTypeVO.class, new Object[0])).collect(Collectors.toList()));
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            transferTypeQuery.setDirection(TransferTypeDirection.USER_TO_USER);
            transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.PAYMENT));
            List list = this.transferTypeService.search(TransferTypeVO.class, transferTypeQuery).getPageItems();
            list.sort(Comparator.comparing(TransferTypeVO::getFrom).thenComparing(Comparator.naturalOrder()));
            oidcClientData.setPayments(list);
            TransferTypeQuery transferTypeQuery2 = new TransferTypeQuery();
            transferTypeQuery2.setUnlimited();
            transferTypeQuery2.setDirection(TransferTypeDirection.USER_TO_USER);
            transferTypeQuery2.setNatures(Collections.singleton(TransferTypeNature.PAYMENT));
            transferTypeQuery2.setChannel(new ChannelVO(this.channelService.getTicket().getId()));
            List list2 = this.transferTypeService.search(TransferTypeVO.class, transferTypeQuery2).getPageItems();
            list2.sort(Comparator.comparing(TransferTypeVO::getFrom).thenComparing(Comparator.naturalOrder()));
            oidcClientData.setTickets(list2);
        }
        return oidcClientData;
    }

    @Override
    protected MessageKey getEntityInternalNameKey(BaseOidcClientDTO baseOidcClientDTO) {
        if (baseOidcClientDTO instanceof OidcClientDTO) {
            return AccessKeys.OidcClients.CLIENT_ID;
        }
        return super.getEntityInternalNameKey(baseOidcClientDTO);
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(BaseOidcClientDTO baseOidcClientDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected boolean isEntityInternalNameRequired(BaseOidcClientDTO baseOidcClientDTO) {
        return baseOidcClientDTO instanceof OidcClientDTO;
    }

    @Override
    protected void onAfterSave(BaseOidcClient baseOidcClient, BaseOidcClient baseOidcClient2, Object object) {
        OidcClient oidcClient;
        TempImage tempImage;
        if (baseOidcClient instanceof OidcClient && (tempImage = (oidcClient = (OidcClient)baseOidcClient).getUploadedImage()) != null) {
            this.oidcClientImageService.importTempImage((BaseEntity)oidcClient, tempImage);
        }
    }

    @Override
    protected void onBeforeRemove(BaseOidcClient baseOidcClient) {
        if (baseOidcClient instanceof OidcClient) {
            OidcClient oidcClient = (OidcClient)baseOidcClient;
            CollectionHelper.orEmpty((List)oidcClient.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
        }
    }

    @Override
    protected Object onBeforeSave(BaseOidcClient baseOidcClient, BaseOidcClient baseOidcClient2) {
        OidcClient oidcClient;
        if (baseOidcClient.isTransient()) {
            baseOidcClient.setCreationDate(new Date());
            this.maybeAssignClientId(baseOidcClient);
            if (StringHelper.isBlank((Object)baseOidcClient.getSecret())) {
                baseOidcClient.setSecret(this.newSecret());
            }
            if (baseOidcClient instanceof DynamicOidcClient) {
                oidcClient = this.getSessionData().getConfiguration().getConfiguration();
                ((DynamicOidcClient)baseOidcClient).setConfiguration((Configuration)oidcClient);
            }
        }
        if (baseOidcClient instanceof OidcClient) {
            oidcClient = (OidcClient)baseOidcClient;
            oidcClient.setClientId(oidcClient.getInternalName());
            Set set = oidcClient.getScopes();
            if (!set.contains(Scope.ACCOUNT_STATUS) && !set.contains(Scope.ACCOUNT_HISTORY)) {
                oidcClient.setAccounts(new HashSet());
            }
            if (!set.contains(Scope.PAYMENT)) {
                oidcClient.setPayments(new HashSet());
            }
            if (!set.contains(Scope.TICKETS)) {
                oidcClient.setTickets(new HashSet());
            }
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(BaseOidcClientDTO baseOidcClientDTO, BaseOidcClient baseOidcClient) {
        if (baseOidcClient instanceof OidcClient) {
            OidcClient oidcClient = (OidcClient)baseOidcClient;
            oidcClient.getAccounts().size();
            oidcClient.getPayments().size();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBaseOidcClient)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(final BaseOidcClientDTO baseOidcClientDTO) {
        Validator validator = new Validator();
        validator.property((Property)OidcClientDTO.SECRET, AccessKeys.OidcClients.SECRET).required().fixedLength(64);
        validator.property((Property)OidcClientDTO.SCOPES, AccessKeys.OidcClients.SCOPES).required().add((PropertyValidation)new BasePropertyValidation(){

            protected boolean isValid(Object object, Object object2, Object object3) {
                Set set = CollectionHelper.orEmpty((Set)((Set)object3));
                if (!set.contains(Scope.OPENID)) {
                    return set.stream().noneMatch(Scope::dependsOnOpenid);
                }
                return true;
            }
        });
        if (baseOidcClientDTO instanceof OidcClientDTO) {
            OidcClientDTO oidcClientDTO = (OidcClientDTO)baseOidcClientDTO;
            Set set = CollectionHelper.orEmpty((Set)oidcClientDTO.getScopes());
            if (set.contains(Scope.ACCOUNT_STATUS) || set.contains(Scope.ACCOUNT_HISTORY)) {
                validator.property((Property)OidcClientDTO.ACCOUNTS, AccessKeys.OidcClients.ACCOUNTS).required();
            }
            if (set.contains(Scope.PAYMENT)) {
                validator.property((Property)OidcClientDTO.PAYMENTS, AccessKeys.OidcClients.PAYMENTS).required();
            }
            if (set.contains(Scope.TICKETS)) {
                validator.property((Property)OidcClientDTO.TICKETS, AccessKeys.OidcClients.TICKETS).required();
            }
            validator.property((Property)OidcClientDTO.ACCESS_TOKEN_EXPIRATION, AccessKeys.OidcClients.ACCESS_TOKEN_EXPIRATION).required().positiveIntegerNonZero().timeInterval();
            validator.property((Property)OidcClientDTO.REDIRECT_URIS, AccessKeys.OidcClients.REDIRECT_URIS).required();
            validator.property((Property)OidcClientDTO.IMAGE, AccessKeys.OidcClients.IMAGE).entity(Image.class, (EntityValidation)new BaseEntityValidation<Image>(){

                protected boolean isValid(Object object, Object object2, Image image) {
                    if (image instanceof TempImage) {
                        TempImage tempImage = (TempImage)image;
                        return tempImage.getTarget() == TempImageTarget.OIDC_CLIENT;
                    }
                    if (image instanceof OidcClientImage) {
                        OidcClientImage oidcClientImage = (OidcClientImage)image;
                        return oidcClientImage.getCategory().getId().equals(baseOidcClientDTO.getId());
                    }
                    return false;
                }
            });
            validator.property((Property)OidcClientDTO.WEBSITE, AccessKeys.OidcClients.WEBSITE).url().maxLength(255);
            validator.property((Property)OidcClientDTO.PRIVACY_POLICY_URL, AccessKeys.OidcClients.PRIVACY_POLICY_URL).url().maxLength(255);
            validator.property((Property)OidcClientDTO.TERMS_OF_SERVICE_URL, AccessKeys.OidcClients.TERMS_OF_SERVICE_URL).url().maxLength(255);
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends BaseOidcClient>, Class<? extends BaseOidcClientDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void checkInSameDomain(List<String> list, String string, String string2) {
        if (string2 != null && !URIHelper.inSameOrigin(Stream.concat(list.stream(), Stream.of(string2)))) {
            OidcRegisterException.throwClient((String)("If " + string + " is specified, it must be in the same domain as redirect_uris"));
        }
    }

    private void maybeAssignClientId(BaseOidcClient baseOidcClient) {
        if (StringHelper.isBlank((Object)baseOidcClient.getClientId())) {
            for (int i = 0; i < 10; ++i) {
                String string = RandomStringUtils.randomAlphanumeric((int)32);
                if (!((DBQuery)this.from().where((Predicate)((QBaseOidcClient)this.$).clientId.eq((Object)string))).hasEmptyResults()) continue;
                baseOidcClient.setClientId(string);
            }
            if (StringHelper.isBlank((Object)baseOidcClient.getClientId())) {
                throw new IllegalStateException("Couldn't assign a valid client id");
            }
        }
    }

    private String newSecret() {
        return RandomStringUtils.randomAlphanumeric((int)64);
    }

    static {
        SUBCLASS_MAPPINGS.put(OidcClient.class, OidcClientDTO.class);
        SUBCLASS_MAPPINGS.put(DynamicOidcClient.class, DynamicOidcClientDTO.class);
        EXCLUDED_PROPERTIES = new Object[]{OidcClientDTO.IMAGE};
    }

    private static class DisabledOidcClientAccessor
    implements OidcClientAccessor {
        private static final DisabledOidcClientAccessor INSTANCE = new DisabledOidcClientAccessor();

        private DisabledOidcClientAccessor() {
        }

        public TimeInterval getAccessTokenExpiration() {
            return TimeInterval.ONE_MINUTE;
        }

        public Set<UserAccountType> getAccounts() {
            return Collections.emptySet();
        }

        public Set<PaymentTransferType> getPayments() {
            return Collections.emptySet();
        }

        public Set<Scope> getScopes() {
            return Collections.emptySet();
        }

        public Set<PaymentTransferType> getTickets() {
            return Collections.emptySet();
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean isSinglePaymentPerConsent() {
            return false;
        }
    }
}

