/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.OidcClient;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.QOidcAccessToken;
import org.cyclos.entities.access.QOidcAuthorization;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.OidcAuthorizationServiceLocal;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationDetailedVO;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationQuery;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationSearchData;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationVO;
import org.cyclos.model.access.oidcclients.OidcClientVO;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.access.oidcclients.ScopeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OidcAuthorizationServiceImpl
extends BaseServiceImpl
implements OidcAuthorizationServiceLocal {
    private static final QOidcAuthorization $ = QOidcAuthorization.oidcAuthorization;
    @Autowired
    private OidcClientServiceLocal oidcClientService;

    public OidcAuthorizationSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        OidcAuthorizationSearchData oidcAuthorizationSearchData = new OidcAuthorizationSearchData();
        OidcAuthorizationQuery oidcAuthorizationQuery = (OidcAuthorizationQuery)QueryHelper.newQuery(OidcAuthorizationQuery.class);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser == null) {
            oidcAuthorizationSearchData.setClients(this.conversionHandler.convertList(OidcClientVO.class, (Iterable)this.oidcClientService.listStaticEnabled()));
            GroupListView groupListView = this.groupsHandler.visibles().accessibles().basic();
            oidcAuthorizationSearchData.setGroups(groupListView.sorted());
            oidcAuthorizationQuery.setGroups(groupListView.defaultFilter());
        } else {
            oidcAuthorizationQuery.setConsentBy(new BasicUserVO(basicUser.getId()));
        }
        oidcAuthorizationSearchData.setQuery((QueryParameters)oidcAuthorizationQuery);
        return oidcAuthorizationSearchData;
    }

    public boolean isSinglePayment(OidcAuthorization oidcAuthorization) {
        if (oidcAuthorization.getPaymentTo() != null) {
            return true;
        }
        OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(oidcAuthorization.getClient());
        return oidcClientAccessor.isSinglePaymentPerConsent();
    }

    public OidcAuthorizationDetailedVO load(@NotNull Long l) throws FrameworkException {
        OidcAuthorization oidcAuthorization = this.find(OidcAuthorization.class, l);
        OidcAuthorizationDetailedVO oidcAuthorizationDetailedVO = (OidcAuthorizationDetailedVO)this.conversionHandler.convertExcluding(OidcAuthorizationDetailedVO.class, (Object)oidcAuthorization, new Object[]{OidcAuthorizationDetailedVO.PAYMENT_AMOUNT, OidcAuthorizationDetailedVO.SCOPES});
        oidcAuthorizationDetailedVO.setPaymentAmount((CurrencyAmountDTO)this.conversionHandler.convert(CurrencyAmountDTO.class, (Object)oidcAuthorization.getCurrencyAmount()));
        oidcAuthorizationDetailedVO.setScopes(oidcAuthorization.getScopes().stream().sorted().map(scope -> this.toScopeVO((Scope)scope, oidcAuthorization)).collect(Collectors.toList()));
        return oidcAuthorizationDetailedVO;
    }

    public void revoke(Long l) throws FrameworkException {
        OidcAuthorization oidcAuthorization = this.find(OidcAuthorization.class, l);
        this.entityManagerHandler.remove((IEntity)oidcAuthorization);
    }

    public Page<OidcAuthorizationVO> search(OidcAuthorizationQuery oidcAuthorizationQuery) throws FrameworkException {
        OidcClient oidcClient;
        Set set;
        Set set2;
        User user;
        SessionData sessionData = this.getSessionData();
        DBQuery<?> dBQuery = this.from(new EntityPath[]{$});
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)oidcAuthorizationQuery.getConsentBy());
        if (basicUser != null) {
            dBQuery.where((Predicate)$.basicUser().eq((Object)basicUser));
        }
        if (oidcAuthorizationQuery.isOperatorsOnly()) {
            dBQuery.where((Predicate)$.basicUser().instanceOf(Operator.class));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)oidcAuthorizationQuery.getUser())) != null) {
            dBQuery.where((Predicate)$.user().eq((Object)user));
        }
        if (!(set2 = this.groupsHandler.flattenVOs((Collection)oidcAuthorizationQuery.getGroups())).isEmpty()) {
            dBQuery.where((Predicate)$.user().group().in((Collection)set2));
        }
        if (!(set = this.conversionHandler.convertSet(User.class, (Iterable)oidcAuthorizationQuery.getBrokers())).isEmpty()) {
            dBQuery.where((Predicate)((QUser)OidcAuthorizationServiceImpl.$.user().brokers.any()).in((Collection)set));
        }
        this.visibility(dBQuery, $.user()).onlySelf();
        if (sessionData.isUserManager() && !sessionData.hasPermission(Permission.USER_OPERATORS_VIEW)) {
            dBQuery.where((Predicate)$.basicUser().instanceOf(User.class));
        }
        if ((oidcClient = (OidcClient)this.conversionHandler.convert(OidcClient.class, (Object)oidcAuthorizationQuery.getClient())) != null) {
            dBQuery.where((Predicate)$.client().eq((Object)oidcClient));
        }
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)oidcAuthorizationQuery.getConsentPeriod());
        dBQuery.where(OidcAuthorizationServiceImpl.$.consentDate.period(datePeriod));
        DatePeriod datePeriod2 = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)oidcAuthorizationQuery.getConsentPeriod());
        dBQuery.where(OidcAuthorizationServiceImpl.$.expirationDate.period(datePeriod2));
        dBQuery.where((Predicate)OidcAuthorizationServiceImpl.$.refreshToken.isNotNull().or(OidcAuthorizationServiceImpl.$.expirationDate.future()));
        dBQuery.where((Predicate)OidcAuthorizationServiceImpl.$.oidcOnly.isNull().or((Predicate)OidcAuthorizationServiceImpl.$.oidcOnly.isFalse()));
        dBQuery.orderBy(OidcAuthorizationServiceImpl.$.consentDate.desc());
        return dBQuery.page(OidcAuthorizationVO.class, (QueryParameters)oidcAuthorizationQuery, (Expression)$);
    }

    public ScopeVO toScopeVO(Scope scope, OidcAuthorization oidcAuthorization) {
        ScopeVO scopeVO = new ScopeVO();
        scopeVO.setScope(scope);
        scopeVO.setDisplay(this.scopeDisplay(scope, oidcAuthorization));
        return scopeVO;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.client().network());
        networkPathRegistry.register(QOidcAccessToken.oidcAccessToken.authorization().client().network());
    }

    private String scopeDisplay(Scope scope, OidcAuthorization oidcAuthorization) {
        switch (scope) {
            case ACCOUNT_HISTORY: {
                if (oidcAuthorization.getGrantedAccountType() == null) {
                    return this.message(AccessKeys.OidcConsent.SCOPE_ACCOUNT_HISTORY, new Object[0]);
                }
                return this.message(AccessKeys.OidcConsent.SCOPE_ACCOUNT_HISTORY_SPECIFIC, oidcAuthorization.getGrantedAccountType());
            }
            case ACCOUNT_STATUS: {
                if (oidcAuthorization.getGrantedAccountType() == null) {
                    return this.message(AccessKeys.OidcConsent.SCOPE_ACCOUNT_STATUS, new Object[0]);
                }
                return this.message(AccessKeys.OidcConsent.SCOPE_ACCOUNT_STATUS_SPECIFIC, oidcAuthorization.getGrantedAccountType());
            }
            case PAYMENT: {
                if (oidcAuthorization.getPaymentTo() != null && oidcAuthorization.getPaymentAmount() != null) {
                    return this.message(AccessKeys.OidcConsent.SCOPE_PAYMENT_SPECIFIC, oidcAuthorization.getPaymentAmount(), oidcAuthorization.getPaymentTo());
                }
                if (this.isSinglePayment(oidcAuthorization)) {
                    return this.message(AccessKeys.OidcConsent.SCOPE_PAYMENT_SINGLE, new Object[0]);
                }
                return this.message(AccessKeys.OidcConsent.SCOPE_PAYMENT, new Object[0]);
            }
            case OFFLINE_ACCESS: 
            case OPENID: {
                break;
            }
            default: {
                return this.message(scope.getMessageKey(), new Object[0]);
            }
        }
        return "";
    }
}

