/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QAccessLog;
import org.cyclos.entities.users.QUserLoginStats;
import org.cyclos.entities.users.UserLoginStats;
import org.cyclos.entities.utils.DateRange;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.StatefulUserSessionData;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.CaptchaInputDTO;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.LoginConfirmationField;
import org.cyclos.model.access.LoginData;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
extends BaseServiceImpl
implements LoginServiceLocal {
    private static final QAccessLog al = QAccessLog.accessLog;
    private static final QUserLoginStats uls = QUserLoginStats.userLoginStats;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private PinServiceLocal pinService;

    public void confirmLogin(String string) {
        this.sessionHandler.confirmLogin(string);
    }

    public UserAuthVO getAuthenticatedUser() throws FrameworkException {
        return this.getSessionData().getAuthenticatedUser();
    }

    public DateRange getFirstAndLastLogin(BasicUser basicUser) {
        Date date;
        UserLoginStats userLoginStats;
        UserLoginStats userLoginStats2 = userLoginStats = basicUser == null ? null : (UserLoginStats)((DBQuery)this.entityManagerHandler.selectFrom((EntityPath)uls).where((Predicate)uls.user().eq((Object)basicUser))).fetchFirst();
        if (userLoginStats == null) {
            return null;
        }
        SessionData sessionData = this.getSessionData();
        Session session = sessionData.getSession();
        if (session != null && session.getUser().equals((Object)basicUser) && (date = (Date)((DBQuery)this.from(new EntityPath[]{al}).where(new Predicate[]{al.user().eq((Object)basicUser), LoginServiceImpl.al.date.before((Comparable)session.getCreationDate())})).singleResult((Expression)LoginServiceImpl.al.date.max())) != null) {
            return new DateRange(userLoginStats.getFirstLogin(), date);
        }
        return new DateRange(userLoginStats.getFirstLogin(), userLoginStats.getLastLogin());
    }

    public CredentialInputDTO getLoginConfirmationCredentialInput() throws FrameworkException {
        return this.passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION).getCredentialInput();
    }

    public LoginData getLoginData(Channel channel, Long l, PinLocatorVO pinLocatorVO) {
        Pair pair;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
        if (channelConfiguration == null || !channelConfiguration.isEnabled()) {
            throw new InaccessibleChannelException();
        }
        if (!channelConfiguration.isAllowLogin()) {
            return null;
        }
        List list = this.principalTypeService.listForLogin(channelConfiguration);
        PrincipalType principalType = channelConfiguration.getDefaultPrincipalType();
        PasswordType passwordType = channelConfiguration.getAccessPassword();
        CredentialInputDTO credentialInputDTO = null;
        if (passwordType != null) {
            credentialInputDTO = this.passwordHandler.getCredentialInput((ChannelAccessAccessor)channelConfiguration, CredentialUsage.ACCESS, sessionData.getLoggedBasicUser());
        }
        LoginData loginData = new LoginData();
        if (l != null && this.trustedDeviceService.exists(l.longValue())) {
            pair = (DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)this.deviceConfirmationService.create(LoginConfirmationField.confirmation()));
            loginData.setDeviceConfirmation((DeviceConfirmationVO)pair);
        }
        if (pinLocatorVO != null) {
            pair = this.pinService.getIfActive(pinLocatorVO, sessionData.getChannel());
            loginData.setPinActive(Boolean.valueOf(pair != null));
            if (pair != null) {
                credentialInputDTO.setPinInput(this.passwordHandler.toPinInput((ChannelAccessAccessor)pair.getSecond()));
            }
        }
        loginData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, (Iterable)list));
        loginData.setDefaultPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType));
        loginData.setIdentityProviders(sessionData.getChannelAccessAccessor().getIdentityProviders().stream().filter(IdentityProvider::isEnabled).sorted().map(this.conversionHandler.convertingFunction(IdentityProviderVO.class, new Object[0])).collect(Collectors.toList()));
        loginData.setLoginPasswordInput(credentialInputDTO);
        loginData.setAccessPasswordType((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
        pair = (ForgotPasswordMode)ObjectHelper.defaultValue((Object)configurationAccessor.getForgotPasswordMode(), (Object)ForgotPasswordMode.DISABLED);
        loginData.setForgotPasswordMode((ForgotPasswordMode)pair);
        if (pair.showForgotPassword()) {
            EnumSet<SendMedium> enumSet;
            OutboundSmsConfiguration outboundSmsConfiguration;
            boolean bl;
            CaptchaConfiguration captchaConfiguration = configurationAccessor.getCaptchaConfiguration();
            if (captchaConfiguration.isUseOnForgotPassword()) {
                loginData.setForgotPasswordCaptchaInput((CaptchaInputDTO)this.conversionHandler.convert(CaptchaInputDTO.class, (Object)captchaConfiguration));
            }
            BuiltInPrincipalType builtInPrincipalType = configurationAccessor.isEmailUnique() ? this.principalTypeService.getEmail() : null;
            BuiltInPrincipalType builtInPrincipalType2 = configurationAccessor.isMobileUnique() && configurationAccessor.getOutboundSmsConfiguration() != null && configurationAccessor.getOutboundSmsConfiguration().isEnabled() ? this.principalTypeService.getMobilePhone() : null;
            SendMedium sendMedium = configurationAccessor.getForgotPasswordSendMedium();
            ArrayList<BuiltInPrincipalType> arrayList = new ArrayList<BuiltInPrincipalType>(list);
            PrincipalType principalType2 = principalType;
            if (sendMedium != SendMedium.SMS && builtInPrincipalType != null && !list.contains(builtInPrincipalType)) {
                bl = list.size() == 1;
                arrayList.add(builtInPrincipalType);
                Collections.sort(list);
                if (bl) {
                    principalType2 = null;
                }
            }
            if (sendMedium != SendMedium.EMAIL && builtInPrincipalType2 != null && !list.contains(builtInPrincipalType2) && configurationAccessor.isMobileUnique()) {
                bl = list.size() == 1;
                arrayList.add(builtInPrincipalType2);
                Collections.sort(list);
                if (bl) {
                    principalType2 = null;
                }
            }
            if ((outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration()) == null || !outboundSmsConfiguration.isEnabled()) {
                enumSet = EnumSet.of(SendMedium.EMAIL);
            } else {
                enumSet = EnumSet.allOf(SendMedium.class);
                enumSet.removeIf(sendMedium2 -> sendMedium != null && sendMedium != sendMedium2);
            }
            loginData.setForgotPasswordSendMediums(new ArrayList<SendMedium>(enumSet));
            loginData.setForgotPasswordPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, arrayList));
            loginData.setDefaultForgotPasswordPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType2));
        }
        return loginData;
    }

    public LoginData getLoginData(String string, Long l, PinLocatorVO pinLocatorVO) {
        Channel channel = this.channelService.load(string);
        return this.getLoginData(channel, l, pinLocatorVO);
    }

    public void removeAllLogs(BasicUser basicUser) {
        this.entityManagerHandler.delete((EntityPath)al).where(new Predicate[]{al.user().eq((Object)basicUser)}).execute();
    }

    public String replaceSession() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        Session session = sessionData.getSession();
        if (session != null && session.isPersistent()) {
            String string = this.sessionHandler.replace(session);
            sessionData.ifWraps(StatefulUserSessionData.class, statefulUserSessionData -> statefulUserSessionData.replaceSessionToken(string));
            return string;
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

