/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.Expression;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OAuthIdentityProvider;
import org.cyclos.entities.access.OidcIdentityProvider;
import org.cyclos.entities.access.QIdentityProvider;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.IdentityProviderImage;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.IdentityProviderImageServiceLocal;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.identityproviders.IdentityProviderDTO;
import org.cyclos.model.access.identityproviders.IdentityProviderData;
import org.cyclos.model.access.identityproviders.IdentityProviderType;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.identityproviders.OAuthIdentityProviderDTO;
import org.cyclos.model.access.identityproviders.OidcIdentityProviderDTO;
import org.cyclos.model.access.oidcclients.OidcClientDTO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IdentityProviderServiceImpl
extends CRUDServiceImpl<IdentityProvider, QIdentityProvider, IdentityProviderDTO, IdentityProviderData, IdentityProviderType>
implements IdentityProviderServiceLocal {
    private static final BidiMap<Class<? extends IdentityProvider>, Class<? extends IdentityProviderDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Object[] EXCLUDED_PROPERTIES;
    @Autowired
    private TempImageServiceLocal tempImageService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private IdentityProviderImageServiceLocal identityProviderImageService;
    @Autowired
    @Lazy
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public IdentityProviderServiceImpl() {
        super(IdentityProvider.class, QIdentityProvider.identityProvider, IdentityProviderDTO.class);
    }

    public List<IdentityProviderVO> list() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QIdentityProvider)this.$).order.asc())).list(IdentityProviderVO.class, (Expression)this.$);
    }

    public List<IdentityProvider> listEnabled(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        HashSet hashSet = new HashSet();
        for (Channel channel : this.userChannelService.getAccessibleChannels(basicUser)) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            if (channelConfiguration == null || !channelConfiguration.isEnabled()) continue;
            hashSet.addAll(channelConfiguration.getIdentityProviders());
        }
        return hashSet.stream().filter(identityProvider -> {
            if (!identityProvider.isEnabled()) {
                return false;
            }
            if (basicUser.isGlobal()) {
                return identityProvider.isGlobal();
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    @Override
    public IdentityProvider newEntity(IdentityProviderType identityProviderType) {
        OAuthIdentityProvider oAuthIdentityProvider = null;
        switch (identityProviderType.getProtocol()) {
            case OAUTH: {
                oAuthIdentityProvider = new OAuthIdentityProvider();
                break;
            }
            case OIDC: {
                oAuthIdentityProvider = new OidcIdentityProvider();
            }
        }
        if (oAuthIdentityProvider == null) {
            throw new IllegalStateException("Unhandled identity provider type: " + String.valueOf(identityProviderType));
        }
        oAuthIdentityProvider.setEnabled(true);
        oAuthIdentityProvider.setType(identityProviderType);
        oAuthIdentityProvider.setBackgroundColor(identityProviderType.getBackgroundColor());
        oAuthIdentityProvider.setBorderColor(identityProviderType.getBorderColor());
        oAuthIdentityProvider.setTextColor(identityProviderType.getTextColor());
        if (identityProviderType != IdentityProviderType.OIDC) {
            String string = this.message(identityProviderType.getMessageKey(), new Object[0]);
            String string2 = StringHelper.camelize((String)identityProviderType.name());
            oAuthIdentityProvider.setName(string);
            oAuthIdentityProvider.setInternalName(string2);
            TempImage tempImage = (TempImage)this.invokerHandler.runAsInCurrentOrNewTransaction(this.getSessionData(), TransactionLevel.READ_WRITE, transactionStatus -> {
                InputStream inputStream;
                NewTempImageParams newTempImageParams = new NewTempImageParams();
                newTempImageParams.setTarget(TempImageTarget.IDENTITY_PROVIDER);
                try {
                    inputStream = ResourceHelper.openStream((String)("/identityProviderImages/" + string2 + ".png"));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error reading the default image for identity provider " + string2, iOException);
                }
                ImageVO imageVO = this.tempImageService.save((Object)newTempImageParams, string, new SerializableInputStream(inputStream), "image/png");
                return this.find(TempImage.class, imageVO.getId());
            });
            oAuthIdentityProvider.setUploadedImage(tempImage);
        }
        return oAuthIdentityProvider;
    }

    @Override
    public IdentityProviderDTO toDTO(IdentityProvider identityProvider) {
        IdentityProviderDTO identityProviderDTO = (IdentityProviderDTO)super.toDTO(identityProvider);
        if (identityProvider.isTransient() && identityProvider.getUploadedImage() != null) {
            identityProviderDTO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)identityProvider.getUploadedImage()));
        }
        return identityProviderDTO;
    }

    @Override
    public IdentityProvider toEntity(IdentityProviderDTO identityProviderDTO) {
        Image image;
        if (identityProviderDTO.getImage() == null && identityProviderDTO.isPersistent()) {
            this.identityProviderImageService.removeAll((BaseEntity)((IdentityProvider)this.find(identityProviderDTO.getId())));
        }
        IdentityProvider identityProvider = (IdentityProvider)super.toEntity(identityProviderDTO);
        if (identityProviderDTO.getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)identityProviderDTO.getImage())) instanceof TempImage) {
            identityProvider.setUploadedImage((TempImage)image);
        }
        return identityProvider;
    }

    @Override
    protected IdentityProviderData getData(IdentityProvider identityProvider) {
        IdentityProviderData identityProviderData = new IdentityProviderData();
        identityProviderData.setType(identityProvider.getType());
        identityProviderData.setDto((EntityDTO)this.toDTO(identityProvider));
        identityProviderData.setCallbackUrl(this.linkGeneratorHandler.identityProviderCallback(identityProvider));
        return identityProviderData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(IdentityProviderDTO identityProviderDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(IdentityProviderDTO identityProviderDTO) {
        return null;
    }

    @Override
    protected boolean isEntityInternalNameRequired(IdentityProviderDTO identityProviderDTO) {
        return true;
    }

    @Override
    protected void onAfterSave(IdentityProvider identityProvider, IdentityProvider identityProvider2, Object object) {
        TempImage tempImage = identityProvider.getUploadedImage();
        if (tempImage != null) {
            this.identityProviderImageService.importTempImage((BaseEntity)identityProvider, tempImage);
        }
    }

    @Override
    protected void onBeforeRemove(IdentityProvider identityProvider) {
        CollectionHelper.orEmpty((List)identityProvider.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    @Override
    protected Object onBeforeSave(IdentityProvider identityProvider, IdentityProvider identityProvider2) {
        OidcIdentityProvider oidcIdentityProvider;
        IdentityProviderType identityProviderType;
        if (identityProvider instanceof OidcIdentityProvider && (identityProviderType = (oidcIdentityProvider = (OidcIdentityProvider)identityProvider).getType()).getDiscoveryUrl() != null) {
            oidcIdentityProvider.setDiscoveryUrl(null);
        }
        if (identityProvider.isTransient()) {
            identityProvider.setOrder(Integer.valueOf((Integer)ObjectHelper.defaultValue((Object)((Integer)this.from().singleResult((Expression)((QIdentityProvider)this.$).order.max())), (Object)0) + 1));
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QIdentityProvider)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(final IdentityProviderDTO identityProviderDTO) {
        IdentityProvider identityProvider;
        IdentityProviderType identityProviderType;
        Validator validator = new Validator();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)IdentityProviderDTO.TYPE, AccessKeys.IdentityProviders.TYPE);
        if (identityProviderDTO.isTransient()) {
            property.required();
            identityProviderType = identityProviderDTO.getType();
        } else {
            identityProvider = (IdentityProvider)this.find(identityProviderDTO.getId());
            identityProviderType = identityProvider.getType();
            if (identityProviderDTO.getType() != null && identityProviderDTO.getType() != identityProviderType) {
                property.invalid();
            }
        }
        if (identityProviderDTO instanceof OAuthIdentityProviderDTO) {
            validator.property((Property)OAuthIdentityProviderDTO.CLIENT_ID, AccessKeys.IdentityProviders.CLIENT_ID).required();
            validator.property((Property)OAuthIdentityProviderDTO.CLIENT_SECRET, AccessKeys.IdentityProviders.CLIENT_SECRET).required();
            if (identityProviderDTO instanceof OidcIdentityProviderDTO) {
                identityProvider = validator.property((Property)OidcIdentityProviderDTO.DISCOVERY_URL, AccessKeys.IdentityProviders.DISCOVERY_URL);
                if (identityProviderType.getDiscoveryUrl() == null) {
                    identityProvider.required().url().maxLength(255);
                } else if (!identityProviderType.getDiscoveryUrl().equals(((OidcIdentityProviderDTO)identityProviderDTO).getDiscoveryUrl())) {
                    identityProvider.invalid();
                }
            }
        }
        validator.property((Property)IdentityProviderDTO.BACKGROUND_COLOR, AccessKeys.IdentityProviders.BACKGROUND_COLOR).required().color();
        validator.property((Property)IdentityProviderDTO.BORDER_COLOR, AccessKeys.IdentityProviders.BORDER_COLOR).required().color();
        validator.property((Property)IdentityProviderDTO.TEXT_COLOR, AccessKeys.IdentityProviders.TEXT_COLOR).required().color();
        validator.property((Property)IdentityProviderDTO.IMAGE, AccessKeys.IdentityProviders.IMAGE).entity(Image.class, (EntityValidation)new BaseEntityValidation<Image>(){

            protected boolean isValid(Object object, Object object2, Image image) {
                if (image instanceof TempImage) {
                    TempImage tempImage = (TempImage)image;
                    return tempImage.getTarget() == TempImageTarget.IDENTITY_PROVIDER;
                }
                if (image instanceof IdentityProviderImage) {
                    IdentityProviderImage identityProviderImage = (IdentityProviderImage)image;
                    return identityProviderImage.getCategory().getId().equals(identityProviderDTO.getId());
                }
                return false;
            }
        });
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends IdentityProvider>, Class<? extends IdentityProviderDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    static {
        SUBCLASS_MAPPINGS.put(OAuthIdentityProvider.class, OAuthIdentityProviderDTO.class);
        SUBCLASS_MAPPINGS.put(OidcIdentityProvider.class, OidcIdentityProviderDTO.class);
        EXCLUDED_PROPERTIES = new Object[]{OidcClientDTO.IMAGE};
    }
}

