/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.EntityCheckRegistry;
import org.springframework.stereotype.Component;

@Component
public class EntityCheckRegistryImpl
implements EntityCheckRegistry {
    private ConcurrentMap<Class<?>, EntityCheck<?>> registry = new ConcurrentHashMap();

    public <E extends SimpleEntity> EntityCheck<? super E> get(Class<E> clazz) {
        EntityCheck entityCheck = null;
        Class<E> clazz2 = clazz;
        while (entityCheck == null && !SimpleEntity.class.equals(clazz2)) {
            entityCheck = (EntityCheck)this.registry.get(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return entityCheck;
    }

    public <E extends SimpleEntity> void register(EntityCheck<E> entityCheck) {
        if (this.registry.putIfAbsent(entityCheck.getEntityType(), entityCheck) != null) {
            throw new IllegalStateException("There is already an EntityCheck for " + String.valueOf(entityCheck.getEntityType()));
        }
    }
}

