/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationAccessorInvocationHandlerImpl;
import org.cyclos.impl.system.ConfigurationAccessorStorageKey;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.LocalStorageType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.Property;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationHandlerImpl
extends BaseNetworkedHandlerImpl
implements ConfigurationHandler {
    private static final Set<String> CONFIGURABLE_PROPERTIES = ConfigurationHandlerImpl.initConfigurableProperties();
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    private LocalStorage<ConfigurationAccessorStorageKey, ConfigurationAccessor> accessorsLocalStorage;

    private static final Set<String> initConfigurableProperties() {
        List<Property> list = Arrays.asList(ConfigurationDTO.ID, ConfigurationDTO.NAME, ConfigurationDTO.INTERNAL_NAME, ConfigurationDTO.DESCRIPTION, ConfigurationDTO.PARENT, ConfigurationDTO.DEFINE_ROOT_URL, ConfigurationDTO.ROOT_URL, ConfigurationDTO.PATH, ConfigurationDTO.DEFINED_PROPERTIES, ConfigurationDTO.LOCKED_PROPERTIES);
        HashSet<String> hashSet = new HashSet<String>();
        for (Property property : new ConfigurationDTO().properties()) {
            if (list.contains(property)) continue;
            hashSet.add(property.getName());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public ConfigurationAccessor getAccessAccessor(BasicUser basicUser) {
        if (basicUser == null) {
            return this.getSessionData().getConfiguration();
        }
        return this.getAccessor(basicUser, false);
    }

    public ConfigurationAccessor getAccessor(BasicGroup basicGroup) {
        Configuration configuration = this.getConfiguration(basicGroup);
        return this.getAccessor(configuration);
    }

    public ConfigurationAccessor getAccessor(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (basicUser == null) {
            return sessionData.getConfiguration();
        }
        if (basicUser.isPersistent() && basicUser.isGlobal() && sessionData.getNetwork() != null) {
            return this.getAccessor(sessionData.getNetwork());
        }
        if (basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
            return sessionData.getConfiguration();
        }
        return this.getAccessor(basicUser, false);
    }

    public ConfigurationAccessor getAccessor(Configuration configuration) {
        return this.getAccessor(configuration, null);
    }

    public ConfigurationAccessor getAccessor(Configuration configuration, List<String> list) {
        return this.getAccessor(configuration, list, true);
    }

    public ConfigurationAccessor getAccessor(Configuration configuration, List<String> list, boolean bl) {
        List list2;
        Object object;
        if (configuration == null && (configuration = this.getDefault()) == null) {
            return null;
        }
        Set set = null;
        if (bl && (object = this.getLoggedUser()) != null && object.isGlobal() && !configuration.isGlobal()) {
            list2 = this.getConfiguration((BasicGroup)object.getGroup());
            Long l = SimpleEntity.id((SimpleEntity)list2.getNetwork());
            List list3 = SimpleEntity.ids(this.getAncestors((Configuration)list2));
            ConfigurationAccessor configurationAccessor = this.getAccessor(l, list3, null, null);
            Set set2 = configurationAccessor.getAllowedLanguages();
            set2.add(configurationAccessor.getLanguage());
            set = SimpleEntity.uniqueIds((Collection)set2);
        }
        object = SimpleEntity.id((SimpleEntity)configuration.getNetwork());
        list2 = SimpleEntity.ids(this.getAncestors(configuration));
        return this.getAccessor((Long)object, list2, set, list);
    }

    public ConfigurationAccessor getAccessor(IAccount iAccount) {
        InternalAccountOwner internalAccountOwner = iAccount.getOwner();
        if (internalAccountOwner instanceof User) {
            return this.getAccessor((BasicUser)((User)internalAccountOwner));
        }
        if (iAccount.isGlobal()) {
            return this.configurationHandler.getAccessor(this.configurationHandler.getGlobalDefault());
        }
        Configuration configuration = iAccount.getNetwork().getDefaultConfiguration();
        return this.configurationHandler.getAccessor(configuration);
    }

    public ConfigurationAccessor getAccessor(Network network) {
        Configuration configuration = network == null ? this.getGlobalDefault() : network.getDefaultConfiguration();
        return this.getAccessor(configuration);
    }

    public List<Configuration> getAncestors(Configuration configuration) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        while (configuration != null) {
            arrayList.add(configuration);
            configuration = configuration.getParent();
        }
        return arrayList;
    }

    public Set<String> getConfigurableProperties() {
        return CONFIGURABLE_PROPERTIES;
    }

    public Configuration getDefault() {
        Network network = this.getSessionData().getNetwork();
        if (network != null) {
            return network.getDefaultConfiguration();
        }
        return this.getGlobalDefault();
    }

    public ConfigurationAccessor getDefaultAccessor() {
        return this.getAccessor(this.getDefault());
    }

    public Configuration getForGroup(BasicGroup basicGroup) {
        GroupSet groupSet;
        Configuration configuration = null;
        if (basicGroup != null && basicGroup.getConfiguration() != null) {
            configuration = basicGroup.getConfiguration();
        }
        if (configuration == null && basicGroup instanceof UserGroup && (groupSet = ((UserGroup)basicGroup).getGroupSet()) != null) {
            configuration = groupSet.getConfiguration();
        }
        if (configuration == null) {
            configuration = this.getDefault();
        }
        return configuration;
    }

    public Configuration getGlobalDefault() {
        QConfiguration qConfiguration = QConfiguration.configuration;
        return (Configuration)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).where((Predicate)qConfiguration.defaultType.eq((Object)DefaultConfigurationType.GLOBAL))).singleResult((Expression)qConfiguration);
    }

    private ConfigurationAccessor getAccessor(BasicUser basicUser, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl ? this.getSessionData().getLoggedBasicUser().equals((Object)basicUser) : false;
        if (bl && !bl2) {
            throw new IllegalArgumentException("Invalid user parameter: the only allowed value is the current logged user. See getAcessor(BasicUser) method");
        }
        if (bl) {
            return this.getAccessor(basicUser);
        }
        Configuration configuration = this.getConfiguration((BasicGroup)basicUser.getUser().getGroup());
        String string = basicUser.getLocale();
        return this.getAccessor(configuration, string == null ? null : Collections.singletonList(string));
    }

    private ConfigurationAccessor getAccessor(Long l, List<Long> list, Set<Long> set, List<String> list2) {
        ConfigurationAccessorStorageKey configurationAccessorStorageKey = new ConfigurationAccessorStorageKey(l, list, set, list2);
        return (ConfigurationAccessor)this.accessorsLocalStorage.get((Object)configurationAccessorStorageKey, () -> ConfigurationAccessorInvocationHandlerImpl.newAccessor(this.getApplicationContext(), l, list, set, list2));
    }

    private Configuration getConfiguration(BasicGroup basicGroup) {
        Network network;
        Configuration configuration = basicGroup.getConfiguration();
        if (configuration == null && basicGroup instanceof UserGroup && (network = ((UserGroup)basicGroup).getGroupSet()) != null) {
            configuration = network.getConfiguration();
        }
        if (configuration == null) {
            network = basicGroup.getNetwork();
            configuration = network == null ? this.getGlobalDefault() : network.getDefaultConfiguration();
        }
        return configuration;
    }

    @PostConstruct
    private void initialize() {
        this.accessorsLocalStorage = this.clusterHandler.getLocalStorage(LocalStorageType.CONFIGURATION_ACCESSORS);
    }
}

