/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.GeneralPermissionCheckImpl;
import org.cyclos.impl.access.PermissionCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.access.UserPermissionCheckImpl;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductConversionHandler;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.UserRelationship;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthHandlerImpl
extends BaseNetworkedHandlerImpl
implements AuthHandler {
    @Autowired
    private Collection<ProductConversionHandler<?, ?, ?>> productConverters;
    private Map<Permission, String> collectionProperties;

    public UserRelationship getRelationship(BasicUser basicUser, BasicUser basicUser2) {
        if (basicUser == null || basicUser2 == null) {
            return null;
        }
        if (basicUser.equals((Object)basicUser2)) {
            return UserRelationship.SELF;
        }
        if (basicUser.isAdmin()) {
            return this.isAdminOf(basicUser.getUser(), basicUser2) ? UserRelationship.ADMINISTRATOR : UserRelationship.NONE;
        }
        if (basicUser.isBroker() && this.isBrokerOf((BasicUser)basicUser.getUser(), basicUser2)) {
            return UserRelationship.BROKER;
        }
        if (basicUser2.isOperator()) {
            Operator operator = (Operator)basicUser2;
            if (basicUser.equals((Object)operator.getUser())) {
                return UserRelationship.OWNER;
            }
            if (basicUser.isOperator() && basicUser.getUser().equals((Object)operator.getUser())) {
                return UserRelationship.SAME_OWNER;
            }
            return UserRelationship.NONE;
        }
        User user = (User)basicUser2;
        if (this.isBrokerOf((BasicUser)user, basicUser)) {
            return UserRelationship.BROKERED;
        }
        return UserRelationship.NONE;
    }

    public Collection<?> getRequiredValues(Permission permission) {
        SessionData sessionData = this.getSessionData();
        switch (permission) {
            case SPECIFIC_NETWORKS_MANAGE: {
                if (sessionData.isGlobalAdmin()) {
                    return null;
                }
                if (!sessionData.isAdmin()) {
                    return Collections.emptySet();
                }
                AdminGroup adminGroup = (AdminGroup)sessionData.getLoggedBasicUser().getUser().getGroup();
                return adminGroup.getManagedNetworks();
            }
            case USERS_REGISTER: {
                if (sessionData.isMember()) {
                    return sessionData.getProducts().memberOrBroker().getUserRegistrationGroups();
                }
                if (sessionData.isAdmin() || sessionData.isSystem()) {
                    return this.groupsHandler.accessibles().groups().items();
                }
                return Collections.emptySet();
            }
        }
        return this.doGetRequiredValues(sessionData, permission);
    }

    @Override
    public boolean hasValue(Permission permission, Object ... objectArray) {
        return super.hasValue(permission, objectArray);
    }

    @PostConstruct
    public void initialize() {
        this.collectionProperties = new HashMap<Permission, String>();
        for (Permission permission : Permission.values()) {
            String string = null;
            for (ProductConversionHandler<?, ?, ?> productConversionHandler : this.productConverters) {
                if (!permission.getRoles().contains(productConversionHandler.getRole())) continue;
                Property property = productConversionHandler.getDtoCollectionProperty(permission);
                if (property != null) {
                    string = productConversionHandler.getProductPropertyForDtoProperty(property);
                    break;
                }
                if (string != null || (string = productConversionHandler.getAdditionalCollectionForPermission(permission)) == null) continue;
                break;
            }
            this.collectionProperties.put(permission, string);
        }
    }

    public boolean isAdminOf(User user, BasicUser basicUser) {
        Network network;
        if (user == null || basicUser == null || !user.isAdmin() || user.equals((Object)basicUser)) {
            return false;
        }
        AdminGroup adminGroup = (AdminGroup)user.getGroup();
        if (user.isGlobal() && !basicUser.isGlobal()) {
            boolean bl;
            network = basicUser.getNetwork();
            boolean bl2 = bl = adminGroup.getAdminType() != null || adminGroup.getManagedNetworks().contains(network);
            if (!bl) {
                return false;
            }
            adminGroup = network.getAdministrators();
        } else if (!user.isGlobal() && basicUser.isGlobal() || !Objects.equals(user.getNetwork(), basicUser.getNetwork())) {
            return false;
        }
        network = basicUser.getUser();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (network.isAdmin()) {
            AdminGroupAccessibility adminGroupAccessibility = (AdminGroupAccessibility)ObjectHelper.defaultValue((Object)productsAccessor.admin().getAdminGroupAccessibility(), (Object)AdminGroupAccessibility.NONE);
            switch (adminGroupAccessibility) {
                case NONE: {
                    return false;
                }
                case SPECIFIC: {
                    return productsAccessor.admin().getAccessibleAdminGroups().contains(network.getGroup());
                }
                case ALL: {
                    return true;
                }
            }
        } else {
            List list = productsAccessor.product().getUserGroupAccessibility();
            if (list.contains(UserGroupAccessibility.ALL)) {
                return true;
            }
            if (list.contains(UserGroupAccessibility.SPECIFIC)) {
                UserGroup userGroup = (UserGroup)network.getGroup();
                List list2 = productsAccessor.product().getAccessibleUserGroups();
                return list2.contains(userGroup) || list2.contains(userGroup.getGroupSet());
            }
        }
        return false;
    }

    public boolean isBrokerOf(BasicUser basicUser, BasicUser basicUser2) {
        if (basicUser2 == null || basicUser == null || !basicUser.isBroker() || basicUser.getUser().equals((Object)basicUser2.getUser())) {
            return false;
        }
        if (basicUser2 instanceof User && basicUser2.isTransient()) {
            return true;
        }
        return basicUser2.getUser().getBrokers().contains(basicUser.getUser());
    }

    public boolean manages(BasicUser basicUser, BasicUser basicUser2) {
        if (basicUser == null || basicUser2 == null) {
            return false;
        }
        if (basicUser2.isTransient() || basicUser.equals((Object)basicUser2)) {
            return true;
        }
        User user = basicUser.getUser();
        if (basicUser instanceof Operator) {
            Operator operator = (Operator)basicUser;
            if (operator.isAliasOperator() || operator.getGroup().isBrokering()) {
                return this.manages((BasicUser)operator.getUser(), basicUser2);
            }
            return user.equals((Object)basicUser2) || operator.isBroker() && basicUser2.isMember() && this.isBrokerOf((BasicUser)operator.getUser(), basicUser2);
        }
        User user2 = basicUser2.getUser();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        if (basicUser2 instanceof Operator) {
            boolean bl = user.equals((Object)user2);
            Permission permission = bl ? Permission.MY_OPERATORS_MANAGE_OPERATORS : Permission.USER_OPERATORS_MANAGE;
            return productsAccessor.product().hasPermission(permission) && this.manages(basicUser, (BasicUser)user2);
        }
        switch (user2.getStatus()) {
            case ACTIVE: 
            case BLOCKED: {
                break;
            }
            case DISABLED: {
                if (productsAccessor.product().hasPermission(Permission.DISABLED_USERS_VIEW)) break;
                return false;
            }
            case PENDING: {
                if (productsAccessor.product().hasPermission(Permission.PENDING_USERS_VIEW)) break;
                return false;
            }
            case REMOVED: {
                if (productsAccessor.product().hasPermission(Permission.REMOVED_USERS_VIEW)) break;
                return false;
            }
            case PURGED: {
                if (productsAccessor.product().hasPermission(Permission.PURGED_USERS_VIEW)) break;
                return false;
            }
        }
        return this.isAdminOf(user, basicUser2) || this.isBrokerOf((BasicUser)user, basicUser2);
    }

    @Override
    public UserPermissionCheck permission(BasicUser basicUser) {
        return new UserPermissionCheckImpl(false, this, this.getSessionData(), basicUser);
    }

    @Override
    public PermissionCheck permission(Permission permission) {
        return new GeneralPermissionCheckImpl(false, true, this, this.getSessionData(), permission);
    }

    public UserPermissionCheck permissionOptionalValue(BasicUser basicUser) {
        return new UserPermissionCheckImpl(true, this, this.getSessionData(), basicUser);
    }

    @Override
    public PermissionCheck permissionOptionalValue(Permission permission) {
        return new GeneralPermissionCheckImpl(true, false, this, this.getSessionData(), permission);
    }

    public boolean relatesTo(BasicUser basicUser, BasicUser basicUser2) {
        if (basicUser == null || basicUser2 == null) {
            return false;
        }
        if (basicUser.equals((Object)basicUser2.getRegisteredBy())) {
            return true;
        }
        if (this.manages(basicUser, basicUser2)) {
            return true;
        }
        if (!this.validNetwork(basicUser, basicUser2)) {
            return false;
        }
        User user = basicUser.getUser();
        Group group = user.getGroup();
        GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        ProductAccessor productAccessor = productsAccessor.product();
        if (basicUser2 instanceof User) {
            List list;
            GroupSet groupSet2;
            User user2 = (User)basicUser2;
            Group group2 = user2.getGroup();
            GroupSet groupSet3 = groupSet2 = group2 instanceof UserGroup ? ((UserGroup)group2).getGroupSet() : null;
            if (!user2.isActive() && !user2.isBlocked()) {
                return false;
            }
            if (user2.isAdmin()) {
                if (!user.isAdmin()) {
                    return false;
                }
                AdminProductAccessor adminProductAccessor = productsAccessor.admin();
                AdminGroupAccessibility adminGroupAccessibility = (AdminGroupAccessibility)ObjectHelper.defaultValue((Object)adminProductAccessor.getAdminGroupAccessibility(), (Object)AdminGroupAccessibility.NONE);
                switch (adminGroupAccessibility) {
                    case ALL: {
                        return true;
                    }
                    case SPECIFIC: {
                        return adminProductAccessor.getAccessibleAdminGroups().contains(user2.getGroup());
                    }
                }
                return false;
            }
            List list2 = productAccessor.getUserGroupAccessibility();
            if (list2.contains(UserGroupAccessibility.ALL)) {
                return true;
            }
            if (list2.contains(UserGroupAccessibility.OWN_GROUP_SET) && (group.equals((Object)group2) || groupSet != null && groupSet.equals((Object)groupSet2))) {
                return true;
            }
            if (list2.contains(UserGroupAccessibility.OWN_GROUP) && group.equals((Object)group2)) {
                return true;
            }
            if (list2.contains(UserGroupAccessibility.SPECIFIC) && ((list = productAccessor.getAccessibleUserGroups()).contains(group2) || list.contains(groupSet2))) {
                return true;
            }
            if (basicUser2.isBroker() && user.getBrokers().contains(basicUser2) && (list = productsAccessor.member().getShowBrokers()) != null) {
                switch (1.$SwitchMap$org$cyclos$model$users$products$BrokerVisibility[list.ordinal()]) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        User user3 = user.getMainBroker();
                        return basicUser2.equals((Object)user3);
                    }
                    case 3: {
                        return false;
                    }
                }
            }
            return false;
        }
        if (basicUser2 instanceof Operator) {
            if (user.equals((Object)basicUser2.getUser())) {
                if (basicUser.isRestrictedOperator()) {
                    OperatorGroup operatorGroup = ((Operator)basicUser).getGroup();
                    return operatorGroup.getPaymentTypes().stream().anyMatch(OperatorGroupPaymentType::isAuthorize);
                }
                return productAccessor.hasPermission(Permission.MY_OPERATORS_ENABLE);
            }
            return this.manages((BasicUser)user, (BasicUser)basicUser2.getUser()) && productAccessor.hasPermission(Permission.USER_OPERATORS_VIEW) || this.relatesTo((BasicUser)user, (BasicUser)basicUser2.getUser()) && productAccessor.hasPermission(Permission.USER_OPERATORS_PAY);
        }
        return false;
    }

    public boolean requiresValues(Permission permission) {
        if (permission == Permission.SPECIFIC_NETWORKS_MANAGE) {
            return true;
        }
        String string = this.collectionProperties.get(permission);
        return string != null;
    }

    private Collection<?> doGetRequiredValues(SessionData sessionData, Permission permission) {
        String string = this.collectionProperties.get(permission);
        if (string == null) {
            return null;
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (sessionData.isAdmin()) {
            return this.getCollectionPropertyValue((ProductAccessor)productsAccessor.admin(), string);
        }
        if (sessionData.isBroker()) {
            return CollectionHelper.union((Collection)this.getCollectionPropertyValue((ProductAccessor)productsAccessor.broker(), string), (Collection)this.getCollectionPropertyValue((ProductAccessor)productsAccessor.member(), string));
        }
        return this.getCollectionPropertyValue((ProductAccessor)productsAccessor.member(), string);
    }

    private Collection getCollectionPropertyValue(ProductAccessor productAccessor, String string) {
        try {
            return (Collection)InvocationContext.wrap((Object)productAccessor).getPropertyValue(string);
        }
        catch (NotReadablePropertyException notReadablePropertyException) {
            return null;
        }
    }

    private boolean validNetwork(BasicUser basicUser, BasicUser basicUser2) {
        if (!basicUser.isAdmin() || !basicUser.isGlobal()) {
            return Objects.equals(basicUser.getNetwork(), basicUser2.getNetwork());
        }
        if (basicUser.isGlobalAdmin()) {
            return true;
        }
        AdminGroup adminGroup = (AdminGroup)basicUser.getUser().getGroup();
        return basicUser2.isGlobal() || adminGroup.getManagedNetworks().contains(basicUser2.getNetwork());
    }
}

