/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.format.DateTimeFormatter;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.cyclos.archive.model.ArchivedAccountHistory;
import org.cyclos.archive.model.ArchivedAccountHistoryFilter;
import org.cyclos.archive.model.ArchivedInfo;
import org.cyclos.archive.model.ArchivedTransfer;
import org.cyclos.impl.ArchiveHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Component
public class ArchiveHandlerImpl
extends BaseNetworkedHandlerImpl
implements ArchiveHandler {
    private static final int TIMEOUT = 30000;
    @Autowired
    private CyclosProperties cyclosProperties;
    private String url;
    private RestTemplate api;

    public ArchivedAccountHistory accountHistory(ArchivedAccountHistoryFilter archivedAccountHistoryFilter) {
        if (this.api == null) {
            throw new ValidationException("Archiving not enabled");
        }
        Validator validator = new Validator();
        validator.property(this.propertyAccess("accountId"), BankingKeys.Transfers.ACCOUNT).required();
        validator.property(this.propertyAccess("begin"), GeneralKeys.Ui.PERIOD_BEGIN).required();
        validator.property(this.propertyAccess("end"), GeneralKeys.Ui.PERIOD_END).required();
        this.validate(validator, archivedAccountHistoryFilter, "accountHistory");
        String string = UriUtils.encode((String)archivedAccountHistoryFilter.getBegin().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), (Charset)StandardCharsets.UTF_8);
        String string2 = UriUtils.encode((String)archivedAccountHistoryFilter.getEnd().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), (Charset)StandardCharsets.UTF_8);
        URI uRI = UriComponentsBuilder.fromUriString((String)(this.url + "/api/account-history/" + archivedAccountHistoryFilter.getAccountId())).queryParam("begin", new Object[]{string}).queryParam("end", new Object[]{string2}).queryParam("currentPage", new Object[]{archivedAccountHistoryFilter.getCurrentPage()}).queryParam("pageSize", new Object[]{archivedAccountHistoryFilter.getPageSize()}).queryParam("skipTotalCount", new Object[]{archivedAccountHistoryFilter.isSkipTotalCount() || this.getSessionData().getConfiguration().isSkipTotalCount()}).build(true).toUri();
        return (ArchivedAccountHistory)this.api.getForObject(uRI, ArchivedAccountHistory.class);
    }

    public void archive() {
        if (this.api != null) {
            this.api.postForEntity(this.url + "/api/archive", null, Void.class, new Object[0]);
        }
    }

    public ArchivedInfo info() {
        if (this.api == null) {
            throw new ValidationException("Archiving not enabled");
        }
        URI uRI = UriComponentsBuilder.fromUriString((String)(this.url + "/api/info")).build().toUri();
        return (ArchivedInfo)this.api.getForObject(uRI, ArchivedInfo.class);
    }

    public ArchivedTransfer viewTransfer(Long l) {
        if (this.api == null) {
            throw new ValidationException("Archiving not enabled");
        }
        if (l == null) {
            throw new EntityNotFoundException(ArchivedTransfer.class);
        }
        URI uRI = UriComponentsBuilder.fromUriString((String)(this.url + "/api/transfer/{id}")).build(new Object[]{l});
        return (ArchivedTransfer)this.api.getForObject(uRI, ArchivedTransfer.class);
    }

    @PostConstruct
    protected void initialize() {
        this.url = this.cyclosProperties.getArchivingUrl();
        if (this.url != null) {
            SSLContext sSLContext;
            TrustStrategy trustStrategy;
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            if (this.cyclosProperties.isArchivingTrustAllCerts()) {
                trustStrategy = (x509CertificateArray, string) -> true;
                try {
                    sSLContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy).build();
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                    throw new IllegalStateException(generalSecurityException);
                }
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)new NoopHostnameVerifier()));
            }
            if (StringHelper.isNotBlank((Object)this.cyclosProperties.getArchivingUser())) {
                trustStrategy = HttpHost.create((String)this.cyclosProperties.getArchivingUrl());
                sSLContext = new BasicCredentialsProvider();
                sSLContext.setCredentials(new AuthScope((HttpHost)trustStrategy), (Credentials)new UsernamePasswordCredentials(this.cyclosProperties.getArchivingUser(), this.cyclosProperties.getArchivingPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)sSLContext);
            }
            trustStrategy = new HttpComponentsClientHttpRequestFactory();
            trustStrategy.setHttpClient((HttpClient)httpClientBuilder.build());
            trustStrategy.setConnectTimeout(30000);
            trustStrategy.setReadTimeout(0);
            this.api = new RestTemplate((ClientHttpRequestFactory)trustStrategy);
        }
    }

    private PropertyAccess propertyAccess(final String string) {
        return new PropertyAccess(){

            public Object get(Object object) {
                return InvocationContext.wrap((Object)object).getPropertyValue(string);
            }

            public Object getIdentifier() {
                return string;
            }

            public String getPropertyName() {
                return string;
            }
        };
    }
}

