/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.types.EntityPath;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javassist.util.proxy.Proxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUser;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.JPAUserVisibilityApplier;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.DataTranslationProxy;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.NotificationHandler;
import org.cyclos.impl.utils.persistence.BaseEntityManagerHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.transaction.TransactionHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractServerComponent {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Lazy
    protected TransactionHandler transactionHandler;
    @Autowired
    @Lazy
    protected TranslationHandler translationHandler;
    @Autowired
    @Lazy
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    protected ConfigurationHandler configurationHandler;
    @Autowired
    @Lazy
    protected AccountHandler accountHandler;
    @Autowired
    @Lazy
    protected NotificationHandler notificationHandler;
    @Autowired
    @Lazy
    protected ProfileFieldHandler profileFieldHandler;
    private Logger logger;

    public JPAUserVisibilityApplier visibility(DBQuery<?> dBQuery, QUser qUser) {
        return (JPAUserVisibilityApplier)((BeanHandler)InvocationContext.bean(BeanHandler.class)).autowire((Object)new JPAUserVisibilityApplier(dBQuery, qUser, qUser.group()));
    }

    protected <E> E dataTranslationProxy(E e) {
        return e == null ? null : (E)this.dataTranslationProxy(e, InvocationContext.getSessionData().getConfiguration().getLanguage());
    }

    protected <E> E dataTranslationProxy(E e, Language language) {
        return this.dataTranslationProxy(e, language, new IdentityHashMap<Object, Proxy>());
    }

    protected <E> E dataTranslationProxy(E e, Language language, IdentityHashMap<Object, Proxy> identityHashMap) {
        return (E)DataTranslationProxy.proxy(e, (DataTranslationHandler)this.dataTranslationHandler, (Language)language, identityHashMap);
    }

    protected JPADeleteClause delete(EntityPath<?> entityPath) {
        return this.getBaseEntityManagerHandler().delete(entityPath);
    }

    protected void detach(IEntity iEntity) {
        this.getBaseEntityManagerHandler().detach(iEntity);
    }

    protected <E extends IEntity> E find(Class<E> clazz, Long l) throws EntityNotFoundException {
        return (E)this.getBaseEntityManagerHandler().find(clazz, l);
    }

    protected void flush() {
        this.getBaseEntityManagerHandler().flush();
    }

    protected DBQuery<?> from(EntityPath<?> ... entityPathArray) {
        return this.getBaseEntityManagerHandler().from(entityPathArray);
    }

    protected DBQuery<?> fromCacheable(EntityPath<?> entityPath) {
        return this.getBaseEntityManagerHandler().fromCacheable(entityPath);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected abstract BaseEntityManagerHandler getBaseEntityManagerHandler();

    protected FormatterImpl getFormatter() {
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        return this.getFormatter(configurationAccessor);
    }

    protected FormatterImpl getFormatter(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        return this.getFormatter(configurationAccessor);
    }

    protected FormatterImpl getFormatter(ConfigurationAccessor configurationAccessor) {
        return InvocationContext.getFormatter((ConfigurationAccessor)configurationAccessor);
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        return this.logger;
    }

    protected String getRemoteAddress() {
        return this.getSessionData().getRemoteAddress();
    }

    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected MailContentProducer.MailContentBuilder mailContentBuilder() {
        return MailContentProducer.builder((MessageProducer)this.translationHandler);
    }

    protected String message(Language language, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(MessageFormat.NEW_LINE_TO_BR, language, messageKey, objectArray);
    }

    protected String message(MessageFormat messageFormat, Language language, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, language, messageKey, objectArray);
    }

    protected void persist(IEntity iEntity) {
        this.getBaseEntityManagerHandler().persist(iEntity);
    }

    protected <T> long processBatch(Iterable<T> iterable, Consumer<T> consumer) {
        if (iterable == null) {
            return 0L;
        }
        return this.processBatch(iterable.iterator(), consumer);
    }

    protected <T> long processBatch(Iterator<T> iterator, Consumer<T> consumer) {
        return QueryHelper.processBatch((BaseEntityManagerHandler)this.getBaseEntityManagerHandler(), iterator, consumer);
    }

    protected <E extends IEntity> E refresh(E e) {
        return (E)this.getBaseEntityManagerHandler().refresh(e);
    }

    protected void remove(IEntity iEntity) {
        this.getBaseEntityManagerHandler().remove(iEntity);
    }

    protected <E extends SimpleEntity> DBQuery<E> selectFrom(EntityPath<E> entityPath) {
        return this.getBaseEntityManagerHandler().selectFrom(entityPath);
    }

    protected <E extends SimpleEntity> DBQuery<E> selectFromCacheable(EntityPath<E> entityPath) {
        return this.getBaseEntityManagerHandler().selectFromCacheable(entityPath);
    }

    protected DBQuery<?> subQuery(EntityPath<?> ... entityPathArray) {
        return this.getBaseEntityManagerHandler().subQuery(entityPathArray);
    }

    protected JPAUpdateClause update(EntityPath<?> entityPath) {
        return this.getBaseEntityManagerHandler().update(entityPath);
    }
}

