/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_6;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclos.db.BaseMigration;
import org.cyclos.impl.ApplicationHandlerImpl;
import org.cyclos.license.core.CipherException;
import org.cyclos.license.core.CipherHelper;

public class NFCTokenMigration
extends BaseMigration {
    @Override
    public int run() throws Exception {
        byte[] byArray = (byte[])this.jdbcTemplate.queryForObject("SELECT license_key FROM application", byte[].class);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.jdbcTemplate.query("SELECT id, app_master_key, type_id, user_id FROM tokens WHERE subclass = ?", preparedStatement -> preparedStatement.setString(1, "NFC"), resultSet -> {
            long l = resultSet.getLong(1);
            long l2 = resultSet.getLong(3);
            long l3 = resultSet.getLong(4);
            byte[] byArray2 = this.encryptKey(resultSet.getBytes(2), l, l2, l3, byArray);
            if (byArray2 != null) {
                atomicInteger.addAndGet(this.jdbcTemplate.update("UPDATE tokens set (app_master_key, operational_key) = (?, ?) WHERE id = ?", preparedStatement -> {
                    preparedStatement.setBytes(1, byArray2);
                    preparedStatement.setBytes(2, byArray2);
                    preparedStatement.setLong(3, l);
                }));
            }
        });
        return atomicInteger.intValue();
    }

    private byte[] encryptKey(byte[] byArray, long l, long l2, long l3, byte[] byArray2) {
        try {
            String string = CipherHelper.decrypt((byte[])ApplicationHandlerImpl.deriveKey(byArray2, this.oldKeyMask(l2, l3)), (byte[])byArray);
            byte[] byArray3 = CipherHelper.encrypt((byte[])ApplicationHandlerImpl.deriveKey(byArray2, this.newKeyMask(l)), (String)string);
            return byArray3;
        }
        catch (CipherException cipherException) {
            return null;
        }
    }

    private byte[] newKeyMask(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }

    private byte[] oldKeyMask(long l, long l2) {
        return ByteBuffer.allocate(16).putLong(l).putLong(l2).array();
    }
}

