/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_3;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.channels.ChannelDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;

public class AccessClientChannelMigration
extends BaseMigration {
    @Override
    public int run() {
        Object object;
        Object object2;
        HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
            object2 = "/translations/translation-GENERAL";
            if (builtinLanguage != BuiltinLanguage.EN) {
                object2 = (String)object2 + "_" + String.valueOf(locale);
            }
            object2 = (String)object2 + ".properties";
            object = this.getClass().getResourceAsStream((String)object2);
            if (object == null) continue;
            hashMap.put(builtinLanguage, PropertiesHelper.from((InputStream)object));
        }
        Long l = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into channels (version, internal_name, name) values (0, ?, ?)", 1), preparedStatement -> {
            preparedStatement.setString(1, "accessClient");
            preparedStatement.setString(2, "accessClient");
            preparedStatement.execute();
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                resultSet.next();
                Long l = resultSet.getLong(1);
                return l;
            }
        });
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            object2 = (Properties)hashMap.get(builtinLanguage);
            if (object2 == null || !StringHelper.isNotBlank((Object)(object = ((Properties)object2).getProperty("INITIAL_DATA.channel.ACCESS_CLIENT")))) continue;
            this.jdbcTemplate.update("insert into data_translations (version, type, language, property_name, entity_id, value) values (0, ?, ?, ?, ?, ?)", new Object[]{DataTranslationType.CHANNEL.name(), builtinLanguage.name(), ChannelDTO.NAME.getName(), l, object});
        }
        Long l2 = (Long)this.jdbcTemplate.queryForObject("select id from configurations where parent_id is null", Long.class);
        this.jdbcTemplate.update("insert into channel_configurations    (version, subclass, channel_id, configuration_id, user_access, defined, locked, enabled)  values (0, 'DEFAULT', ?, ?, ?, true, false, true)", new Object[]{l, l2, UserChannelAccess.DEFAULT_ENABLED.name()});
        return 1;
    }
}

