/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_16;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.banking.accounts.AmountReservationNature;
import org.cyclos.utils.CollectionHelper;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class FixInconsistentAmountReservationsMigration
extends BaseMigration {
    @Override
    public int run() throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        int n = 0;
        n += this.fixTransactionAuthorization(hashSet);
        this.rebuildBalances(hashSet);
        return n += this.fixVoucherChargeback(hashSet);
    }

    private int fixTransactionAuthorization(Set<Long> set) {
        List list = this.jdbcTemplate.query(" select id, date, amount, from_id, to_id from transactions where id in (     select transaction_id     from amount_reservations     where transaction_id is not null and subclass = 'PENDING_AUTHORIZATION'     group by transaction_id     having count(*) > 2 ) order by id", (RowMapper)new BeanPropertyRowMapper(Transaction.class));
        if (list.isEmpty()) {
            return 0;
        }
        MutableInt mutableInt = new MutableInt();
        this.getLogger().warn("Found {} transactions with multiple amount authorization de-reservations:\n - {}", (Object)list.size(), (Object)StringUtils.join((Iterable)list, (String)"\n - "));
        list.forEach(transaction -> {
            int n = this.jdbcTemplate.update(" delete from amount_reservations where id in (     select id     from amount_reservations     where transaction_id = ?     and subclass = ?     order by date     offset 2 )", new Object[]{transaction.getId(), AmountReservationNature.PENDING_AUTHORIZATION.name()});
            if (n > 0) {
                mutableInt.add(n);
                set.add(transaction.getFromId());
            }
        });
        return mutableInt.intValue();
    }

    private int fixVoucherChargeback(Set<Long> set) {
        List list = this.jdbcTemplate.query(" select c.id as chargeback_id, c.date, ar.account_id, -ar.amount as reservation_amount from voucher_transactions c inner join voucher_transactions t on c.chargeback_of_id = t.id inner join amount_reservations ar on ar.voucher_transaction_id = t.id where c.subclass = 'CHARGEBACK'", (RowMapper)new BeanPropertyRowMapper(VoucherChargeback.class));
        if (list.isEmpty()) {
            return 0;
        }
        this.getLogger().info("Found {} voucher chargebacks without reservation:\n - {}", (Object)list.size(), (Object)StringUtils.join((Iterable)list, (String)"\n - "));
        list.forEach(voucherChargeback -> {
            this.jdbcTemplate.update(" insert into amount_reservations (subclass, account_id, date, amount, voucher_transaction_id) values (?, ?, ?, ?, ?)", new Object[]{AmountReservationNature.VOUCHER_TRANSACTION.name(), voucherChargeback.getAccountId(), voucherChargeback.getDate(), voucherChargeback.getReservationAmount(), voucherChargeback.getChargebackId()});
            set.add(voucherChargeback.getAccountId());
        });
        return list.size();
    }

    private int rebuildBalances(Set<Long> set) {
        if (set.isEmpty()) {
            return 0;
        }
        List list2 = CollectionHelper.sort(set);
        this.getLogger().info("Rebuilding balances for {} affected accounts:\n - {}", (Object)list2.size(), (Object)StringUtils.join((Iterable)list2, (String)"\n - "));
        MutableInt mutableInt = new MutableInt();
        ListUtils.partition((List)list2, (int)50).forEach(list -> {
            Map<String, List> map = Collections.singletonMap("ids", list);
            mutableInt.add((Number)this.namedParameterJdbcTemplate.queryForObject("select cy_rebuild_closed_account_balances(:ids)", map, Integer.class));
        });
        return mutableInt.intValue();
    }

    static class Transaction {
        private Long id;
        private Long fromId;
        private Long toId;
        private OffsetDateTime date;
        private BigDecimal amount;

        Transaction() {
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public OffsetDateTime getDate() {
            return this.date;
        }

        public Long getFromId() {
            return this.fromId;
        }

        public Long getId() {
            return this.id;
        }

        public Long getToId() {
            return this.toId;
        }

        public void setAmount(BigDecimal bigDecimal) {
            this.amount = bigDecimal;
        }

        public void setDate(OffsetDateTime offsetDateTime) {
            this.date = offsetDateTime;
        }

        public void setFromId(Long l) {
            this.fromId = l;
        }

        public void setId(Long l) {
            this.id = l;
        }

        public void setToId(Long l) {
            this.toId = l;
        }

        public String toString() {
            return String.format("Transaction id: %s, From: %s, To: %s, Date: %s, Amount: %s", this.id, this.fromId, this.toId, this.date, this.amount);
        }
    }

    static class VoucherChargeback {
        private Long chargebackId;
        private Long accountId;
        private BigDecimal reservationAmount;
        private OffsetDateTime date;

        VoucherChargeback() {
        }

        public Long getAccountId() {
            return this.accountId;
        }

        public Long getChargebackId() {
            return this.chargebackId;
        }

        public OffsetDateTime getDate() {
            return this.date;
        }

        public BigDecimal getReservationAmount() {
            return this.reservationAmount;
        }

        public void setAccountId(Long l) {
            this.accountId = l;
        }

        public void setChargebackId(Long l) {
            this.chargebackId = l;
        }

        public void setDate(OffsetDateTime offsetDateTime) {
            this.date = offsetDateTime;
        }

        public void setReservationAmount(BigDecimal bigDecimal) {
            this.reservationAmount = bigDecimal;
        }

        public String toString() {
            return String.format("Chargeback id: %s, Account id: %s, Date: %s, Amount: %s", this.chargebackId, this.accountId, this.date, this.reservationAmount);
        }
    }
}

