/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_13;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.ChannelDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;

public class OidcChannelMigration
extends BaseMigration {
    @Override
    public int run() {
        HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
        for (BuiltinLanguage builtinLanguageArray : BuiltinLanguage.values()) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguageArray);
            Object object = "/translations/translation-GENERAL";
            if (builtinLanguageArray != BuiltinLanguage.EN) {
                object = (String)object + "_" + String.valueOf(locale);
            }
            object = (String)object + ".properties";
            InputStream inputStream = this.getClass().getResourceAsStream((String)object);
            if (inputStream == null) continue;
            hashMap.put(builtinLanguageArray, PropertiesHelper.from((InputStream)inputStream));
        }
        int n = 0;
        BuiltInChannel builtInChannel = BuiltInChannel.OIDC;
        Long l = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into channels (version, internal_name, name) values (0, ?, ?)", 1), preparedStatement -> {
            preparedStatement.setString(1, builtInChannel.getInternalName());
            preparedStatement.setString(2, builtInChannel.getDisplayName());
            preparedStatement.execute();
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                resultSet.next();
                Long l = resultSet.getLong(1);
                return l;
            }
        });
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            String string;
            Properties properties = (Properties)hashMap.get(builtinLanguage);
            if (properties == null || !StringHelper.isNotBlank((Object)(string = properties.getProperty("INITIAL_DATA.channel.OIDC")))) continue;
            this.jdbcTemplate.update("insert into data_translations (version, language_id, type, property_name, entity_id, value)  select 0, id, ?, ?, ?, ? from languages where template = ?", new Object[]{DataTranslationType.CHANNEL.name(), ChannelDTO.NAME.getName(), l, string, builtinLanguage.name()});
        }
        return ++n;
    }
}

