/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_13;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.db.BaseMigration;
import org.springframework.jdbc.core.PreparedStatementSetter;

public abstract class FixDuplicatedAccountsMigration
extends BaseMigration {
    private static String DUPLICATED_PAIRS_QUERY = " SELECT user_id, account_type_id FROM accounts WHERE user_id is not null GROUP BY 1, 2 HAVING count(*) > 1";
    private static String DUPLICATED_ACCOUNTS_QUERY = "SELECT id FROM accounts WHERE user_id = ? AND account_type_id = ?";
    private int affected;

    @Override
    public int run() throws Exception {
        this.jdbcTemplate.query(DUPLICATED_PAIRS_QUERY, this::processDuplicatedPair);
        return this.affected;
    }

    protected abstract List<String> getTablesToUpdate();

    private void processDuplicatedPair(ResultSet resultSet2) throws SQLException {
        long l = resultSet2.getLong("user_id");
        long l2 = resultSet2.getLong("account_type_id");
        List list = this.jdbcTemplate.query(DUPLICATED_ACCOUNTS_QUERY, preparedStatement -> {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
        }, (resultSet, n) -> resultSet.getLong("id"));
        long l3 = (Long)list.stream().min(Long::compare).get();
        list.remove(l3);
        this.updateRelatedData(l3, list);
    }

    private void updateRelatedData(long l, List<Long> list) {
        PreparedStatementSetter preparedStatementSetter = preparedStatement -> {
            int n = 1;
            preparedStatement.setLong(n++, l);
            for (Long l2 : list) {
                preparedStatement.setLong(n++, l2);
            }
        };
        List<String> list2 = this.getTablesToUpdate();
        int n = 0;
        for (String string : list2) {
            String string2 = "account_id";
            if (string.equals("pins")) {
                string2 = "user_account_id";
            } else if (string.startsWith("transfers_")) {
                string2 = string.equals("transfers_from") ? "from_id" : "to_id";
                string = "transfers";
            } else if (string.startsWith("transactions_")) {
                string2 = string.equals("transactions_from") ? "from_id" : "to_id";
                string = "transactions";
            }
            String string3 = string2 + " IN (" + StringUtils.repeat((String)"?", (String)",", (int)list.size()) + ")";
            int n2 = this.jdbcTemplate.update(String.format("UPDATE %s SET %s = ? WHERE %s", string, string2, string3), preparedStatementSetter);
            this.affected += n2;
            if (!string.equals("account_rates")) continue;
            n = n2;
        }
        if (n > 0) {
            this.affected += this.jdbcTemplate.update("UPDATE accounts set account_rates_id = (SELECT id FROM account_rates WHERE account_id = ? ORDER BY transfer_time DESC LIMIT 1) WHERE id = ?", preparedStatement -> {
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l);
            });
        }
        PreparedStatementSetter preparedStatementSetter2 = preparedStatement -> {
            int n = 1;
            for (Long l : list) {
                preparedStatement.setLong(n++, l);
            }
        };
        list.add(l);
        this.affected += this.jdbcTemplate.update("DELETE FROM account_balances WHERE account_id IN (" + StringUtils.repeat((String)"?", (String)",", (int)list.size()) + ")", preparedStatementSetter2);
        this.affected += this.jdbcTemplate.update("DELETE FROM closed_account_balances WHERE account_id IN (" + StringUtils.repeat((String)"?", (String)",", (int)list.size()) + ")", preparedStatementSetter2);
        this.affected += this.jdbcTemplate.update("DELETE FROM dirty_account_balances WHERE account_id IN (" + StringUtils.repeat((String)"?", (String)",", (int)list.size()) + ")", preparedStatementSetter2);
        list.remove(l);
        this.affected += this.jdbcTemplate.update("DELETE FROM accounts WHERE id IN (" + StringUtils.repeat((String)"?", (String)",", (int)list.size()) + ")", preparedStatementSetter2);
    }
}

