/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_12;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.db.BaseMigration;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class UseTimestampWithTZMigration
extends BaseMigration {
    @Override
    public String getAffectedMessage() {
        return "{} tables affected while executing migration class: {}";
    }

    @Override
    public int run() throws Exception {
        List<Map<String, Object>> list = this.getAffectedIndexes();
        list.stream().map(map -> map.get("index_name")).forEach(object -> this.jdbcTemplate.execute("DROP INDEX \"" + String.valueOf(object) + "\""));
        List<String> list2 = this.generateDDL();
        if (!list2.isEmpty()) {
            this.jdbcTemplate.execute("DROP VIEW users_brokers, user_main_broker");
        }
        list2.stream().forEach(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).execute(arg_0));
        list.stream().map(map -> (String)map.get("index_def")).forEach(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).execute(arg_0));
        if (!list2.isEmpty()) {
            this.jdbcTemplate.execute("create view users_brokers as\n        select user_id, broker_id\n        from brokerings\n        where end_date is null");
            this.jdbcTemplate.execute("create rule users_brokers_del as on delete to users_brokers\n    do instead nothing");
            this.jdbcTemplate.execute("create view user_main_broker as\n        select user_id, broker_id\n        from brokerings b\n        where end_date is null\n             and main_broker = true");
            this.jdbcTemplate.execute("create rule user_main_broker_del as on delete to user_main_broker\n        do instead nothing");
        }
        return list2.size();
    }

    private List<String> generateDDL() {
        String string3 = "SELECT table_name, column_name FROM information_schema.columns WHERE data_type = 'timestamp without time zone' ORDER BY 1, 2";
        return this.jdbcTemplate.query(string3, (RowMapper)new ColumnMapRowMapper()).stream().collect(Collectors.toMap(map -> "ALTER TABLE " + String.valueOf(map.get("table_name")), map -> " ALTER COLUMN " + String.valueOf(map.get("column_name")) + " TYPE timestamptz", (string, string2) -> string + "," + string2)).entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getAffectedIndexes() {
        String string = "select\n    i.relname as index_name,\n    ixs.indexdef as index_def\nfrom\n    pg_class t,\n    pg_class i,\n    pg_index ix,\n    pg_attribute a,\n    information_schema.columns c,\n    pg_indexes ixs\nwhere\n    t.oid = ix.indrelid\n    and i.oid = ix.indexrelid\n    and a.attrelid = t.oid\n    and a.attnum = ANY(ix.indkey)\n    and t.relkind = 'r'\n    and t.relname = c.table_name\n    and a.attname = c.column_name\n    and c.data_type = 'timestamp without time zone'\n    and ixs.tablename = t.relname\n    and ixs.indexname = i.relname\ngroup by\n    i.relname,\n    ixs.indexdef\norder by\n    i.relname";
        return this.jdbcTemplate.query(string, (RowMapper)new ColumnMapRowMapper());
    }
}

