/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ComparatorUtils;
import org.cyclos.utils.StringHelper;

public class VersionScript {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\s*VERSION\\s+(\\d+)\\s*((ALIAS\\s+)([\\.|\\w]+))?\\s*\\;?\\s*$");
    private static final int ALIAS_VERSION = 4;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*#");
    private final int version;
    private final String alias;
    private final String script;

    public static SortedMap<Integer, VersionScript> readScripts(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            Object object;
            String string;
            int n = -1;
            String string2 = null;
            TreeMap treeMap = new TreeMap(ComparatorUtils.naturalComparator().reversed());
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || COMMENT_PATTERN.matcher(string).find()) continue;
                object = VERSION_PATTERN.matcher(string);
                if (((Matcher)object).find()) {
                    boolean bl = n == -1;
                    int n2 = Integer.parseInt(((Matcher)object).group(1));
                    if (!bl) {
                        VersionScript versionScript = new VersionScript(n, string2, stringBuilder.toString());
                        treeMap.put(n, versionScript);
                        stringBuilder.setLength(0);
                    }
                    n = n2;
                    string2 = ((Matcher)object).group(4);
                    continue;
                }
                if (n < 0) continue;
                stringBuilder.append(string).append('\n');
            }
            if (n >= 0) {
                object = new VersionScript(n, string2, stringBuilder.toString());
                treeMap.put(n, object);
            }
            object = Collections.unmodifiableSortedMap(treeMap);
            return object;
        }
    }

    public VersionScript(int n, String string, String string2) {
        this.version = n;
        this.alias = string;
        this.script = string2;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getScript() {
        return this.script;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isAlias() {
        return StringHelper.isNotBlank((Object)this.alias);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VERSION ").append(this.version);
        if (this.alias != null) {
            stringBuilder.append(" ALIAS ").append(this.alias);
        } else if (this.script != null) {
            stringBuilder.append('\n').append(this.script);
        }
        return stringBuilder.toString();
    }
}

