/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.RawDataSourceProvider;
import org.cyclos.impl.sql.DbLockHandler;
import org.cyclos.impl.sql.postgresql.PostgresqlLockHandlerImpl;
import org.postgresql.ds.PGSimpleDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;
import org.stro.dbdiff.LoadFromDatabaseOptions;
import org.stro.dbdiff.MetadataHandler;
import org.stro.dbdiff.PostgreSQLMetadataHandler;
import org.stro.dbdiff.model.DatabaseMetadata;

public class GenerateDbSchema {
    private static Logger LOG = LogManager.getLogger(GenerateDbSchema.class);
    public static final String HOST = "localhost";
    public static final String DB = "cyclos";
    public static final String USER = "cyclos";
    public static final String PASSWORD = "cyclos";
    public static LoadFromDatabaseOptions CYCLOS_DB_OPTIONS = new LoadFromDatabaseOptions().schema("public").includeFunctions("cy_%").excludeSequences("%_id_seq").excludeViews("geo%|raster%");
    private static final String MIN_POSTGRESQL_VERSION = "12";
    public static final int MIN_POSTGRESQL_VERSION_NUM = GenerateDbSchema.toServerVersionNum("12");
    private static final String MIN_POSTGIS_VERSION = "2.5";
    private File outFile;
    private String versions;
    private String containerId;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;
    private JdbcTemplate jdbcTemplate;

    public static void main(String[] stringArray) throws SQLException, IOException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new IllegalArgumentException(String.format("Wrong parameters (%s): %s%nExpected 1 or 2: outputFile [pgVersion-postgisVersion]. Default versions: %s-%s", stringArray.length, Stream.of(stringArray).collect(Collectors.joining(", ")), MIN_POSTGRESQL_VERSION, MIN_POSTGIS_VERSION));
        }
        new GenerateDbSchema(new File(stringArray[0]), stringArray.length == 2 ? stringArray[1] : null).process(null);
    }

    public static int toServerVersion(int n) {
        return n / 10000;
    }

    public static int toServerVersionNum(String string) {
        return Integer.parseInt(string) * 10000;
    }

    public GenerateDbSchema() {
        this(null);
    }

    public GenerateDbSchema(File file) {
        this(file, null);
    }

    public GenerateDbSchema(File file, String string) {
        this.outFile = file;
        this.versions = string == null ? String.format("%s-%s", MIN_POSTGRESQL_VERSION, MIN_POSTGIS_VERSION) : string;
    }

    public void process(Integer n) throws SQLException, IOException {
        int n2 = this.initializeConnection(n);
        if (n == null) {
            this.startContainer(n2);
        }
        try {
            if (this.waitForContainer(n2)) {
                this.createCyclosDatabase(n2);
                if (this.outFile != null) {
                    this.doGenerateDescriptor();
                } else {
                    LOG.info("Output file is null. The descriptor was not generated!");
                }
            } else {
                LOG.error("PostgreSQL in container didn't respond!!!");
            }
        }
        finally {
            this.stopContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCyclosDatabase(int n) throws IOException, SQLException {
        Properties properties = new Properties();
        properties.setProperty("cyclos.datasource.provider", "hikari");
        properties.setProperty("cyclos.datasource.dataSourceClassName", PGSimpleDataSource.class.getName());
        properties.setProperty("cyclos.datasource.dataSource.portNumber", String.valueOf(n));
        properties.setProperty("cyclos.datasource.dataSource.serverName", HOST);
        properties.setProperty("cyclos.datasource.dataSource.databaseName", "cyclos");
        properties.setProperty("cyclos.datasource.dataSource.user", "cyclos");
        properties.setProperty("cyclos.datasource.dataSource.password", "cyclos");
        properties.setProperty("cyclos.maxRecurringTasks", "0");
        properties.setProperty("cyclos.maxBackgroundTasks", "0");
        properties.setProperty("cyclos.db.managed", "true");
        properties.setProperty("eclipselink.target-database", "org.cyclos.bootstrap.CyclosPostgreSQLPlatform");
        properties.setProperty("eclipselink.logging.logger", "org.cyclos.bootstrap.EclipseLinkSLF4JLogger");
        File file = File.createTempFile("cyclos", ".properties");
        file.deleteOnExit();
        properties.store(new FileWriter(file), "Temp properties");
        System.setProperty("cyclos.properties", file.getAbsolutePath());
        try (AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext();){
            annotationConfigApplicationContext.register(new Class[]{GenerateDbSchemaConfiguration.class});
            annotationConfigApplicationContext.refresh();
        }
        finally {
            file.delete();
        }
    }

    private void doGenerateDescriptor() throws SQLException, IOException {
        LOG.info("Generating database metadata...");
        PostgreSQLMetadataHandler postgreSQLMetadataHandler = new PostgreSQLMetadataHandler();
        DatabaseMetadata databaseMetadata = (DatabaseMetadata)this.transactionTemplate.execute(arg_0 -> this.lambda$doGenerateDescriptor$0((MetadataHandler)postgreSQLMetadataHandler, arg_0));
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.outFile);){
            postgreSQLMetadataHandler.storeJson(databaseMetadata, (OutputStream)fileOutputStream);
        }
        LOG.info("Database metadata generated successfully in " + this.outFile.getAbsolutePath());
    }

    private int initializeConnection(Integer n) throws IOException, SQLException {
        Object object;
        if (n == null) {
            object = new ServerSocket(0);
            try {
                n = ((ServerSocket)object).getLocalPort();
            }
            finally {
                ((ServerSocket)object).close();
            }
        }
        object = new PGSimpleDataSource();
        object.setPortNumbers(new int[]{n});
        object.setServerNames(new String[]{HOST});
        object.setDatabaseName("cyclos");
        object.setUser("cyclos");
        object.setPassword("cyclos");
        this.dataSource = object;
        this.transactionManager = new JdbcTransactionManager(this.dataSource);
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return n;
    }

    private void startContainer(int n) throws IOException {
        Process process = new ProcessBuilder(new String[0]).command("docker", "run", "-d", "-e", "POSTGRES_DB=cyclos", "-e", "POSTGRES_USER=cyclos", "-e", "POSTGRES_PASSWORD=cyclos", "-p", n + ":5432", String.format("postgis/postgis:%s", this.versions)).start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            if (bufferedReader != null) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(bufferedReader.lines().collect(Collectors.toList()));
                if (!arrayList.isEmpty()) {
                    LOG.info("DOCKER errors log:");
                    arrayList.stream().forEach(string -> LOG.info("\n" + string));
                }
            }
        }
        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            this.containerId = bufferedReader.readLine().trim();
            LOG.info(String.format("Started docker container with id %s (%s)", this.containerId, this.versions));
        }
        finally {
            bufferedReader.close();
        }
    }

    private void stopContainer() throws IOException {
        if (this.containerId != null) {
            new ProcessBuilder(new String[0]).command("docker", "rm", "-f", this.containerId).start();
        }
    }

    private boolean waitForContainer(int n) {
        long l = System.currentTimeMillis();
        LOG.info("Waiting until the container at localhost:" + n + " is available...");
        while (System.currentTimeMillis() - l < 60000L) {
            try {
                this.transactionTemplate.executeWithoutResult(transactionStatus -> this.jdbcTemplate.queryForObject("select 1", Integer.class));
                return true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        return false;
    }

    private /* synthetic */ DatabaseMetadata lambda$doGenerateDescriptor$0(MetadataHandler metadataHandler, TransactionStatus transactionStatus) {
        return metadataHandler.loadFromDatabase(this.jdbcTemplate, CYCLOS_DB_OPTIONS);
    }

    @Configuration
    @Import(value={BootstrapConfiguration.class})
    public static class GenerateDbSchemaConfiguration {
        @Autowired
        protected RawDataSourceProvider rawDataSourceProvider;

        @Bean
        public DbLockHandler dbLockHandler() {
            return new PostgresqlLockHandlerImpl(new JdbcTemplate(this.rawDataSourceProvider.getRawDataSource()));
        }

        @PostConstruct
        private void initialize() {
            this.dbLockHandler().prepare();
        }
    }
}

