/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.GenerateDDLControl;
import org.cyclos.server.utils.IOHelper;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={BootstrapConfiguration.class})
public class GenerateDDL {
    private static Pattern VIEW_PATTERN = Pattern.compile("create\\s+view\\s+(\\w+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDDL(EntityManagerFactoryImpl entityManagerFactoryImpl) {
        DatabaseSessionImpl databaseSessionImpl = entityManagerFactoryImpl.getDatabaseSession();
        StringWriter stringWriter = new StringWriter();
        SchemaManager schemaManager = new SchemaManager(databaseSessionImpl);
        schemaManager.outputDDLToWriter((Writer)stringWriter);
        DefaultTableGenerator defaultTableGenerator = new DefaultTableGenerator(databaseSessionImpl.getProject()){

            protected void resetFieldTypeForLOB(DirectToFieldMapping directToFieldMapping) {
            }
        };
        TableCreator tableCreator = defaultTableGenerator.generateDefaultTableCreator();
        tableCreator.createTables((DatabaseSession)databaseSessionImpl, schemaManager);
        String[] stringArray = StringUtils.split((String)stringWriter.toString(), (char)';');
        String string = GenerateDDL.readFile("other-tables.ddl");
        String string2 = GenerateDDL.readFile("views.ddl");
        String string3 = GenerateDDL.readFile("functions.ddl");
        String string4 = GenerateDDL.readFile("triggers.ddl");
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = VIEW_PATTERN.matcher(string2);
        while (matcher.find()) {
            arrayList.add(StringUtils.trim((String)matcher.group(1)));
        }
        stringWriter.getBuffer().setLength(0);
        printWriter.println(GenerateDDL.readFile("header.ddl"));
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            for (String string5 : stringArray) {
                if ((string5 = StringUtils.trimToNull((String)string5)) == null) continue;
                boolean bl = false;
                for (String string6 : arrayList) {
                    if (!string5.contains(string6)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                printWriter.println(string5.toLowerCase() + ";");
            }
            printWriter.println();
            printWriter.println(string);
            printWriter.println();
            printWriter.println(string2);
            printWriter.println();
            printWriter.println(string3);
            printWriter.println();
            printWriter.println(string4);
            printWriter.println();
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("cyclos.maxBackgroundTasks", "0");
        System.setProperty("cyclos.maxRecurringTasks", "0");
        try (AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext();){
            annotationConfigApplicationContext.register(new Class[]{GenerateDDL.class});
            annotationConfigApplicationContext.refresh();
            GenerateDDLControl generateDDLControl = (GenerateDDLControl)annotationConfigApplicationContext.getBean(GenerateDDLControl.class);
            File file = new File(generateDDLControl.getExportSchemaToFile());
            if (file.exists()) {
                System.out.println("Script exported to " + file.getCanonicalPath());
                System.out.println("If you are in Eclipse, don't forget to refresh that folder");
            } else {
                System.out.println("WARNING: The file was not created!!!");
            }
        }
    }

    private static String readFile(String string) {
        InputStream inputStream = GenerateDDL.class.getResourceAsStream("/db/" + string);
        if (inputStream == null) {
            throw new IllegalStateException("Couldn't find DDL file " + string);
        }
        try {
            String string2 = StringUtils.join((Iterable)IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (String)"\n");
            return string2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't read DDL file " + string, iOException);
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    @Bean
    public GenerateDDLControl generateDDLControl() {
        GenerateDDLControl generateDDLControl = new GenerateDDLControl();
        generateDDLControl.setExportSchemaOnly(true);
        generateDDLControl.setExportSchemaToFile("../cyclos4-impl/build/db/cyclos4.ddl");
        return generateDDLControl;
    }
}

