/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.db.Migration;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class BaseMigration
implements Migration {
    protected JdbcTemplate jdbcTemplate;
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected CyclosProperties cyclosProperties;
    private Logger logger;

    protected static String inPlaceholders(Collection<?> collection) {
        return BaseMigration.inPlaceholders(collection.size());
    }

    protected static String inPlaceholders(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        return stringBuilder.append(')').toString();
    }

    protected static String inPlaceholders(Object[] objectArray) {
        return BaseMigration.inPlaceholders(objectArray.length);
    }

    @Override
    public void initialize(JdbcTemplate jdbcTemplate, CyclosProperties cyclosProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.cyclosProperties = cyclosProperties;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        return this.logger;
    }
}

