/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.db.DatabasePopulator;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.Role;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.UserProductNotificationDTO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDatabasePopulator
implements DatabasePopulator {
    @Autowired
    protected EntityManagerHandler entityManagerHandler;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected EntityLogServiceLocal entityServiceLocalService;
    protected Random random = new Random();

    protected <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>> Map<String, PV> createPossibleValues(CF CF, Class<PV> clazz, String ... stringArray) {
        LinkedHashMap<String, CustomFieldPossibleValue> linkedHashMap = new LinkedHashMap<String, CustomFieldPossibleValue>();
        for (String string : stringArray) {
            CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)ClassHelper.instantiate(clazz);
            customFieldPossibleValue.setField(CF);
            customFieldPossibleValue.setValue(string);
            customFieldPossibleValue.setInternalName(StringHelper.camelize((String)string));
            this.persist((IEntity)customFieldPossibleValue);
            linkedHashMap.put(string, customFieldPossibleValue);
            CF.getPossibleValues().add(customFieldPossibleValue);
        }
        return linkedHashMap;
    }

    protected List<UserProductNotificationDTO> createProductNotifications(List<UserNotificationType> list) {
        ArrayList<UserProductNotificationDTO> arrayList = new ArrayList<UserProductNotificationDTO>();
        for (UserNotificationType userNotificationType : list) {
            UserProductNotificationDTO userProductNotificationDTO = new UserProductNotificationDTO();
            userProductNotificationDTO.setType(userNotificationType);
            userProductNotificationDTO.setEnabled(true);
            userProductNotificationDTO.setAllowMail(true);
            arrayList.add(userProductNotificationDTO);
        }
        return arrayList;
    }

    protected List<UserProductNotificationDTO> createProductNotifications(UserNotificationType ... userNotificationTypeArray) {
        return this.createProductNotifications(Arrays.asList(userNotificationTypeArray));
    }

    protected <T extends SimpleEntity> T find(Class<T> clazz, Long l) {
        return (T)((SimpleEntity)this.rawEntityManagerHandler.find(clazz, l));
    }

    protected DBQuery<?> from(EntityPathBase<?> ... entityPathBaseArray) {
        return this.rawEntityManagerHandler.from(entityPathBaseArray);
    }

    protected IntegerRangeDTO intRange(int n, int n2) {
        IntegerRangeDTO integerRangeDTO = new IntegerRangeDTO();
        integerRangeDTO.setMin(Integer.valueOf(n));
        integerRangeDTO.setMax(Integer.valueOf(n2));
        return integerRangeDTO;
    }

    protected <T> List<T> listAll(EntityPathBase<T> entityPathBase) {
        return this.from(entityPathBase).select(entityPathBase).fetch();
    }

    protected void persist(IEntity iEntity) {
        this.entityManagerHandler.persist(iEntity);
        if (iEntity instanceof BaseEntity) {
            this.entityServiceLocalService.logEntity(null, (SimpleEntity)((BaseEntity)iEntity), null);
        }
    }

    protected int random(IntegerRange integerRange) {
        return this.random.nextInt(integerRange.getMax() - integerRange.getMin()) + integerRange.getMin();
    }

    protected <E extends BaseEntity, DTO extends EntityDTO> E save(CRUDServiceLocal<E, DTO, ?, ?> cRUDServiceLocal, DTO DTO) {
        Long l = cRUDServiceLocal.save(DTO);
        BaseEntity baseEntity = (BaseEntity)cRUDServiceLocal.find(l);
        this.rawEntityManagerHandler.flush();
        return (E)((BaseEntity)this.rawEntityManagerHandler.refresh((IEntity)baseEntity));
    }

    protected void setDefaultQuickAccess(ProductDTO productDTO, QuickAccessType ... quickAccessTypeArray) {
        Stream<Object> stream;
        productDTO.setMyQuickAccessSettingsEnable(true);
        if (CollectionHelper.isEmpty((Object[])quickAccessTypeArray)) {
            Role role = productDTO instanceof AdminProductDTO ? Role.ADMIN : (productDTO instanceof BrokerProductDTO ? Role.BROKER : Role.MEMBER);
            stream = QuickAccessType.getByRole((Role)role).stream();
        } else {
            stream = Stream.of(quickAccessTypeArray);
        }
        productDTO.setDefaultQuickAccess(stream.map(quickAccessType -> new QuickAccessDTO((Property)QuickAccessDTO.TYPE, quickAccessType)).collect(Collectors.toSet()));
    }

    protected <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>> void setRandomValue(CustomFieldValue<CF, C, PV, ?> customFieldValue) {
        CustomField customField = customFieldValue.getField();
        List list = customField.getPossibleValues();
        switch (customField.getType()) {
            case BOOLEAN: {
                customFieldValue.setBooleanValue(Boolean.valueOf(this.random.nextBoolean()));
                break;
            }
            case DATE: {
                customFieldValue.setDateValue((IDate)DateWrapper.instance((Date)new Date(new GregorianCalendar(this.random.nextInt(30) + 1980, this.random.nextInt(12), this.random.nextInt(27) + 1).getTimeInMillis())));
                break;
            }
            case DECIMAL: {
                customFieldValue.setDecimalValue(new BigDecimal((double)this.random.nextInt(10000) / 2.0));
                break;
            }
            case SINGLE_SELECTION: {
                CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)CollectionHelper.random((List)list);
                customFieldValue.setEnumeratedValue(customFieldPossibleValue);
                break;
            }
            case MULTI_SELECTION: {
                customFieldValue.setEnumeratedValues(new HashSet());
                for (CustomFieldPossibleValue customFieldPossibleValue : list) {
                    if (!this.random.nextBoolean()) continue;
                    customFieldValue.getEnumeratedValues().add(customFieldPossibleValue);
                }
                break;
            }
            case INTEGER: {
                customFieldValue.setIntegerValue(Integer.valueOf(this.random.nextInt(1000)));
                break;
            }
            case STRING: {
                customFieldValue.setStringValue(StringHelper.randomAlphabetic((int)10));
                break;
            }
            case RICH_TEXT: {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < 10; ++i) {
                    if (i > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(StringHelper.randomAlphabetic((int)10));
                }
                customFieldValue.setRichTextValue(stringBuilder.toString());
                break;
            }
            case TEXT: {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < 10; ++i) {
                    if (i > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(StringHelper.randomAlphabetic((int)10));
                }
                customFieldValue.setTextValue(stringBuilder.toString());
                break;
            }
            case URL: {
                customFieldValue.setStringValue("http://www." + StringHelper.randomAlphabetic((int)5) + ".com");
                break;
            }
        }
    }
}

