/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.cyclos.bootstrap.DataSourceType;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    public RoutingDataSource(DataSource dataSource, DataSource dataSource2) {
        ConcurrentHashMap<DataSourceType, DataSource> concurrentHashMap = new ConcurrentHashMap<DataSourceType, DataSource>();
        concurrentHashMap.put(DataSourceType.READ_ONLY, dataSource2);
        concurrentHashMap.put(DataSourceType.READ_WRITE, dataSource);
        this.setTargetDataSources(concurrentHashMap);
        this.setDefaultTargetDataSource(dataSource);
    }

    protected Object determineCurrentLookupKey() {
        return TransactionSynchronizationManager.isCurrentTransactionReadOnly() ? DataSourceType.READ_ONLY : DataSourceType.READ_WRITE;
    }
}

