/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.CyclosVersion;
import org.cyclos.bootstrap.GenerateDDLControl;
import org.cyclos.bootstrap.RawDataSourceProvider;
import org.cyclos.db.DatabaseHistory;
import org.cyclos.db.DatabaseUpgrade;
import org.cyclos.db.GenerateDDL;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.jdbc.ScriptHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.RunnableExceptionWrapper;
import org.cyclos.server.utils.ThreadHelper;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="databaseManager")
public class DatabaseManager {
    private static final Logger LOG = LogManager.getLogger(DatabaseManager.class);
    @Autowired
    private DatabaseHistory databaseHistory;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private RawDataSourceProvider rawDataSourceProvider;
    @Autowired(required=false)
    private GenerateDDLControl generateDDLControl;
    @Autowired(required=false)
    private NativeQueryHandler nativeQueryHandler;
    private PlatformTransactionManager dataSourceTransactionManager;
    private TransactionTemplate dataSourceTransactionTemplate;
    private JdbcTemplate dataSourceJdbcTemplate;

    public void doWithCyclosInstanceLock(Runnable runnable) {
        this.dataSourceTransactionTemplate.executeWithoutResult(transactionStatus -> {
            this.lockCyclosInstance();
            ((RunnableExceptionWrapper)ThreadHelper.runInNewThread((Runnable)new RunnableExceptionWrapper(runnable))).throwIfNeeded();
        });
    }

    @PostConstruct
    public void initialize() {
        DataSource dataSource = this.rawDataSourceProvider.getRawDataSource();
        this.dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        this.dataSourceTransactionTemplate = new TransactionTemplate(this.dataSourceTransactionManager);
        this.dataSourceJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void manageDatabase(EntityManagerFactory entityManagerFactory) throws SQLException {
        if (this.generateDDLControl != null && this.generateDDLControl.isExportSchemaOnly()) {
            this.createSchema(entityManagerFactory);
        } else if (this.cyclosProperties.isDbManaged()) {
            this.doManageDatabase(entityManagerFactory);
        }
    }

    private void createSchema(EntityManagerFactory entityManagerFactory) throws SQLException {
        if (entityManagerFactory instanceof EntityManagerFactoryImpl) {
            String string = GenerateDDL.generateDDL((EntityManagerFactoryImpl)entityManagerFactory);
            if (this.generateDDLControl != null && this.generateDDLControl.isExportSchemaOnly()) {
                File file = new File(this.generateDDLControl.getExportSchemaToFile());
                try {
                    FileUtils.writeStringToFile((File)file, (String)string, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error exporting database schema to " + file.getAbsolutePath(), iOException);
                }
            } else {
                LOG.info("Cyclos database schema was not found. Creating it.");
                this.dataSourceTransactionTemplate.execute(transactionStatus -> {
                    ScriptHelper.runSilently(this.dataSourceJdbcTemplate, string, false, this.cyclosProperties);
                    return null;
                });
            }
        } else {
            throw new IllegalStateException("Database schema generation is only supported under EclipseLink");
        }
    }

    private DatabaseUpgrade.Status doManageDatabase(EntityManagerFactory entityManagerFactory) throws SQLException {
        DatabaseUpgrade databaseUpgrade = new DatabaseUpgrade(this.dataSourceTransactionTemplate, this.dataSourceJdbcTemplate, this.databaseHistory, this.cyclosProperties);
        DatabaseUpgrade.Status status = databaseUpgrade.getStatus();
        if (status == DatabaseUpgrade.Status.INVALID) {
            throw new IllegalStateException(String.format("Cyclos database has an invalid version: (%s_db%d)", databaseUpgrade.getCurrentApplicationVersion(), databaseUpgrade.getCurrentDbVersion()));
        }
        if (status == DatabaseUpgrade.Status.UP_TO_DATE) {
            LOG.info("Cyclos version {} ({}), database is up-to-date (version {}_db{})", (Object)CyclosVersion.get(), (Object)CyclosVersion.getCommitId(), (Object)databaseUpgrade.getCurrentApplicationVersion(), (Object)databaseUpgrade.getCurrentDbVersion());
        } else if (status == DatabaseUpgrade.Status.NEEDS_UPGRADE) {
            LOG.info("Cyclos version {} ({}), database needs upgrade (currently at version {}_db{})", (Object)CyclosVersion.get(), (Object)CyclosVersion.getCommitId(), (Object)databaseUpgrade.getCurrentApplicationVersion(), (Object)databaseUpgrade.getCurrentDbVersion());
            databaseUpgrade.upgrade();
        } else if (status == DatabaseUpgrade.Status.NO_SCHEMA) {
            this.createSchema(entityManagerFactory);
        }
        if (status != DatabaseUpgrade.Status.NO_SCHEMA) {
            databaseUpgrade.removeStalePermissions();
        }
        return status;
    }

    private void lockCyclosInstance() {
        if (this.nativeQueryHandler == null) {
            return;
        }
        LockKey lockKey = LockType.APPLICATION.nullKey();
        int n = 0;
        while (!this.nativeQueryHandler.tryLock(this.dataSourceJdbcTemplate, lockKey)) {
            if (n++ % 10 == 0) {
                LOG.info("Another instance is currently managing the database. Waiting...");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

