/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import javax.sql.DataSource;
import org.cyclos.bootstrap.DataSourceShutdownHandler;
import org.cyclos.bootstrap.RawDataSourceProvider;
import org.cyclos.bootstrap.RoutingDataSource;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.sql.CachingDataSource;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="dataSource")
public class DataSourceFactoryBean
extends AbstractFactoryBean<DataSource> {
    @Autowired
    private DataSourceShutdownHandler dataSourceShutdownHandler;
    @Autowired(required=false)
    @Lazy
    private CacheHandler cacheHandler;
    @Autowired
    @Qualifier(value="READ_WRITE")
    private RawDataSourceProvider readWriteDataSourceProvider;
    @Autowired
    @Qualifier(value="READ_ONLY")
    private RawDataSourceProvider readOnlyDataSourceProvider;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private BeanHandler beanHandler;

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    protected DataSource createInstance() throws Exception {
        if (this.cyclosProperties.isUseReadOnlyDataSource()) {
            String string = StringHelper.trimToNull((Object)this.readWriteDataSourceProvider.getConnectionDetails());
            String string2 = StringHelper.trimToNull((Object)this.readOnlyDataSourceProvider.getConnectionDetails());
            if (string != null && string2 != null) {
                this.logger.info((Object)("Connecting to 2 databases:\n- Master database: " + string + "\n- Read-only database: " + string2));
            }
            DataSource dataSource = this.readWriteDataSourceProvider.getRawDataSource();
            DataSource dataSource2 = this.readOnlyDataSourceProvider.getRawDataSource();
            if (this.cacheHandler != null && this.cyclosProperties.isCacheQueries()) {
                dataSource = (DataSource)this.beanHandler.autowireWithArgs(CachingDataSource.class, new Object[]{dataSource});
                dataSource2 = (DataSource)this.beanHandler.autowireWithArgs(CachingDataSource.class, new Object[]{dataSource2});
            }
            return (DataSource)this.beanHandler.autowireWithArgs(RoutingDataSource.class, new Object[]{dataSource, dataSource2});
        }
        String string = StringHelper.trimToNull((Object)this.readWriteDataSourceProvider.getConnectionDetails());
        if (string != null) {
            this.logger.info((Object)("Connecting to database " + string));
        }
        DataSource dataSource = this.readWriteDataSourceProvider.getRawDataSource();
        if (this.cacheHandler != null && this.cyclosProperties.isCacheQueries()) {
            dataSource = (DataSource)this.beanHandler.autowireWithArgs(CachingDataSource.class, new Object[]{dataSource});
        }
        return dataSource;
    }

    protected void destroyInstance(DataSource dataSource) throws Exception {
        this.dataSourceShutdownHandler.execute();
        if (this.cyclosProperties.isUseReadOnlyDataSource()) {
            this.readOnlyDataSourceProvider.destroy();
        }
        this.readWriteDataSourceProvider.destroy();
    }
}

