/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class CyclosPropertiesFactoryBean
extends AbstractFactoryBean<CyclosProperties> {
    public static final String CLUSTER_K8S_DNS = "CLUSTER_K8S_DNS";
    public static final String CLUSTER_AWS_TAG = "CLUSTER_AWS_TAG";
    public static final String CLUSTER_GCP_LABEL = "CLUSTER_GCP_LABEL";
    public static final String CLUSTER_MULTICAST = "CLUSTER_MULTICAST";
    public static final String CLUSTER_TCPIP = "CLUSTER_TCPIP";
    public static final List<String> CLUSTER_ENV = Collections.unmodifiableList(Arrays.asList("CLUSTER_K8S_DNS", "CLUSTER_AWS_TAG", "CLUSTER_GCP_LABEL", "CLUSTER_MULTICAST", "CLUSTER_TCPIP"));
    public static final String CYCLOS_PROPERTIES = "cyclos.properties";
    private static final Logger LOG = LogManager.getLogger(CyclosPropertiesFactoryBean.class);
    @Autowired(required=false)
    private ServletContext servletContext;
    private String propertiesFile = "cyclos.properties";

    public static Map<String, String> getClusterEnv() {
        return CLUSTER_ENV.stream().filter(string -> StringHelper.isNotBlank((Object)System.getenv(string))).collect(Collectors.toMap(string -> string, System::getenv));
    }

    public static String getCyclosPropertiesFileName(String string) {
        Object object;
        try {
            object = System.getProperty(CYCLOS_PROPERTIES, string);
        }
        catch (Throwable throwable) {
            object = string;
        }
        File file = new File((String)object);
        if (file.exists() && file.isFile()) {
            return file.getAbsolutePath();
        }
        object = "/" + StringHelper.removeStart((String)object, (String)"/");
        return object;
    }

    public CyclosPropertiesFactoryBean() {
    }

    public CyclosPropertiesFactoryBean(String string) {
        this.setPropertiesFile(string);
    }

    public Class<?> getObjectType() {
        return CyclosProperties.class;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String string) {
        this.propertiesFile = string;
    }

    protected CyclosProperties createInstance() throws Exception {
        Properties properties = this.readProperties();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = System.getProperty("java.io.tmpdir");
        hashMap.put("%t", string);
        if (this.servletContext == null) {
            hashMap.put("%w", string + "/cyclos4");
        } else {
            hashMap.put("%w", this.servletContext.getRealPath("/"));
        }
        return new CyclosProperties(properties, hashMap);
    }

    private Pair<Properties, String> doReadProperties(String string) throws IOException {
        String string2 = null;
        File file = new File(string);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
        URL uRL = ((Object)((Object)this)).getClass().getResource(string);
        if (inputStream == null && file.exists() && file.isFile()) {
            inputStream = new FileInputStream(file);
            string2 = file.getAbsolutePath();
        } else {
            if (inputStream == null) {
                return null;
            }
            string2 = uRL.toString();
        }
        Properties properties = new Properties();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            properties.load(inputStream);
        }
        return Pair.create((Object)properties, (Object)string2);
    }

    private Properties readProperties() throws IOException {
        String string = CyclosPropertiesFactoryBean.getCyclosPropertiesFileName(this.propertiesFile);
        Pair<Properties, String> pair = this.doReadProperties(string);
        if (pair == null) {
            if (string.equals("/cyclos.properties")) {
                throw new IOException("File WEB-INF/classes/" + StringHelper.removeStart((String)string, (String)"/") + " not found. Did you forget to copy cyclos-release.properties to cyclos.properties to setup your database?");
            }
            throw new FileNotFoundException(string);
        }
        LOG.info("Cyclos properties read from {}", pair.getSecond());
        Properties properties = (Properties)pair.getFirst();
        String string2 = string.replace(".properties", "-local.properties");
        pair = this.doReadProperties(string2);
        if (pair != null) {
            LOG.info("Cyclos local overrides read from {}", pair.getSecond());
            properties.putAll((Map<?, ?>)((Map)pair.getFirst()));
        }
        if (!CyclosPropertiesFactoryBean.getClusterEnv().isEmpty()) {
            properties.setProperty("cyclos.clusterHandler", "hazelcast");
        }
        return properties;
    }
}

