/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaDialect;

public class CyclosEclipseLinkJpaDialect
extends EclipseLinkJpaDialect {
    private static final long serialVersionUID = 1L;
    private final DataSource dataSource;

    public CyclosEclipseLinkJpaDialect(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean bl) throws PersistenceException, SQLException {
        if (bl) {
            return new AutoCommitConnectionHandle();
        }
        return super.getJdbcConnection(entityManager, bl);
    }

    private class AutoCommitConnectionHandle
    implements ConnectionHandle {
        private Connection connection;

        private AutoCommitConnectionHandle() {
        }

        public Connection getConnection() {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.connection = CyclosEclipseLinkJpaDialect.this.dataSource.getConnection();
                }
                return this.connection;
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException("Error opening an underlying JDBC connection", sQLException);
            }
        }

        public void releaseConnection(Connection connection) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException("Error closing an underlying JDBC connection", sQLException);
            }
        }
    }
}

