/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import javax.sql.DataSource;
import org.cyclos.bootstrap.BootstrapPackage;
import org.cyclos.bootstrap.CyclosPropertiesFactoryBean;
import org.cyclos.bootstrap.EntityManagerFactoryBean;
import org.cyclos.db.DatabaseHistory;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.sql.DatabaseCachingMetadata;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.ServerUtilsPackage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@ComponentScan(basePackageClasses={BootstrapPackage.class, ServerUtilsPackage.class})
public class BootstrapConfiguration {
    @Autowired
    private DataSource dataSource;

    @Bean
    public CyclosPropertiesFactoryBean cyclosProperties() {
        return new CyclosPropertiesFactoryBean();
    }

    @Bean
    public DatabaseCachingMetadata databaseCachingMetadata() throws Exception {
        return new DatabaseCachingMetadata();
    }

    @Bean
    public DatabaseHistory databaseHistory() {
        return new DatabaseHistory();
    }

    @Bean
    public EntityManagerFactoryBean entityManagerFactory() throws Exception {
        EntityManagerFactoryBean entityManagerFactoryBean = (EntityManagerFactoryBean)((Object)ClassHelper.instantiateDynamic(EntityManagerFactoryBean.class, (String)"cyclos.entityManagerFactory", EntityManagerFactoryBean.class));
        entityManagerFactoryBean.setDataSource(this.dataSource);
        entityManagerFactoryBean.setPackagesToScan(new String[]{SimpleEntity.class.getPackageName()});
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new EclipseLinkJpaVendorAdapter());
        return entityManagerFactoryBean;
    }

    @Bean
    public PlatformTransactionManager transactionManager() throws Exception {
        JpaTransactionManager jpaTransactionManager = new JpaTransactionManager(this.entityManagerFactory().getObject());
        jpaTransactionManager.setDataSource(this.dataSource);
        return jpaTransactionManager;
    }

    @Bean
    public TransactionTemplate transactionTemplate() throws Exception {
        return new TransactionTemplate(this.transactionManager());
    }
}

