/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CustomBean;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BeanHandlerImpl
implements BeanHandler {
    private static final Logger LOGGER = LogManager.getLogger(BeanHandlerImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    private ConcurrentMap<String, Object> cachedBeans = new ConcurrentHashMap<String, Object>();

    public <T> T autowire(Class<T> clazz) {
        return this.doAutowire(clazz, clazz);
    }

    public <T> T autowire(Object object) {
        return (T)this.initializeBean(object.getClass(), object);
    }

    public <T> T autowireWithArgs(Class<T> clazz, Object ... objectArray) {
        T t = this.instantiateWithArgs(clazz, objectArray);
        return this.initializeBean(clazz, t);
    }

    public <T extends CustomBean> T customBean(Class<T> clazz, String string) {
        return (T)((CustomBean)this.cachedBeans.computeIfAbsent(string, string2 -> {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Invalid class: " + string);
            }
            CustomBeanInvocationHandler customBeanInvocationHandler = new CustomBeanInvocationHandler(clazz, clazz2);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)customBeanInvocationHandler);
        }));
    }

    @PreDestroy
    public void destroy() {
        this.cachedBeans.values().forEach(this::destroy);
    }

    public void destroy(Object object) {
        InvocationHandler invocationHandler;
        if (object == null) {
            return;
        }
        if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof CustomBeanInvocationHandler && (object = ((CustomBeanInvocationHandler)invocationHandler).bean) == null) {
            return;
        }
        invocationHandler = this.applicationContext.getAutowireCapableBeanFactory();
        try {
            invocationHandler.destroyBean(object);
        }
        catch (Exception exception) {
            LOGGER.warn("Error destroying bean " + String.valueOf(object), (Throwable)exception);
        }
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Exception exception) {
                LOGGER.warn("Error closing bean " + String.valueOf(object), (Throwable)exception);
            }
        }
    }

    public <T> T getBean(Class<T> clazz) {
        return this.doGetBean(clazz, clazz.getName());
    }

    public <T extends CustomBean> T getBean(Class<T> clazz, String string) {
        return (T)((CustomBean)this.doGetBean(clazz, string));
    }

    public <T> T instantiate(Class<T> clazz) {
        return (T)ClassHelper.instantiate(clazz);
    }

    public <T> T instantiateWithArgs(Class<T> clazz, Object ... objectArray) {
        try {
            return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])objectArray);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not instantiate bean of class " + clazz.getName(), exception);
        }
    }

    private <T> T doAutowire(Class<T> clazz, Class<?> clazz2) {
        Object obj = this.instantiate(clazz2);
        return this.initializeBean(clazz, obj);
    }

    private <T> T doGetBean(Class<T> clazz, String string) {
        Object object = this.cachedBeans.get(string);
        if (object == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
            T t = this.doAutowire(clazz, clazz2);
            Object object2 = this.cachedBeans.putIfAbsent(string, t);
            object = ObjectHelper.defaultValue((Object)object2, t);
        }
        return (T)object;
    }

    private <T> T initializeBean(Class<T> clazz, Object object) {
        AutowireCapableBeanFactory autowireCapableBeanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        autowireCapableBeanFactory.autowireBean(object);
        return (T)autowireCapableBeanFactory.initializeBean(object, clazz.getName());
    }

    private class CustomBeanInvocationHandler
    implements InvocationHandler {
        private final Class<?> type;
        private final Class<?> rawType;
        private volatile Object bean;

        public CustomBeanInvocationHandler(Class<?> clazz, Class<?> clazz2) {
            this.type = clazz;
            this.rawType = clazz2;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            int n;
            String string = method.getName();
            int n2 = n = objectArray == null ? 0 : objectArray.length;
            if (string.equals("toString") && n == 0) {
                return "Lazy " + this.type.getSimpleName();
            }
            if (string.equals("hashCode") && n == 0) {
                return this.type.hashCode();
            }
            if (string.equals("equals") && n == 1) {
                return objectArray[0] == object || objectArray[0] == this.bean;
            }
            try {
                return method.invoke(this.bean(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object bean() {
            if (this.bean == null) {
                CustomBeanInvocationHandler customBeanInvocationHandler = this;
                synchronized (customBeanInvocationHandler) {
                    if (this.bean == null) {
                        this.bean = BeanHandlerImpl.this.doAutowire(this.type, this.rawType);
                    }
                }
            }
            return this.bean;
        }
    }
}

