/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.cyclos.bootstrap.DataSourceProvider;
import org.cyclos.bootstrap.RawDataSourceProvider;
import org.cyclos.impl.BeanHandler;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class BaseDataSourceProviderFactoryBean
extends AbstractFactoryBean<RawDataSourceProvider> {
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private BeanHandler beanHandler;
    private Properties dataSourceProperties;
    private DataSourceProvider dataSourceProvider;

    public Class<?> getObjectType() {
        return RawDataSourceProvider.class;
    }

    @PostConstruct
    public void initialize() throws Exception {
        this.dataSourceProvider = (DataSourceProvider)this.beanHandler.getBean(DataSourceProvider.class, this.cyclosProperties.getDataSourceProviderClass());
        this.dataSourceProperties = this.resolveDataSourceProperties(this.cyclosProperties);
        this.dataSourceProvider.initialize(this.dataSourceProperties);
    }

    protected RawDataSourceProvider createInstance() {
        return new RawDataSourceProvider(){

            @Override
            public void destroy() throws Exception {
                BaseDataSourceProviderFactoryBean.this.logger.info((Object)("Closing data source " + this.getConnectionDetails()));
                BaseDataSourceProviderFactoryBean.this.dataSourceProvider.destroy();
            }

            @Override
            public String getConnectionDetails() {
                return BaseDataSourceProviderFactoryBean.this.dataSourceProvider.getConnectionDetails(BaseDataSourceProviderFactoryBean.this.dataSourceProperties);
            }

            @Override
            public DataSource getRawDataSource() {
                return BaseDataSourceProviderFactoryBean.this.dataSourceProvider.get();
            }
        };
    }

    protected void destroyInstance(RawDataSourceProvider rawDataSourceProvider) throws Exception {
    }

    protected abstract Properties resolveDataSourceProperties(CyclosProperties var1);
}

