/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.utils.queryextensions;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.annotations.QueryDelegate;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.Date;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.entities.utils.queryextensions.CustomOperator;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.utils.FieldHelper;

public class DateQueryExtensions {
    @QueryDelegate(value=Date.class)
    public static DateTimeExpression<Date> addDays(Expression<Date> expression, Expression<Integer> expression2) {
        return Expressions.dateTimeOperation(Date.class, (Operator)CustomOperator.ADD_DAYS, (Expression[])new Expression[]{expression, expression2});
    }

    @QueryDelegate(value=Date.class)
    public static DateTimeExpression<Date> addDays(Expression<Date> expression, Integer n) {
        return Expressions.dateTimeOperation(Date.class, (Operator)CustomOperator.ADD_DAYS, (Expression[])new Expression[]{expression, Expressions.constant((Object)n)});
    }

    @QueryDelegate(value=Date.class)
    public static DateTimeExpression<Date> addInterval(Expression<Date> expression, Expression<TimeInterval> expression2) {
        NumberPath numberPath = (NumberPath)FieldHelper.get(expression2, (String)TimeIntervalDTO.AMOUNT.getName());
        EnumPath enumPath = (EnumPath)FieldHelper.get(expression2, (String)TimeIntervalDTO.FIELD.getName());
        return Expressions.dateTimeOperation(Date.class, (Operator)CustomOperator.ADD_INTERVAL, (Expression[])new Expression[]{expression, numberPath, enumPath});
    }

    @QueryDelegate(value=Date.class)
    public static Predicate future(Expression<Date> expression) {
        return Expressions.asDate(expression).gt((Expression)DateTimeExpression.currentTimestamp(Date.class));
    }

    @QueryDelegate(value=Date.class)
    public static Predicate past(Expression<Date> expression) {
        return Expressions.asDate(expression).lt((Expression)DateTimeExpression.currentTimestamp(Date.class));
    }

    @QueryDelegate(value=Date.class)
    public static Predicate period(Expression<Date> expression, DatePeriod datePeriod) {
        Date date;
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        Date date2 = datePeriod == null ? null : datePeriod.getBegin();
        Date date3 = date = datePeriod == null ? null : datePeriod.getEnd();
        if (date2 != null || date != null) {
            DateExpression dateExpression = Expressions.asDate(expression);
            if (date2 != null) {
                booleanBuilder.and((Predicate)dateExpression.goe((Comparable)date2));
            }
            if (date != null) {
                booleanBuilder.and((Predicate)dateExpression.loe((Comparable)date));
            }
        }
        return booleanBuilder;
    }

    @QueryDelegate(value=Date.class)
    public static NumberExpression<Long> unixTimestamp(Expression<Date> expression) {
        return Expressions.numberOperation(Long.class, (Operator)CustomOperator.UNIX_TIMESTAMP, (Expression[])new Expression[]{expression});
    }
}

